/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.haplotypecaller;

import java.io.Serializable;
import java.util.Comparator;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.DeBruijnAssemblyGraph;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.DeBruijnVertex;

public class DeBruijnEdge {
    private int multiplicity;
    private boolean isRef;

    public DeBruijnEdge() {
        this.multiplicity = 1;
        this.isRef = false;
    }

    public DeBruijnEdge(boolean isRef) {
        this.multiplicity = 1;
        this.isRef = isRef;
    }

    public DeBruijnEdge(boolean isRef, int multiplicity) {
        this.multiplicity = multiplicity;
        this.isRef = isRef;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(int value) {
        this.multiplicity = value;
    }

    public boolean isRef() {
        return this.isRef;
    }

    public void setIsRef(boolean isRef) {
        this.isRef = isRef;
    }

    public boolean equals(DeBruijnAssemblyGraph graph, DeBruijnEdge edge) {
        return ((DeBruijnVertex)graph.getEdgeSource(this)).equals(graph.getEdgeSource(edge)) && ((DeBruijnVertex)graph.getEdgeTarget(this)).equals(graph.getEdgeTarget(edge));
    }

    public boolean equals(DeBruijnAssemblyGraph graph, DeBruijnEdge edge, DeBruijnAssemblyGraph graph2) {
        return ((DeBruijnVertex)graph.getEdgeSource(this)).equals(graph2.getEdgeSource(edge)) && ((DeBruijnVertex)graph.getEdgeTarget(this)).equals(graph2.getEdgeTarget(edge));
    }

    public static class EdgeWeightComparator
    implements Comparator<DeBruijnEdge>,
    Serializable {
        @Override
        public int compare(DeBruijnEdge edge1, DeBruijnEdge edge2) {
            return edge1.multiplicity - edge2.multiplicity;
        }
    }
}

