/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.haplotypecaller;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.gatk.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.VariantCallContext;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.LikelihoodCalculationEngine;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class GenotypingEngine {
    private final boolean DEBUG;
    private final boolean USE_FILTERED_READ_MAP_FOR_ANNOTATIONS;
    private static final List<Allele> noCall = new ArrayList<Allele>();
    private static final Allele SYMBOLIC_UNASSEMBLED_EVENT_ALLELE = Allele.create("<UNASSEMBLED_EVENT>", false);
    private final VariantAnnotatorEngine annotationEngine;

    public GenotypingEngine(boolean DEBUG, VariantAnnotatorEngine annotationEngine, boolean USE_FILTERED_READ_MAP_FOR_ANNOTATIONS) {
        this.DEBUG = DEBUG;
        this.annotationEngine = annotationEngine;
        this.USE_FILTERED_READ_MAP_FOR_ANNOTATIONS = USE_FILTERED_READ_MAP_FOR_ANNOTATIONS;
        noCall.add(Allele.NO_CALL);
    }

    @Requires(value={"refLoc.containsP(activeRegionWindow)", "haplotypes.size() > 0"})
    @Ensures(value={"result != null"})
    public List<VariantContext> assignGenotypeLikelihoods(UnifiedGenotyperEngine UG_engine, List<Haplotype> haplotypes, List<String> samples, Map<String, PerReadAlleleLikelihoodMap> haplotypeReadMap, Map<String, List<GATKSAMRecord>> perSampleFilteredReadList, byte[] ref, GenomeLoc refLoc, GenomeLoc activeRegionWindow, GenomeLocParser genomeLocParser, List<VariantContext> activeAllelesToGenotype) {
        if (UG_engine == null) {
            throw new IllegalArgumentException("UG_Engine input can't be null, got " + UG_engine);
        }
        if (haplotypes == null || haplotypes.isEmpty()) {
            throw new IllegalArgumentException("haplotypes input should be non-empty and non-null, got " + haplotypes);
        }
        if (samples == null || samples.isEmpty()) {
            throw new IllegalArgumentException("samples input must be non-empty and non-null, got " + samples);
        }
        if (haplotypeReadMap == null || haplotypeReadMap.isEmpty()) {
            throw new IllegalArgumentException("haplotypeReadMap input should be non-empty and non-null, got " + haplotypeReadMap);
        }
        if (ref == null || ref.length == 0) {
            throw new IllegalArgumentException("ref bytes input should be non-empty and non-null, got " + ref);
        }
        if (refLoc == null || refLoc.getStop() - refLoc.getStart() + 1 != ref.length) {
            throw new IllegalArgumentException(" refLoc must be non-null and length must match ref bytes, got " + refLoc);
        }
        if (activeRegionWindow == null) {
            throw new IllegalArgumentException("activeRegionWindow must be non-null, got " + activeRegionWindow);
        }
        if (activeAllelesToGenotype == null) {
            throw new IllegalArgumentException("activeAllelesToGenotype must be non-null, got " + activeAllelesToGenotype);
        }
        if (genomeLocParser == null) {
            throw new IllegalArgumentException("genomeLocParser must be non-null, got " + genomeLocParser);
        }
        ArrayList<VariantContext> returnCalls = new ArrayList<VariantContext>();
        boolean in_GGA_mode = !activeAllelesToGenotype.isEmpty();
        TreeSet<Integer> startPosKeySet = new TreeSet<Integer>();
        int count = 0;
        if (this.DEBUG) {
            System.out.println("=== Best Haplotypes ===");
        }
        for (Haplotype h : haplotypes) {
            h.setEventMap(GenotypingEngine.generateVCsFromAlignment(h, h.getAlignmentStartHapwrtRef(), h.getCigar(), ref, h.getBases(), refLoc, "HC" + count++));
            if (!in_GGA_mode) {
                startPosKeySet.addAll(h.getEventMap().keySet());
            }
            if (!this.DEBUG) continue;
            System.out.println(h.toString());
            System.out.println("> Cigar = " + h.getCigar());
            System.out.println(">> Events = " + h.getEventMap());
        }
        GenotypingEngine.cleanUpSymbolicUnassembledEvents(haplotypes);
        if (!in_GGA_mode && samples.size() >= 10) {
            this.mergeConsecutiveEventsBasedOnLD(haplotypes, samples, haplotypeReadMap, startPosKeySet, ref, refLoc);
            GenotypingEngine.cleanUpSymbolicUnassembledEvents(haplotypes);
        }
        if (in_GGA_mode) {
            for (VariantContext compVC : activeAllelesToGenotype) {
                startPosKeySet.add(compVC.getStart());
            }
        }
        Iterator<Object> i$ = startPosKeySet.iterator();
        while (i$.hasNext()) {
            Map<String, PerReadAlleleLikelihoodMap> alleleReadMap;
            GenotypesContext genotypes;
            VariantCallContext call;
            int loc = (Integer)i$.next();
            if (loc < activeRegionWindow.getStart() || loc > activeRegionWindow.getStop()) continue;
            ArrayList<VariantContext> eventsAtThisLoc = new ArrayList<VariantContext>();
            ArrayList<String> priorityList = new ArrayList<String>();
            if (!in_GGA_mode) {
                for (Haplotype h : haplotypes) {
                    Map<Integer, VariantContext> eventMap = h.getEventMap();
                    VariantContext vc = eventMap.get(loc);
                    if (vc == null || GenotypingEngine.containsVCWithMatchingAlleles(eventsAtThisLoc, vc)) continue;
                    eventsAtThisLoc.add(vc);
                    priorityList.add(vc.getSource());
                }
            } else {
                int compCount = 0;
                for (VariantContext compVC : activeAllelesToGenotype) {
                    if (compVC.getStart() == loc) {
                        int alleleCount = 0;
                        for (Allele compAltAllele : compVC.getAlternateAlleles()) {
                            ArrayList<Allele> alleleSet = new ArrayList<Allele>(2);
                            alleleSet.add(compVC.getReference());
                            alleleSet.add(compAltAllele);
                            String vcSourceName = "Comp" + compCount + "Allele" + alleleCount;
                            VariantContext candidateEventToAdd = new VariantContextBuilder(compVC).alleles((Collection<Allele>)alleleSet).source(vcSourceName).make();
                            boolean alreadyExists = false;
                            for (VariantContext eventToTest : eventsAtThisLoc) {
                                if (!eventToTest.hasSameAllelesAs(candidateEventToAdd)) continue;
                                alreadyExists = true;
                            }
                            if (!alreadyExists) {
                                priorityList.add(vcSourceName);
                                eventsAtThisLoc.add(candidateEventToAdd);
                            }
                            ++alleleCount;
                        }
                    }
                    ++compCount;
                }
            }
            if (eventsAtThisLoc.isEmpty()) continue;
            Map<Event, List<Haplotype>> eventMapper = GenotypingEngine.createEventMapper(loc, eventsAtThisLoc, haplotypes);
            this.validatePriorityList(priorityList, eventsAtThisLoc);
            VariantContext mergedVC = GATKVariantContextUtils.simpleMerge(eventsAtThisLoc, priorityList, GATKVariantContextUtils.FilteredRecordMergeType.KEEP_IF_ANY_UNFILTERED, GATKVariantContextUtils.GenotypeMergeType.PRIORITIZE, false, false, null, false, false);
            if (mergedVC == null) continue;
            if (eventsAtThisLoc.size() != mergedVC.getAlternateAlleles().size()) {
                throw new ReviewedStingException("Record size mismatch! Something went wrong in the merging of alleles.");
            }
            LinkedHashMap<VariantContext, Allele> mergeMap = new LinkedHashMap<VariantContext, Allele>();
            mergeMap.put(null, mergedVC.getReference());
            for (int iii = 0; iii < mergedVC.getAlternateAlleles().size(); ++iii) {
                mergeMap.put((VariantContext)eventsAtThisLoc.get(iii), mergedVC.getAlternateAllele(iii));
            }
            Map<Allele, List<Haplotype>> alleleMapper = GenotypingEngine.createAlleleMapper(mergeMap, eventMapper);
            if (this.DEBUG) {
                System.out.println("Genotyping event at " + loc + " with alleles = " + mergedVC.getAlleles());
            }
            if ((call = UG_engine.calculateGenotypes(new VariantContextBuilder(mergedVC).genotypes(genotypes = this.calculateGLsForThisEvent(samples, alleleReadMap = this.convertHaplotypeReadMapToAlleleReadMap(haplotypeReadMap, alleleMapper, UG_engine.getUAC().CONTAMINATION_FRACTION, UG_engine.getUAC().contaminationLog), mergedVC)).make(), UG_engine.getUAC().GLmodel)) == null) continue;
            Map<String, PerReadAlleleLikelihoodMap> alleleReadMap_annotations = this.USE_FILTERED_READ_MAP_FOR_ANNOTATIONS ? alleleReadMap : this.convertHaplotypeReadMapToAlleleReadMap(haplotypeReadMap, alleleMapper, 0.0, UG_engine.getUAC().contaminationLog);
            Map<String, PerReadAlleleLikelihoodMap> stratifiedReadMap = GenotypingEngine.filterToOnlyOverlappingReads(genomeLocParser, alleleReadMap_annotations, perSampleFilteredReadList, call);
            VariantContext annotatedCall = this.annotationEngine.annotateContext(stratifiedReadMap, call);
            if (annotatedCall.getAlleles().size() != mergedVC.getAlleles().size()) {
                annotatedCall = GATKVariantContextUtils.reverseTrimAlleles(annotatedCall);
            }
            returnCalls.add(annotatedCall);
        }
        return returnCalls;
    }

    @Requires(value={"samples != null", "alleleReadMap!= null", "mergedVC != null"})
    @Ensures(value={"result != null"})
    private GenotypesContext calculateGLsForThisEvent(List<String> samples, Map<String, PerReadAlleleLikelihoodMap> alleleReadMap, VariantContext mergedVC) {
        GenotypesContext genotypes = GenotypesContext.create(samples.size());
        for (String sample : samples) {
            int numHaplotypes = mergedVC.getAlleles().size();
            double[] genotypeLikelihoods = new double[numHaplotypes * (numHaplotypes + 1) / 2];
            double[][] haplotypeLikelihoodMatrix = LikelihoodCalculationEngine.computeDiploidHaplotypeLikelihoods(sample, alleleReadMap, mergedVC.getAlleles());
            int glIndex = 0;
            for (int iii = 0; iii < numHaplotypes; ++iii) {
                for (int jjj = 0; jjj <= iii; ++jjj) {
                    genotypeLikelihoods[glIndex++] = haplotypeLikelihoodMatrix[iii][jjj];
                }
            }
            genotypes.add(new GenotypeBuilder(sample).alleles(noCall).PL(genotypeLikelihoods).make());
        }
        return genotypes;
    }

    private void validatePriorityList(List<String> priorityList, List<VariantContext> eventsAtThisLoc) {
        for (VariantContext vc : eventsAtThisLoc) {
            if (priorityList.contains(vc.getSource())) continue;
            throw new ReviewedStingException("Event found on haplotype that wasn't added to priority list. Something went wrong in the merging of alleles.");
        }
        for (String name : priorityList) {
            boolean found = false;
            for (VariantContext vc : eventsAtThisLoc) {
                if (!vc.getSource().equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new ReviewedStingException("Event added to priority list but wasn't found on any haplotype. Something went wrong in the merging of alleles.");
        }
    }

    private static Map<String, PerReadAlleleLikelihoodMap> filterToOnlyOverlappingReads(GenomeLocParser parser, Map<String, PerReadAlleleLikelihoodMap> perSampleReadMap, Map<String, List<GATKSAMRecord>> perSampleFilteredReadList, VariantContext call) {
        LinkedHashMap<String, PerReadAlleleLikelihoodMap> returnMap = new LinkedHashMap<String, PerReadAlleleLikelihoodMap>();
        GenomeLoc callLoc = parser.createGenomeLoc(call);
        for (Map.Entry<String, PerReadAlleleLikelihoodMap> sample : perSampleReadMap.entrySet()) {
            PerReadAlleleLikelihoodMap likelihoodMap = new PerReadAlleleLikelihoodMap();
            for (Map.Entry<GATKSAMRecord, Map<Allele, Double>> mapEntry : sample.getValue().getLikelihoodReadMap().entrySet()) {
                if (!callLoc.overlapsP(parser.createGenomeLoc(mapEntry.getKey()))) continue;
                for (Map.Entry<Allele, Double> alleleDoubleEntry : mapEntry.getValue().entrySet()) {
                    likelihoodMap.add(mapEntry.getKey(), alleleDoubleEntry.getKey(), alleleDoubleEntry.getValue());
                }
            }
            for (GATKSAMRecord read : perSampleFilteredReadList.get(sample.getKey())) {
                if (!callLoc.overlapsP(parser.createGenomeLoc(read))) continue;
                for (Allele allele : call.getAlleles()) {
                    likelihoodMap.add(read, allele, (Double)0.0);
                }
            }
            returnMap.put(sample.getKey(), likelihoodMap);
        }
        return returnMap;
    }

    @Requires(value={"haplotypes != null"})
    protected static void cleanUpSymbolicUnassembledEvents(List<Haplotype> haplotypes) {
        ArrayList<Haplotype> haplotypesToRemove = new ArrayList<Haplotype>();
        for (Haplotype h : haplotypes) {
            for (VariantContext vc : h.getEventMap().values()) {
                if (!vc.isSymbolic()) continue;
                block2: for (Haplotype h2 : haplotypes) {
                    for (VariantContext vc2 : h2.getEventMap().values()) {
                        if (vc.getStart() != vc2.getStart() || !vc2.isIndel() && !vc2.isMNP()) continue;
                        haplotypesToRemove.add(h);
                        continue block2;
                    }
                }
            }
        }
        haplotypes.removeAll(haplotypesToRemove);
    }

    protected Map<String, PerReadAlleleLikelihoodMap> convertHaplotypeReadMapToAlleleReadMap(Map<String, PerReadAlleleLikelihoodMap> haplotypeReadMap, Map<Allele, List<Haplotype>> alleleMapper, double downsamplingFraction, PrintStream downsamplingLog) {
        LinkedHashMap<String, PerReadAlleleLikelihoodMap> alleleReadMap = new LinkedHashMap<String, PerReadAlleleLikelihoodMap>();
        for (Map.Entry<String, PerReadAlleleLikelihoodMap> haplotypeReadMapEntry : haplotypeReadMap.entrySet()) {
            PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap = new PerReadAlleleLikelihoodMap();
            for (Map.Entry<Allele, List<Haplotype>> alleleMapperEntry : alleleMapper.entrySet()) {
                List<Haplotype> mappedHaplotypes = alleleMapperEntry.getValue();
                for (Map.Entry<GATKSAMRecord, Map<Allele, Double>> readEntry : haplotypeReadMapEntry.getValue().getLikelihoodReadMap().entrySet()) {
                    double maxLikelihood = Double.NEGATIVE_INFINITY;
                    for (Map.Entry<Allele, Double> alleleDoubleEntry : readEntry.getValue().entrySet()) {
                        if (!mappedHaplotypes.contains(new Haplotype(alleleDoubleEntry.getKey()))) continue;
                        maxLikelihood = Math.max(maxLikelihood, alleleDoubleEntry.getValue());
                    }
                    perReadAlleleLikelihoodMap.add(readEntry.getKey(), alleleMapperEntry.getKey(), (Double)maxLikelihood);
                }
            }
            perReadAlleleLikelihoodMap.performPerAlleleDownsampling(downsamplingFraction, downsamplingLog);
            alleleReadMap.put(haplotypeReadMapEntry.getKey(), perReadAlleleLikelihoodMap);
        }
        return alleleReadMap;
    }

    protected void mergeConsecutiveEventsBasedOnLD(List<Haplotype> haplotypes, List<String> samples, Map<String, PerReadAlleleLikelihoodMap> haplotypeReadMap, TreeSet<Integer> startPosKeySet, byte[] ref, GenomeLoc refLoc) {
        int MAX_SIZE_TO_COMBINE = 15;
        double MERGE_EVENTS_R2_THRESHOLD = 0.95;
        if (startPosKeySet.size() <= 1) {
            return;
        }
        boolean mapWasUpdated = true;
        block0: while (mapWasUpdated) {
            mapWasUpdated = false;
            Iterator<Integer> iter = startPosKeySet.iterator();
            int thisStart = iter.next();
            while (iter.hasNext()) {
                int nextStart = iter.next();
                if (nextStart - thisStart < 15) {
                    boolean isBiallelic = true;
                    VariantContext thisVC = null;
                    VariantContext nextVC = null;
                    double x11 = Double.NEGATIVE_INFINITY;
                    double x12 = Double.NEGATIVE_INFINITY;
                    double x21 = Double.NEGATIVE_INFINITY;
                    double x22 = Double.NEGATIVE_INFINITY;
                    for (Haplotype h : haplotypes) {
                        VariantContext nextHapVC;
                        VariantContext thisHapVC = h.getEventMap().get(thisStart);
                        if (thisHapVC != null && !thisHapVC.isSymbolic()) {
                            if (thisVC == null) {
                                thisVC = thisHapVC;
                            } else if (!thisHapVC.hasSameAllelesAs(thisVC)) {
                                isBiallelic = false;
                                break;
                            }
                        }
                        if ((nextHapVC = h.getEventMap().get(nextStart)) != null && !nextHapVC.isSymbolic()) {
                            if (nextVC == null) {
                                nextVC = nextHapVC;
                            } else if (!nextHapVC.hasSameAllelesAs(nextVC)) {
                                isBiallelic = false;
                                break;
                            }
                        }
                        for (String sample : samples) {
                            double haplotypeLikelihood = LikelihoodCalculationEngine.computeDiploidHaplotypeLikelihoods(Collections.singleton(sample), haplotypeReadMap, Collections.singletonList(Allele.create(h, true)))[0][0];
                            if (thisHapVC == null) {
                                if (nextHapVC == null) {
                                    x11 = MathUtils.approximateLog10SumLog10(x11, haplotypeLikelihood);
                                    continue;
                                }
                                x12 = MathUtils.approximateLog10SumLog10(x12, haplotypeLikelihood);
                                continue;
                            }
                            if (nextHapVC == null) {
                                x21 = MathUtils.approximateLog10SumLog10(x21, haplotypeLikelihood);
                                continue;
                            }
                            x22 = MathUtils.approximateLog10SumLog10(x22, haplotypeLikelihood);
                        }
                    }
                    if (thisVC == null || nextVC == null) continue;
                    if (isBiallelic) {
                        double R2 = GenotypingEngine.calculateR2LD(Math.pow(10.0, x11), Math.pow(10.0, x12), Math.pow(10.0, x21), Math.pow(10.0, x22));
                        if (this.DEBUG) {
                            System.out.println("Found consecutive biallelic events with R^2 = " + String.format("%.4f", R2));
                            System.out.println("-- " + thisVC);
                            System.out.println("-- " + nextVC);
                        }
                        if (R2 > 0.95) {
                            VariantContext mergedVC = GenotypingEngine.createMergedVariantContext(thisVC, nextVC, ref, refLoc);
                            for (Haplotype h : haplotypes) {
                                Map<Integer, VariantContext> eventMap = h.getEventMap();
                                if (!eventMap.containsKey(thisStart) || !eventMap.containsKey(nextStart)) continue;
                                eventMap.remove(thisStart);
                                eventMap.remove(nextStart);
                                eventMap.put(mergedVC.getStart(), mergedVC);
                            }
                            startPosKeySet.add(mergedVC.getStart());
                            boolean containsStart = false;
                            boolean containsNext = false;
                            for (Haplotype h : haplotypes) {
                                Map<Integer, VariantContext> eventMap = h.getEventMap();
                                if (eventMap.containsKey(thisStart)) {
                                    containsStart = true;
                                }
                                if (!eventMap.containsKey(nextStart)) continue;
                                containsNext = true;
                            }
                            if (!containsStart) {
                                startPosKeySet.remove(thisStart);
                            }
                            if (!containsNext) {
                                startPosKeySet.remove(nextStart);
                            }
                            if (this.DEBUG) {
                                System.out.println("====> " + mergedVC);
                            }
                            mapWasUpdated = true;
                            continue block0;
                        }
                    }
                }
                thisStart = nextStart;
            }
        }
    }

    protected static VariantContext createMergedVariantContext(VariantContext thisVC, VariantContext nextVC, byte[] ref, GenomeLoc refLoc) {
        int iii;
        int locus;
        int thisStart = thisVC.getStart();
        int nextStart = nextVC.getStart();
        byte[] refBases = new byte[]{};
        byte[] altBases = new byte[]{};
        refBases = ArrayUtils.addAll(refBases, thisVC.getReference().getBases());
        altBases = ArrayUtils.addAll(altBases, thisVC.getAlternateAllele(0).getBases());
        for (locus = thisStart + refBases.length; locus < nextStart; ++locus) {
            byte refByte = ref[locus - refLoc.getStart()];
            refBases = ArrayUtils.add(refBases, refByte);
            altBases = ArrayUtils.add(altBases, refByte);
        }
        refBases = ArrayUtils.addAll(refBases, ArrayUtils.subarray(nextVC.getReference().getBases(), locus > nextStart ? 1 : 0, nextVC.getReference().getBases().length));
        altBases = ArrayUtils.addAll(altBases, nextVC.getAlternateAllele(0).getBases());
        if (refBases.length == altBases.length) {
            for (iii = 0; iii < refBases.length && refBases[iii] == altBases[iii]; ++iii) {
            }
        }
        ArrayList<Allele> mergedAlleles = new ArrayList<Allele>();
        mergedAlleles.add(Allele.create(ArrayUtils.subarray(refBases, iii, refBases.length), true));
        mergedAlleles.add(Allele.create(ArrayUtils.subarray(altBases, iii, altBases.length), false));
        return new VariantContextBuilder("merged", thisVC.getChr(), thisVC.getStart() + iii, nextVC.getEnd(), mergedAlleles).make();
    }

    protected static double calculateR2LD(double x11, double x12, double x21, double x22) {
        double total = x11 + x12 + x21 + x22;
        double pa1b1 = x11 / total;
        double pa1b2 = x12 / total;
        double pa2b1 = x21 / total;
        double pa1 = pa1b1 + pa1b2;
        double pb1 = pa1b1 + pa2b1;
        return (pa1b1 - pa1 * pb1) * (pa1b1 - pa1 * pb1) / (pa1 * (1.0 - pa1) * pb1 * (1.0 - pb1));
    }

    protected static Map<Allele, List<Haplotype>> createAlleleMapper(Map<VariantContext, Allele> mergeMap, Map<Event, List<Haplotype>> eventMap) {
        LinkedHashMap<Allele, List<Haplotype>> alleleMapper = new LinkedHashMap<Allele, List<Haplotype>>();
        for (Map.Entry<VariantContext, Allele> entry : mergeMap.entrySet()) {
            alleleMapper.put(entry.getValue(), eventMap.get(new Event(entry.getKey())));
        }
        return alleleMapper;
    }

    @Requires(value={"haplotypes.size() >= eventsAtThisLoc.size() + 1"})
    @Ensures(value={"result.size() == eventsAtThisLoc.size() + 1"})
    protected static Map<Event, List<Haplotype>> createEventMapper(int loc, List<VariantContext> eventsAtThisLoc, List<Haplotype> haplotypes) {
        LinkedHashMap<Event, List<Haplotype>> eventMapper = new LinkedHashMap<Event, List<Haplotype>>(eventsAtThisLoc.size() + 1);
        VariantContext refVC = eventsAtThisLoc.get(0);
        eventMapper.put(new Event(null), new ArrayList());
        for (VariantContext vc : eventsAtThisLoc) {
            eventMapper.put(new Event(vc), new ArrayList());
        }
        ArrayList<Haplotype> undeterminedHaplotypes = new ArrayList<Haplotype>(haplotypes.size());
        for (Haplotype h : haplotypes) {
            if (h.isArtificialHaplotype() && loc == h.getArtificialAllelePosition()) {
                ArrayList<Allele> alleles = new ArrayList<Allele>(2);
                alleles.add(h.getArtificialRefAllele());
                alleles.add(h.getArtificialAltAllele());
                Event artificialVC = new Event(new VariantContextBuilder().source("artificialHaplotype").alleles((Collection<Allele>)alleles).loc(refVC.getChr(), refVC.getStart(), refVC.getStart() + h.getArtificialRefAllele().length() - 1).make());
                if (!eventMapper.containsKey(artificialVC)) continue;
                ((List)eventMapper.get(artificialVC)).add(h);
                continue;
            }
            if (h.getEventMap().get(loc) == null) {
                undeterminedHaplotypes.add(h);
                continue;
            }
            boolean haplotypeIsDetermined = false;
            for (VariantContext variantContext : eventsAtThisLoc) {
                if (!h.getEventMap().get(loc).hasSameAllelesAs(variantContext)) continue;
                ((List)eventMapper.get(new Event(variantContext))).add(h);
                haplotypeIsDetermined = true;
                break;
            }
            if (haplotypeIsDetermined) continue;
            undeterminedHaplotypes.add(h);
        }
        for (Haplotype h : undeterminedHaplotypes) {
            Event matchingEvent = new Event(null);
            for (Map.Entry entry : eventMapper.entrySet()) {
                Haplotype artificialHaplotype;
                if (((Event)entry.getKey()).equals(new Event(null)) || !GenotypingEngine.isSubSetOf((artificialHaplotype = (Haplotype)((List)entry.getValue()).get(0)).getEventMap(), h.getEventMap(), true)) continue;
                matchingEvent = (Event)entry.getKey();
                break;
            }
            ((List)eventMapper.get(matchingEvent)).add(h);
        }
        return eventMapper;
    }

    protected static boolean isSubSetOf(Map<Integer, VariantContext> subset, Map<Integer, VariantContext> superset, boolean resolveSupersetToSubset) {
        for (Map.Entry<Integer, VariantContext> fromSubset : subset.entrySet()) {
            VariantContext fromSuperset = superset.get(fromSubset.getKey());
            if (fromSuperset == null) {
                return false;
            }
            List<Allele> supersetAlleles = fromSuperset.getAlternateAlleles();
            if (resolveSupersetToSubset) {
                supersetAlleles = GenotypingEngine.resolveAlternateAlleles(fromSubset.getValue().getReference(), fromSuperset.getReference(), supersetAlleles);
            }
            if (supersetAlleles.contains(fromSubset.getValue().getAlternateAllele(0))) continue;
            return false;
        }
        return true;
    }

    private static List<Allele> resolveAlternateAlleles(Allele targetReference, Allele actualReference, List<Allele> currentAlleles) {
        if (targetReference.length() <= actualReference.length()) {
            return currentAlleles;
        }
        ArrayList<Allele> newAlleles = new ArrayList<Allele>(currentAlleles.size());
        byte[] extraBases = Arrays.copyOfRange(targetReference.getBases(), actualReference.length(), targetReference.length());
        for (Allele a : currentAlleles) {
            newAlleles.add(Allele.extend(a, extraBases));
        }
        return newAlleles;
    }

    @Ensures(value={"result.size() == haplotypeAllelesForSample.size()"})
    protected static List<Allele> findEventAllelesInSample(List<Allele> eventAlleles, List<Allele> haplotypeAlleles, List<Allele> haplotypeAllelesForSample, List<List<Haplotype>> alleleMapper, List<Haplotype> haplotypes) {
        if (haplotypeAllelesForSample.contains(Allele.NO_CALL)) {
            return noCall;
        }
        ArrayList<Allele> eventAllelesForSample = new ArrayList<Allele>();
        block0: for (Allele a : haplotypeAllelesForSample) {
            Haplotype haplotype = haplotypes.get(haplotypeAlleles.indexOf(a));
            for (int iii = 0; iii < alleleMapper.size(); ++iii) {
                List<Haplotype> mappedHaplotypes = alleleMapper.get(iii);
                if (!mappedHaplotypes.contains(haplotype)) continue;
                eventAllelesForSample.add(eventAlleles.get(iii));
                continue block0;
            }
        }
        return eventAllelesForSample;
    }

    protected static boolean containsVCWithMatchingAlleles(List<VariantContext> list, VariantContext vcToTest) {
        for (VariantContext vc : list) {
            if (!vc.hasSameAllelesAs(vcToTest)) continue;
            return true;
        }
        return false;
    }

    protected static Map<Integer, VariantContext> generateVCsFromAlignment(Haplotype haplotype, int alignmentStartHapwrtRef, Cigar cigar, byte[] ref, byte[] alignment, GenomeLoc refLoc, String sourceNameToAdd) {
        LinkedHashMap<Integer, VariantContext> vcs = new LinkedHashMap<Integer, VariantContext>();
        int refPos = alignmentStartHapwrtRef;
        if (refPos < 0) {
            return null;
        }
        int alignmentPos = 0;
        block6: for (int cigarIndex = 0; cigarIndex < cigar.numCigarElements(); ++cigarIndex) {
            CigarElement ce = cigar.getCigarElement(cigarIndex);
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case I: {
                    ArrayList<Allele> insertionAlleles = new ArrayList<Allele>();
                    int insertionStart = refLoc.getStart() + refPos - 1;
                    byte refByte = ref[refPos - 1];
                    if (BaseUtils.isRegularBase(refByte)) {
                        insertionAlleles.add(Allele.create(refByte, true));
                    }
                    if (cigarIndex == 0 || cigarIndex == cigar.getCigarElements().size() - 1) {
                        insertionAlleles.add(SYMBOLIC_UNASSEMBLED_EVENT_ALLELE);
                    } else {
                        byte[] insertionBases = new byte[]{};
                        insertionBases = ArrayUtils.add(insertionBases, ref[refPos - 1]);
                        if (BaseUtils.isAllRegularBases(insertionBases = ArrayUtils.addAll(insertionBases, Arrays.copyOfRange(alignment, alignmentPos, alignmentPos + elementLength)))) {
                            insertionAlleles.add(Allele.create(insertionBases, false));
                        }
                    }
                    if (insertionAlleles.size() == 2) {
                        vcs.put(insertionStart, new VariantContextBuilder(sourceNameToAdd, refLoc.getContig(), insertionStart, insertionStart, insertionAlleles).make());
                    }
                    alignmentPos += elementLength;
                    continue block6;
                }
                case S: {
                    alignmentPos += elementLength;
                    continue block6;
                }
                case D: {
                    byte[] deletionBases = Arrays.copyOfRange(ref, refPos - 1, refPos + elementLength);
                    ArrayList<Allele> deletionAlleles = new ArrayList<Allele>();
                    int deletionStart = refLoc.getStart() + refPos - 1;
                    byte refByte = ref[refPos - 1];
                    if (BaseUtils.isRegularBase(refByte) && BaseUtils.isAllRegularBases(deletionBases)) {
                        deletionAlleles.add(Allele.create(deletionBases, true));
                        deletionAlleles.add(Allele.create(refByte, false));
                        vcs.put(deletionStart, new VariantContextBuilder(sourceNameToAdd, refLoc.getContig(), deletionStart, deletionStart + elementLength, deletionAlleles).make());
                    }
                    refPos += elementLength;
                    continue block6;
                }
                case M: 
                case EQ: 
                case X: {
                    for (int iii = 0; iii < elementLength; ++iii) {
                        byte refByte = ref[refPos];
                        byte altByte = alignment[alignmentPos];
                        if (refByte != altByte && BaseUtils.isRegularBase(refByte) && BaseUtils.isRegularBase(altByte)) {
                            ArrayList<Allele> snpAlleles = new ArrayList<Allele>();
                            snpAlleles.add(Allele.create(refByte, true));
                            snpAlleles.add(Allele.create(altByte, false));
                            vcs.put(refLoc.getStart() + refPos, new VariantContextBuilder(sourceNameToAdd, refLoc.getContig(), refLoc.getStart() + refPos, refLoc.getStart() + refPos, snpAlleles).make());
                        }
                        ++refPos;
                        ++alignmentPos;
                    }
                    continue block6;
                }
                default: {
                    throw new ReviewedStingException("Unsupported cigar operator created during SW alignment: " + (Object)((Object)ce.getOperator()));
                }
            }
        }
        return vcs;
    }

    private static class Event {
        public VariantContext vc;

        public Event(VariantContext vc) {
            this.vc = vc;
        }

        public boolean equals(Object obj) {
            return obj instanceof Event && (((Event)obj).vc == null && this.vc == null || ((Event)obj).vc != null && this.vc != null && ((Event)obj).vc.hasSameAllelesAs(this.vc));
        }

        public int hashCode() {
            return this.vc == null ? -1 : ((Object)this.vc.getAlleles()).hashCode();
        }
    }
}

