/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.haplotypecaller;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pairhmm.Log10PairHMM;
import org.broadinstitute.sting.utils.pairhmm.LoglessCachingPairHMM;
import org.broadinstitute.sting.utils.pairhmm.PairHMM;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.variant.variantcontext.Allele;

public class LikelihoodCalculationEngine {
    private static final double LOG_ONE_HALF = -Math.log10(2.0);
    private final byte constantGCP;
    private final boolean DEBUG;
    private final PairHMM pairHMM;

    public LikelihoodCalculationEngine(byte constantGCP, boolean debug, PairHMM.HMM_IMPLEMENTATION hmmType) {
        switch (hmmType) {
            case EXACT: {
                this.pairHMM = new Log10PairHMM(true);
                break;
            }
            case ORIGINAL: {
                this.pairHMM = new Log10PairHMM(false);
                break;
            }
            case LOGLESS_CACHING: {
                this.pairHMM = new LoglessCachingPairHMM();
                break;
            }
            default: {
                throw new UserException.BadArgumentValue("pairHMM", "Specified pairHMM implementation is unrecognized or incompatible with the HaplotypeCaller. Acceptable options are ORIGINAL, EXACT, CACHING, and LOGLESS_CACHING.");
            }
        }
        this.constantGCP = constantGCP;
        this.DEBUG = debug;
    }

    public Map<String, PerReadAlleleLikelihoodMap> computeReadLikelihoods(List<Haplotype> haplotypes, Map<String, List<GATKSAMRecord>> perSampleReadList) {
        HashMap<String, PerReadAlleleLikelihoodMap> stratifiedReadMap = new HashMap<String, PerReadAlleleLikelihoodMap>();
        int X_METRIC_LENGTH = 0;
        for (Map.Entry<String, List<GATKSAMRecord>> sample : perSampleReadList.entrySet()) {
            for (GATKSAMRecord read : sample.getValue()) {
                int readLength = read.getReadLength();
                if (readLength <= X_METRIC_LENGTH) continue;
                X_METRIC_LENGTH = readLength;
            }
        }
        int Y_METRIC_LENGTH = 0;
        for (Haplotype haplotype : haplotypes) {
            int haplotypeLength = haplotype.getBases().length;
            if (haplotypeLength <= Y_METRIC_LENGTH) continue;
            Y_METRIC_LENGTH = haplotypeLength;
        }
        this.pairHMM.initialize(X_METRIC_LENGTH += 2, Y_METRIC_LENGTH += 2);
        for (Map.Entry entry : perSampleReadList.entrySet()) {
            stratifiedReadMap.put((String)entry.getKey(), this.computeReadLikelihoods(haplotypes, (List)entry.getValue()));
        }
        return stratifiedReadMap;
    }

    private PerReadAlleleLikelihoodMap computeReadLikelihoods(List<Haplotype> haplotypes, List<GATKSAMRecord> reads) {
        int numHaplotypes = haplotypes.size();
        HashMap<Haplotype, Allele> alleleVersions = new HashMap<Haplotype, Allele>(numHaplotypes);
        for (Haplotype haplotype : haplotypes) {
            alleleVersions.put(haplotype, Allele.create(haplotype, true));
        }
        PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap = new PerReadAlleleLikelihoodMap();
        for (GATKSAMRecord read : reads) {
            byte[] overallGCP = new byte[read.getReadLength()];
            Arrays.fill(overallGCP, this.constantGCP);
            Allele previousHaplotypeSeen = null;
            byte[] readQuals = read.getBaseQualities();
            byte[] readInsQuals = read.getBaseInsertionQualities();
            byte[] readDelQuals = read.getBaseDeletionQualities();
            for (int kkk = 0; kkk < readQuals.length; ++kkk) {
                readQuals[kkk] = (byte)Math.min(0xFF & readQuals[kkk], read.getMappingQuality());
                readQuals[kkk] = readQuals[kkk] < 18 ? 6 : readQuals[kkk];
            }
            for (int jjj = 0; jjj < numHaplotypes; ++jjj) {
                Haplotype haplotype = haplotypes.get(jjj);
                int haplotypeStart = previousHaplotypeSeen == null ? 0 : PairHMM.findFirstPositionWhereHaplotypesDiffer(haplotype.getBases(), previousHaplotypeSeen.getBases());
                previousHaplotypeSeen = haplotype;
                perReadAlleleLikelihoodMap.add(read, (Allele)alleleVersions.get(haplotype), (Double)this.pairHMM.computeReadLikelihoodGivenHaplotypeLog10(haplotype.getBases(), read.getReadBases(), readQuals, readInsQuals, readDelQuals, overallGCP, haplotypeStart, jjj == 0));
            }
        }
        return perReadAlleleLikelihoodMap;
    }

    @Requires(value={"alleleOrdering.size() > 0"})
    @Ensures(value={"result.length == result[0].length", "result.length == alleleOrdering.size()"})
    public static double[][] computeDiploidHaplotypeLikelihoods(String sample, Map<String, PerReadAlleleLikelihoodMap> stratifiedReadMap, List<Allele> alleleOrdering) {
        TreeSet<String> sampleSet = new TreeSet<String>();
        sampleSet.add(sample);
        return LikelihoodCalculationEngine.computeDiploidHaplotypeLikelihoods(sampleSet, stratifiedReadMap, alleleOrdering);
    }

    @Requires(value={"alleleOrdering.size() > 0"})
    @Ensures(value={"result.length == result[0].length", "result.length == alleleOrdering.size()"})
    public static double[][] computeDiploidHaplotypeLikelihoods(Set<String> samples, Map<String, PerReadAlleleLikelihoodMap> stratifiedReadMap, List<Allele> alleleOrdering) {
        int iii;
        int numHaplotypes = alleleOrdering.size();
        double[][] haplotypeLikelihoodMatrix = new double[numHaplotypes][numHaplotypes];
        for (iii = 0; iii < numHaplotypes; ++iii) {
            Arrays.fill(haplotypeLikelihoodMatrix[iii], Double.NEGATIVE_INFINITY);
        }
        for (iii = 0; iii < numHaplotypes; ++iii) {
            Allele iii_allele = alleleOrdering.get(iii);
            for (int jjj = 0; jjj <= iii; ++jjj) {
                Allele jjj_allele = alleleOrdering.get(jjj);
                double haplotypeLikelihood = 0.0;
                for (String sample : samples) {
                    for (Map.Entry<GATKSAMRecord, Map<Allele, Double>> entry : stratifiedReadMap.get(sample).getLikelihoodReadMap().entrySet()) {
                        haplotypeLikelihood += (double)ReadUtils.getMeanRepresentativeReadCount(entry.getKey()) * (MathUtils.approximateLog10SumLog10(entry.getValue().get(iii_allele), entry.getValue().get(jjj_allele)) + LOG_ONE_HALF);
                    }
                }
                haplotypeLikelihoodMatrix[iii][jjj] = haplotypeLikelihood;
            }
        }
        return LikelihoodCalculationEngine.normalizeDiploidLikelihoodMatrixFromLog10(haplotypeLikelihoodMatrix);
    }

    @Requires(value={"likelihoodMatrix.length == likelihoodMatrix[0].length"})
    @Ensures(value={"result.length == result[0].length", "result.length == likelihoodMatrix.length"})
    protected static double[][] normalizeDiploidLikelihoodMatrixFromLog10(double[][] likelihoodMatrix) {
        int jjj;
        int iii;
        int numHaplotypes = likelihoodMatrix.length;
        double[] genotypeLikelihoods = new double[numHaplotypes * (numHaplotypes + 1) / 2];
        int index = 0;
        for (iii = 0; iii < numHaplotypes; ++iii) {
            for (jjj = 0; jjj <= iii; ++jjj) {
                genotypeLikelihoods[index++] = likelihoodMatrix[iii][jjj];
            }
        }
        genotypeLikelihoods = MathUtils.normalizeFromLog10(genotypeLikelihoods, false, true);
        index = 0;
        for (iii = 0; iii < numHaplotypes; ++iii) {
            for (jjj = 0; jjj <= iii; ++jjj) {
                likelihoodMatrix[iii][jjj] = genotypeLikelihoods[index++];
            }
        }
        return likelihoodMatrix;
    }

    @Requires(value={"haplotypes.size() > 0"})
    @Ensures(value={"result.size() <= haplotypes.size()"})
    public List<Haplotype> selectBestHaplotypes(List<Haplotype> haplotypes, Map<String, PerReadAlleleLikelihoodMap> stratifiedReadMap, int maxNumHaplotypesInPopulation) {
        int numHaplotypes = haplotypes.size();
        Set<String> sampleKeySet = stratifiedReadMap.keySet();
        ArrayList<Integer> bestHaplotypesIndexList = new ArrayList<Integer>();
        bestHaplotypesIndexList.add(LikelihoodCalculationEngine.findReferenceIndex(haplotypes));
        ArrayList<Allele> haplotypesAsAlleles = new ArrayList<Allele>();
        for (Haplotype h : haplotypes) {
            haplotypesAsAlleles.add(Allele.create(h, true));
        }
        double[][] haplotypeLikelihoodMatrix = LikelihoodCalculationEngine.computeDiploidHaplotypeLikelihoods(sampleKeySet, stratifiedReadMap, haplotypesAsAlleles);
        int hap1 = 0;
        int hap2 = 0;
        int maxChosenHaplotypes = Math.min(maxNumHaplotypesInPopulation, sampleKeySet.size() * 2 + 1);
        while (bestHaplotypesIndexList.size() < maxChosenHaplotypes) {
            double maxElement = Double.NEGATIVE_INFINITY;
            for (int iii = 0; iii < numHaplotypes; ++iii) {
                for (int jjj = 0; jjj <= iii; ++jjj) {
                    if (!(haplotypeLikelihoodMatrix[iii][jjj] > maxElement)) continue;
                    maxElement = haplotypeLikelihoodMatrix[iii][jjj];
                    hap1 = iii;
                    hap2 = jjj;
                }
            }
            if (maxElement == Double.NEGATIVE_INFINITY) break;
            if (this.DEBUG) {
                System.out.println("Chose haplotypes " + hap1 + " and " + hap2 + " with diploid likelihood = " + haplotypeLikelihoodMatrix[hap1][hap2]);
            }
            haplotypeLikelihoodMatrix[hap1][hap2] = Double.NEGATIVE_INFINITY;
            if (!bestHaplotypesIndexList.contains(hap1)) {
                bestHaplotypesIndexList.add(hap1);
            }
            if (bestHaplotypesIndexList.contains(hap2)) continue;
            bestHaplotypesIndexList.add(hap2);
        }
        if (this.DEBUG) {
            System.out.println("Chose " + (bestHaplotypesIndexList.size() - 1) + " alternate haplotypes to genotype in all samples.");
        }
        ArrayList<Haplotype> bestHaplotypes = new ArrayList<Haplotype>();
        Iterator i$ = bestHaplotypesIndexList.iterator();
        while (i$.hasNext()) {
            int hIndex = (Integer)i$.next();
            bestHaplotypes.add(haplotypes.get(hIndex));
        }
        return bestHaplotypes;
    }

    public static int findReferenceIndex(List<Haplotype> haplotypes) {
        for (Haplotype h : haplotypes) {
            if (!h.isReference()) continue;
            return haplotypes.indexOf(h);
        }
        throw new ReviewedStingException("No reference haplotype found in the list of haplotypes!");
    }
}

