/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.variant.variantcontext.Allele;

public class HaplotypeIndelErrorModel {
    private final int maxReadDeletionLength;
    private final double noDeletionProbability;
    private final int haplotypeSize;
    private final int BASE_QUAL_THRESHOLD = 6;
    private final int PATH_METRIC_TABLE_LENGTH;
    private final int RIGHT_ALIGN_INDEX;
    private final int LEFT_ALIGN_INDEX;
    private double[] deletionErrorProbabilities;
    private double[][] pathMetricArray;
    private int[][] bestStateIndexArray;
    private final double logOneMinusInsertionStartProbability;
    private final double logInsertionStartProbability;
    private final double logInsertionEndProbability;
    private final double logOneMinusInsertionEndProbability;
    private boolean DEBUG = false;
    private boolean doSimpleCalculationModel = false;
    private static final double QUAL_ONE_HALF = -10.0 * Math.log10(0.5);
    private static final int MAX_CACHED_QUAL = 60;
    private static final double[] baseMatchArray = new double[61];
    private static final double[] baseMismatchArray = new double[61];

    public HaplotypeIndelErrorModel(int mrdl, double insStart, double insEnd, double alpha, int haplotypeSize, boolean dosimple, boolean deb) {
        this(mrdl, insStart, insEnd, alpha, haplotypeSize);
        this.DEBUG = deb;
        this.doSimpleCalculationModel = dosimple;
    }

    public HaplotypeIndelErrorModel(int mrdl, double insStart, double insEnd, double alpha, int haplotypeSize) {
        int k;
        this.maxReadDeletionLength = mrdl;
        this.noDeletionProbability = 1.0 - alpha;
        this.haplotypeSize = haplotypeSize;
        this.PATH_METRIC_TABLE_LENGTH = haplotypeSize + 2;
        this.RIGHT_ALIGN_INDEX = this.PATH_METRIC_TABLE_LENGTH - 1;
        this.LEFT_ALIGN_INDEX = 0;
        this.logOneMinusInsertionStartProbability = HaplotypeIndelErrorModel.probToQual(1.0 - insStart);
        this.logInsertionStartProbability = HaplotypeIndelErrorModel.probToQual(insStart);
        this.logInsertionEndProbability = HaplotypeIndelErrorModel.probToQual(insEnd);
        this.logOneMinusInsertionEndProbability = HaplotypeIndelErrorModel.probToQual(1.0 - insEnd);
        double prob = 1.0;
        double sumProb = 0.0;
        this.deletionErrorProbabilities = new double[this.maxReadDeletionLength + 1];
        this.deletionErrorProbabilities[1] = this.noDeletionProbability;
        for (k = 2; k <= this.maxReadDeletionLength; ++k) {
            this.deletionErrorProbabilities[k] = prob;
            sumProb += prob;
            prob *= Math.exp(-1.0);
        }
        this.deletionErrorProbabilities[1] = HaplotypeIndelErrorModel.probToQual(this.deletionErrorProbabilities[1]);
        for (k = 2; k <= this.maxReadDeletionLength; ++k) {
            this.deletionErrorProbabilities[k] = HaplotypeIndelErrorModel.probToQual((1.0 - this.noDeletionProbability) * this.deletionErrorProbabilities[k] / sumProb);
        }
    }

    public static double probToQual(double prob) {
        return -10.0 * Math.log10(prob);
    }

    public double computeReadLikelihoodGivenHaplotype(Haplotype haplotype, SAMRecord read) {
        int i;
        long numStartClippedBases = 0L;
        long numEndClippedBases = 0L;
        byte[] unclippedReadQuals = read.getBaseQualities();
        byte[] unclippedReadBases = read.getReadBases();
        for (i = 0; i < read.getReadLength() && unclippedReadQuals[i] < 6; ++i) {
            ++numStartClippedBases;
        }
        for (i = read.getReadLength() - 1; i >= 0 && unclippedReadQuals[i] < 6; --i) {
            ++numEndClippedBases;
        }
        if (numStartClippedBases + numEndClippedBases >= (long)read.getReadLength()) {
            return 0.0;
        }
        byte[] readBases = Arrays.copyOfRange(unclippedReadBases, (int)numStartClippedBases, (int)((long)read.getReadBases().length - numEndClippedBases));
        byte[] readQuals = Arrays.copyOfRange(unclippedReadQuals, (int)numStartClippedBases, (int)((long)read.getReadBases().length - numEndClippedBases));
        int readLength = readBases.length;
        this.pathMetricArray = new double[readLength + 1][this.PATH_METRIC_TABLE_LENGTH];
        this.bestStateIndexArray = new int[readLength + 1][this.PATH_METRIC_TABLE_LENGTH];
        for (int k = 1; k < this.PATH_METRIC_TABLE_LENGTH; ++k) {
            this.pathMetricArray[0][k] = 0.0;
        }
        for (int indR = 0; indR < readLength; ++indR) {
            byte readBase = readBases[indR];
            byte readQual = readQuals[indR];
            for (int indX = this.LEFT_ALIGN_INDEX; indX <= this.RIGHT_ALIGN_INDEX; ++indX) {
                byte haplotypeBase = indX > this.LEFT_ALIGN_INDEX && indX < this.RIGHT_ALIGN_INDEX ? haplotype.getBases()[indX - 1] : readBase;
                this.updatePathMetrics(haplotypeBase, indX, indR, readBase, readQual);
            }
        }
        double bestMetric = MathUtils.arrayMin(this.pathMetricArray[readLength]);
        if (this.DEBUG) {
            int k;
            int bestIndex;
            int k2;
            System.out.println(read.getReadName());
            System.out.print("Haplotype:");
            for (k2 = 0; k2 < haplotype.getBases().length; ++k2) {
                System.out.format("%c ", haplotype.getBases()[k2]);
            }
            System.out.println();
            System.out.print("Read bases: ");
            for (k2 = 0; k2 < readBases.length; ++k2) {
                System.out.format("%c ", readBases[k2]);
            }
            System.out.println();
            System.out.print("Read quals: ");
            for (k2 = 0; k2 < readQuals.length; ++k2) {
                System.out.format("%d ", readQuals[k2]);
            }
            System.out.println();
            int[] bestIndexArray = new int[readLength];
            bestIndexArray[readLength - 1] = bestIndex = MathUtils.minElementIndex(this.pathMetricArray[readLength]);
            for (k = readLength - 2; k >= 0; --k) {
                bestIndexArray[k] = bestIndex = this.bestStateIndexArray[k][bestIndex];
            }
            System.out.print("Alignment: ");
            for (k = 0; k < readBases.length; ++k) {
                System.out.format("%d ", bestIndexArray[k]);
            }
            System.out.println();
        }
        if (this.DEBUG) {
            System.out.format("Likelihood: %5.4f\n", bestMetric);
        }
        return bestMetric;
    }

    private void updatePathMetrics(byte haplotypeBase, int indX, int indR, byte readBase, byte readQual) {
        double bestMetric = Double.POSITIVE_INFINITY;
        int bestMetricIndex = -1;
        if (readQual < 1) {
            readQual = 1;
        }
        if (readQual > 60) {
            readQual = (byte)60;
        }
        double pBaseMatch = baseMatchArray[readQual];
        double pBaseMismatch = baseMismatchArray[readQual];
        double pBaseRead = haplotypeBase == readBase ? pBaseMatch : pBaseMismatch;
        if (indX == this.LEFT_ALIGN_INDEX) {
            bestMetric = this.pathMetricArray[indR][indX] + QUAL_ONE_HALF;
            bestMetricIndex = indX;
        } else {
            double bmetric;
            for (int indXold = indX - 1; indXold >= indX - this.maxReadDeletionLength && indXold >= 0; --indXold) {
                bmetric = this.pathMetricArray[indR][indXold] + this.deletionErrorProbabilities[indX - indXold] + pBaseRead;
                if (indXold != indX - 1) {
                    bmetric += this.logOneMinusInsertionStartProbability;
                }
                if (!(bmetric < bestMetric)) continue;
                bestMetric = bmetric;
                bestMetricIndex = indXold;
            }
            bmetric = this.pathMetricArray[indR][indX] + pBaseRead;
            bmetric = indX < this.RIGHT_ALIGN_INDEX ? (bmetric += this.logInsertionStartProbability + this.logOneMinusInsertionEndProbability) : this.pathMetricArray[indR][indX] + QUAL_ONE_HALF;
            if (bmetric < bestMetric) {
                bestMetric = bmetric;
                bestMetricIndex = indX;
            }
        }
        this.pathMetricArray[indR + 1][indX] = bestMetric;
        this.bestStateIndexArray[indR + 1][indX] = bestMetricIndex;
    }

    public double[] computeReadHaplotypeLikelihoods(ReadBackedPileup pileup, HashMap<Allele, Haplotype> haplotypesInVC) {
        double[][] haplotypeLikehoodMatrix = new double[haplotypesInVC.size()][haplotypesInVC.size()];
        double[][] readLikelihoods = new double[pileup.getReads().size()][haplotypesInVC.size()];
        int i = 0;
        for (GATKSAMRecord read : pileup.getReads()) {
            if (ReadUtils.is454Read(read)) continue;
            int j = 0;
            for (Map.Entry<Allele, Haplotype> a : haplotypesInVC.entrySet()) {
                readLikelihoods[i][j] = this.computeReadLikelihoodGivenHaplotype(a.getValue(), read);
                if (this.DEBUG) {
                    System.out.print(read.getReadName() + " ");
                    System.out.format("%d %d S:%d US:%d E:%d UE:%d C:%s %3.4f\n", i, j, read.getAlignmentStart(), read.getUnclippedStart(), read.getAlignmentEnd(), read.getUnclippedEnd(), read.getCigarString(), readLikelihoods[i][j]);
                }
                ++j;
            }
            ++i;
        }
        for (i = 0; i < haplotypesInVC.size(); ++i) {
            for (int j = i; j < haplotypesInVC.size(); ++j) {
                double[] readLikelihood = new double[2];
                for (int readIdx = 0; readIdx < pileup.getReads().size(); ++readIdx) {
                    readLikelihood[0] = -readLikelihoods[readIdx][i] / 10.0;
                    readLikelihood[1] = -readLikelihoods[readIdx][j] / 10.0;
                    double[] dArray = haplotypeLikehoodMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + MathUtils.approximateLog10SumLog10(readLikelihood[0], readLikelihood[1]);
                }
            }
        }
        return this.getHaplotypeLikelihoods(haplotypeLikehoodMatrix);
    }

    private double[] getHaplotypeLikelihoods(double[][] haplotypeLikehoodMatrix) {
        int i;
        int hSize = haplotypeLikehoodMatrix.length;
        double[] genotypeLikelihoods = new double[hSize * (hSize + 1) / 2];
        int k = 0;
        double maxElement = Double.NEGATIVE_INFINITY;
        for (i = 0; i < hSize; ++i) {
            for (int j = i; j < hSize; ++j) {
                genotypeLikelihoods[k++] = haplotypeLikehoodMatrix[i][j];
                if (!(haplotypeLikehoodMatrix[i][j] > maxElement)) continue;
                maxElement = haplotypeLikehoodMatrix[i][j];
            }
        }
        i = 0;
        while (i < genotypeLikelihoods.length) {
            int n = i++;
            genotypeLikelihoods[n] = genotypeLikelihoods[n] - maxElement;
        }
        return genotypeLikelihoods;
    }

    static {
        for (int k = 1; k <= 60; ++k) {
            double baseProb = QualityUtils.qualToProb((byte)k);
            HaplotypeIndelErrorModel.baseMatchArray[k] = HaplotypeIndelErrorModel.probToQual(baseProb);
            HaplotypeIndelErrorModel.baseMismatchArray[k] = k;
        }
    }
}

