/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.samples.Sample;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.variant.GATKVCFUtils;
import org.broadinstitute.sting.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeType;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.vcf.VCFFormatHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;

@DocumentedGATKFeature(groupName="Variant Discovery Tools", extraDocs={CommandLineGATK.class})
public class PhaseByTransmission
extends RodWalker<HashMap<Byte, Integer>, HashMap<Byte, Integer>> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Argument(shortName="mvf", required=false, fullName="MendelianViolationsFile", doc="File to output the mendelian violation details.")
    private PrintStream mvFile = null;
    @Argument(shortName="prior", required=false, fullName="DeNovoPrior", doc="Prior for de novo mutations. Default: 1e-8")
    private double deNovoPrior = 1.0E-8;
    @Argument(shortName="fatherAlleleFirst", required=false, fullName="FatherAlleleFirst", doc="Ouputs the father allele as the first allele in phased child genotype. i.e. father|mother rather than mother|father.")
    private boolean fatherFAlleleFirst = false;
    @Output
    protected VariantContextWriter vcfWriter = null;
    private final String TRANSMISSION_PROBABILITY_TAG_NAME = "TP";
    private final String SOURCE_NAME = "PhaseByTransmission";
    public final double NO_TRANSMISSION_PROB = -1.0;
    private ArrayList<Sample> trios = new ArrayList();
    private EnumMap<GenotypeType, EnumMap<GenotypeType, EnumMap<GenotypeType, Integer>>> mvCountMatrix;
    private EnumMap<GenotypeType, EnumMap<GenotypeType, EnumMap<GenotypeType, TrioPhase>>> transmissionMatrix;
    private final Byte NUM_TRIO_GENOTYPES_CALLED = 0;
    private final Byte NUM_TRIO_GENOTYPES_NOCALL = 1;
    private final Byte NUM_TRIO_GENOTYPES_PHASED = 2;
    private final Byte NUM_TRIO_HET_HET_HET = 3;
    private final Byte NUM_TRIO_VIOLATIONS = 4;
    private final Byte NUM_TRIO_DOUBLE_VIOLATIONS = 10;
    private final Byte NUM_PAIR_GENOTYPES_CALLED = 5;
    private final Byte NUM_PAIR_GENOTYPES_NOCALL = 6;
    private final Byte NUM_PAIR_GENOTYPES_PHASED = 7;
    private final Byte NUM_PAIR_HET_HET = 8;
    private final Byte NUM_PAIR_VIOLATIONS = 9;
    private final Byte NUM_GENOTYPES_MODIFIED = 11;
    private Random rand = new Random();

    @Override
    public void initialize() {
        ArrayList<String> rodNames = new ArrayList<String>();
        rodNames.add(this.variantCollection.variants.getName());
        Map<String, VCFHeader> vcfRods = GATKVCFUtils.getVCFHeadersFromRods(this.getToolkit(), rodNames);
        Set<String> vcfSamples = SampleUtils.getSampleList(vcfRods, GATKVariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE);
        this.setTrios();
        if (this.trios.size() < 1) {
            throw new UserException.BadInput("No PED file passed or no trios found in PED file. Aborted.");
        }
        HashSet<VCFHeaderLine> headerLines = new HashSet<VCFHeaderLine>();
        headerLines.addAll(GATKVCFUtils.getHeaderFields(this.getToolkit()));
        headerLines.add(new VCFFormatHeaderLine("TP", 1, VCFHeaderLineType.Integer, "Phred score of the genotype combination and phase given that the genotypes are correct"));
        headerLines.add(new VCFHeaderLine("source", "PhaseByTransmission"));
        this.vcfWriter.writeHeader(new VCFHeader(headerLines, vcfSamples));
        this.buildMatrices();
        if (this.mvFile != null) {
            this.mvFile.println("CHROM\tPOS\tAC\tFAMILY\tTP\tMOTHER_GT\tMOTHER_DP\tMOTHER_AD\tMOTHER_PL\tFATHER_GT\tFATHER_DP\tFATHER_AD\tFATHER_PL\tCHILD_GT\tCHILD_DP\tCHILD_AD\tCHILD_PL");
        }
    }

    private void setTrios() {
        Map<String, Set<Sample>> families = this.getSampleDB().getFamilies();
        block0: for (Map.Entry<String, Set<Sample>> familyEntry : families.entrySet()) {
            Set<Sample> family = familyEntry.getValue();
            if (family.size() < 2 || family.size() > 3) {
                logger.info(String.format("Caution: Family %s has %d members; At the moment Phase By Transmission only supports trios and parent/child pairs. Family skipped.", familyEntry.getKey(), family.size()));
                continue;
            }
            for (Sample familyMember : family) {
                ArrayList<Sample> parents = familyMember.getParents();
                if (parents.size() <= 0) continue;
                if (family.containsAll(parents)) {
                    this.trios.add(familyMember);
                    continue block0;
                }
                logger.info(String.format("Caution: Family %s skipped as it is not a trio nor a parent/child pair; At the moment Phase By Transmission only supports trios and parent/child pairs. Family skipped.", familyEntry.getKey()));
                continue block0;
            }
        }
    }

    private void buildMatrices() {
        this.mvCountMatrix = new EnumMap(GenotypeType.class);
        this.transmissionMatrix = new EnumMap(GenotypeType.class);
        for (GenotypeType mother : GenotypeType.values()) {
            this.mvCountMatrix.put(mother, new EnumMap(GenotypeType.class));
            this.transmissionMatrix.put(mother, new EnumMap(GenotypeType.class));
            for (GenotypeType father : GenotypeType.values()) {
                this.mvCountMatrix.get((Object)mother).put(father, new EnumMap(GenotypeType.class));
                this.transmissionMatrix.get((Object)mother).put(father, new EnumMap(GenotypeType.class));
                for (GenotypeType child : GenotypeType.values()) {
                    this.mvCountMatrix.get((Object)mother).get((Object)father).put(child, this.getCombinationMVCount(mother, father, child));
                    this.transmissionMatrix.get((Object)mother).get((Object)father).put(child, new TrioPhase(mother, father, child));
                }
            }
        }
    }

    private int getCombinationMVCount(GenotypeType mother, GenotypeType father, GenotypeType child) {
        if (child == GenotypeType.NO_CALL || child == GenotypeType.UNAVAILABLE) {
            return 0;
        }
        ArrayList<GenotypeType> parents = new ArrayList<GenotypeType>();
        if (mother != GenotypeType.NO_CALL && mother != GenotypeType.UNAVAILABLE) {
            parents.add(mother);
        }
        if (father != GenotypeType.NO_CALL && father != GenotypeType.UNAVAILABLE) {
            parents.add(father);
        }
        if (parents.isEmpty()) {
            return 0;
        }
        int parentsNumRefAlleles = 0;
        int parentsNumAltAlleles = 0;
        for (GenotypeType parent : parents) {
            if (parent == GenotypeType.HOM_REF) {
                ++parentsNumRefAlleles;
                continue;
            }
            if (parent == GenotypeType.HET) {
                ++parentsNumRefAlleles;
                ++parentsNumAltAlleles;
                continue;
            }
            if (parent != GenotypeType.HOM_VAR) continue;
            ++parentsNumAltAlleles;
        }
        if (child == GenotypeType.HOM_REF) {
            if (parentsNumRefAlleles == parents.size()) {
                return 0;
            }
            return parents.size() - parentsNumRefAlleles;
        }
        if (child == GenotypeType.HOM_VAR) {
            if (parentsNumAltAlleles == parents.size()) {
                return 0;
            }
            return parents.size() - parentsNumAltAlleles;
        }
        if (child == GenotypeType.HET && (parentsNumRefAlleles > 0 && parentsNumAltAlleles > 0 || parents.size() < 2)) {
            return 0;
        }
        return 1;
    }

    private int countFamilyGenotypeDiff(GenotypeType motherOriginal, GenotypeType fatherOriginal, GenotypeType childOriginal, GenotypeType motherNew, GenotypeType fatherNew, GenotypeType childNew) {
        int count = 0;
        if (motherOriginal != motherNew) {
            ++count;
        }
        if (fatherOriginal != fatherNew) {
            ++count;
        }
        if (childOriginal != childNew) {
            ++count;
        }
        return count;
    }

    private EnumMap<GenotypeType, Double> getLikelihoodsAsMapSafeNull(Genotype genotype) {
        if (genotype == null || !genotype.isCalled() || genotype.getLikelihoods() == null) {
            EnumMap<GenotypeType, Double> likelihoods = new EnumMap<GenotypeType, Double>(GenotypeType.class);
            likelihoods.put(GenotypeType.HOM_REF, 0.3333333333333333);
            likelihoods.put(GenotypeType.HET, 0.3333333333333333);
            likelihoods.put(GenotypeType.HOM_VAR, 0.3333333333333333);
            return likelihoods;
        }
        return genotype.getLikelihoods().getAsMap(true);
    }

    private GenotypeType getTypeSafeNull(Genotype genotype) {
        if (genotype == null) {
            return GenotypeType.UNAVAILABLE;
        }
        return genotype.getType();
    }

    private int phaseTrioGenotypes(Allele ref, Allele alt, Genotype mother, Genotype father, Genotype child, ArrayList<Genotype> finalGenotypes) {
        EnumMap<GenotypeType, Double> secondParentLikelihoods;
        EnumMap<GenotypeType, Double> firstParentLikelihoods;
        int parentsCalled = 0;
        ArrayList<GenotypeType> bestFirstParentGenotype = new ArrayList<GenotypeType>();
        ArrayList<GenotypeType> bestSecondParentGenotype = new ArrayList<GenotypeType>();
        ArrayList<GenotypeType> bestChildGenotype = new ArrayList<GenotypeType>();
        GenotypeType pairSecondParentGenotype = null;
        if (mother == null || !mother.isCalled()) {
            firstParentLikelihoods = this.getLikelihoodsAsMapSafeNull(father);
            secondParentLikelihoods = this.getLikelihoodsAsMapSafeNull(mother);
            bestFirstParentGenotype.add(this.getTypeSafeNull(father));
            bestSecondParentGenotype.add(this.getTypeSafeNull(mother));
            GenotypeType genotypeType = pairSecondParentGenotype = mother == null ? GenotypeType.UNAVAILABLE : mother.getType();
            if (father != null && father.isCalled()) {
                parentsCalled = 1;
            }
        } else {
            firstParentLikelihoods = this.getLikelihoodsAsMapSafeNull(mother);
            secondParentLikelihoods = this.getLikelihoodsAsMapSafeNull(father);
            bestFirstParentGenotype.add(this.getTypeSafeNull(mother));
            bestSecondParentGenotype.add(this.getTypeSafeNull(father));
            if (father == null || !father.isCalled()) {
                parentsCalled = 1;
                pairSecondParentGenotype = father == null ? GenotypeType.UNAVAILABLE : father.getType();
            } else {
                parentsCalled = 2;
            }
        }
        EnumMap<GenotypeType, Double> childLikelihoods = this.getLikelihoodsAsMapSafeNull(child);
        bestChildGenotype.add(this.getTypeSafeNull(child));
        double bestConfigurationLikelihood = 0.0;
        double norm = 0.0;
        int configuration_index = 0;
        ArrayList<Integer> bestMVCount = new ArrayList<Integer>();
        bestMVCount.add(0);
        if (child.isCalled() && parentsCalled > 0) {
            int cumulativeMVCount = 0;
            double configurationLikelihood = 0.0;
            for (Map.Entry childGenotype : childLikelihoods.entrySet()) {
                for (Map.Entry firstParentGenotype : firstParentLikelihoods.entrySet()) {
                    for (Map.Entry secondParentGenotype : secondParentLikelihoods.entrySet()) {
                        int mvCount = this.mvCountMatrix.get(firstParentGenotype.getKey()).get(secondParentGenotype.getKey()).get(childGenotype.getKey());
                        if (parentsCalled < 2) {
                            cumulativeMVCount += mvCount;
                            configurationLikelihood += mvCount > 0 ? Math.pow(this.deNovoPrior, mvCount) * (Double)firstParentGenotype.getValue() * (Double)secondParentGenotype.getValue() * (Double)childGenotype.getValue() : (1.0 - 11.0 * this.deNovoPrior) * (Double)firstParentGenotype.getValue() * (Double)secondParentGenotype.getValue() * (Double)childGenotype.getValue();
                            continue;
                        }
                        configurationLikelihood = mvCount > 0 ? Math.pow(this.deNovoPrior, mvCount) * (Double)firstParentGenotype.getValue() * (Double)secondParentGenotype.getValue() * (Double)childGenotype.getValue() : (1.0 - 11.0 * this.deNovoPrior) * (Double)firstParentGenotype.getValue() * (Double)secondParentGenotype.getValue() * (Double)childGenotype.getValue();
                        norm += configurationLikelihood;
                        if (configurationLikelihood > bestConfigurationLikelihood) {
                            bestConfigurationLikelihood = configurationLikelihood;
                            bestMVCount.clear();
                            bestMVCount.add(mvCount);
                            bestFirstParentGenotype.clear();
                            bestFirstParentGenotype.add((GenotypeType)((Object)firstParentGenotype.getKey()));
                            bestSecondParentGenotype.clear();
                            bestSecondParentGenotype.add((GenotypeType)((Object)secondParentGenotype.getKey()));
                            bestChildGenotype.clear();
                            bestChildGenotype.add((GenotypeType)((Object)childGenotype.getKey()));
                            continue;
                        }
                        if (configurationLikelihood != bestConfigurationLikelihood) continue;
                        bestFirstParentGenotype.add((GenotypeType)((Object)firstParentGenotype.getKey()));
                        bestSecondParentGenotype.add((GenotypeType)((Object)secondParentGenotype.getKey()));
                        bestChildGenotype.add((GenotypeType)((Object)childGenotype.getKey()));
                        bestMVCount.add(mvCount);
                    }
                    if (parentsCalled >= 2) continue;
                    norm += configurationLikelihood;
                    if (configurationLikelihood > bestConfigurationLikelihood) {
                        bestConfigurationLikelihood = configurationLikelihood;
                        bestMVCount.clear();
                        bestMVCount.add(cumulativeMVCount / 3);
                        bestChildGenotype.clear();
                        bestFirstParentGenotype.clear();
                        bestSecondParentGenotype.clear();
                        bestChildGenotype.add((GenotypeType)((Object)childGenotype.getKey()));
                        bestFirstParentGenotype.add((GenotypeType)((Object)firstParentGenotype.getKey()));
                        bestSecondParentGenotype.add(pairSecondParentGenotype);
                    } else if (configurationLikelihood == bestConfigurationLikelihood) {
                        bestFirstParentGenotype.add((GenotypeType)((Object)firstParentGenotype.getKey()));
                        bestSecondParentGenotype.add(pairSecondParentGenotype);
                        bestChildGenotype.add((GenotypeType)((Object)childGenotype.getKey()));
                        bestMVCount.add(cumulativeMVCount / 3);
                    }
                    configurationLikelihood = 0.0;
                }
            }
            bestConfigurationLikelihood /= norm;
            if (bestFirstParentGenotype.size() > 1) {
                configuration_index = this.rand.nextInt(bestFirstParentGenotype.size() - 1);
            }
        } else {
            bestConfigurationLikelihood = -1.0;
        }
        TrioPhase phasedTrioGenotypes = parentsCalled < 2 && mother == null || !mother.isCalled() ? this.transmissionMatrix.get(bestSecondParentGenotype.get(configuration_index)).get(bestFirstParentGenotype.get(configuration_index)).get(bestChildGenotype.get(configuration_index)) : this.transmissionMatrix.get(bestFirstParentGenotype.get(configuration_index)).get(bestSecondParentGenotype.get(configuration_index)).get(bestChildGenotype.get(configuration_index));
        phasedTrioGenotypes.getPhasedGenotypes(ref, alt, mother, father, child, bestConfigurationLikelihood, finalGenotypes);
        return (Integer)bestMVCount.get(configuration_index);
    }

    private void updatePairMetricsCounters(Genotype parent, Genotype child, int mvCount, HashMap<Byte, Integer> counters) {
        if (parent.isCalled() && child.isCalled()) {
            counters.put(this.NUM_PAIR_GENOTYPES_CALLED, counters.get(this.NUM_PAIR_GENOTYPES_CALLED) + 1);
            if (parent.isPhased()) {
                counters.put(this.NUM_PAIR_GENOTYPES_PHASED, counters.get(this.NUM_PAIR_GENOTYPES_PHASED) + 1);
            } else {
                counters.put(this.NUM_PAIR_VIOLATIONS, counters.get(this.NUM_PAIR_VIOLATIONS) + mvCount);
                if (parent.isHet() && child.isHet()) {
                    counters.put(this.NUM_PAIR_HET_HET, counters.get(this.NUM_PAIR_HET_HET) + 1);
                }
            }
        } else {
            counters.put(this.NUM_PAIR_GENOTYPES_NOCALL, counters.get(this.NUM_PAIR_GENOTYPES_NOCALL) + 1);
        }
    }

    private void updateTrioMetricsCounters(Genotype mother, Genotype father, Genotype child, int mvCount, HashMap<Byte, Integer> counters) {
        if (mother.isCalled() && father.isCalled() && child.isCalled()) {
            counters.put(this.NUM_TRIO_GENOTYPES_CALLED, counters.get(this.NUM_TRIO_GENOTYPES_CALLED) + 1);
            if (mother.isPhased()) {
                counters.put(this.NUM_TRIO_GENOTYPES_PHASED, counters.get(this.NUM_TRIO_GENOTYPES_PHASED) + 1);
            } else if (mvCount > 0) {
                if (mvCount > 1) {
                    counters.put(this.NUM_TRIO_DOUBLE_VIOLATIONS, counters.get(this.NUM_TRIO_DOUBLE_VIOLATIONS) + 1);
                } else {
                    counters.put(this.NUM_TRIO_VIOLATIONS, counters.get(this.NUM_TRIO_VIOLATIONS) + 1);
                }
            } else if (mother.isHet() && father.isHet() && child.isHet()) {
                counters.put(this.NUM_TRIO_HET_HET_HET, counters.get(this.NUM_TRIO_HET_HET_HET) + 1);
            }
        } else {
            counters.put(this.NUM_TRIO_GENOTYPES_NOCALL, counters.get(this.NUM_TRIO_GENOTYPES_NOCALL) + 1);
        }
    }

    @Override
    public HashMap<Byte, Integer> map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        HashMap<Byte, Integer> metricsCounters = new HashMap<Byte, Integer>(10);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_CALLED, 0);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_NOCALL, 0);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_PHASED, 0);
        metricsCounters.put(this.NUM_TRIO_HET_HET_HET, 0);
        metricsCounters.put(this.NUM_TRIO_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_CALLED, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_NOCALL, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_PHASED, 0);
        metricsCounters.put(this.NUM_PAIR_HET_HET, 0);
        metricsCounters.put(this.NUM_PAIR_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_TRIO_DOUBLE_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_GENOTYPES_MODIFIED, 0);
        if (tracker == null) {
            return metricsCounters;
        }
        VariantContext vc = tracker.getFirstValue(this.variantCollection.variants, context.getLocation());
        if (vc == null || !vc.isBiallelic()) {
            return metricsCounters;
        }
        VariantContextBuilder builder = new VariantContextBuilder(vc);
        GenotypesContext genotypesContext = GenotypesContext.copy(vc.getGenotypes());
        for (Sample sample : this.trios) {
            String mvfLine;
            Genotype mother = vc.getGenotype(sample.getMaternalID());
            Genotype father = vc.getGenotype(sample.getPaternalID());
            Genotype child = vc.getGenotype(sample.getID());
            if (mother == null && father == null || child == null) continue;
            ArrayList<Genotype> trioGenotypes = new ArrayList<Genotype>(3);
            int mvCount = this.phaseTrioGenotypes(vc.getReference(), vc.getAltAlleleWithHighestAlleleCount(), mother, father, child, trioGenotypes);
            Genotype phasedMother = trioGenotypes.get(0);
            Genotype phasedFather = trioGenotypes.get(1);
            Genotype phasedChild = trioGenotypes.get(2);
            genotypesContext.replace(phasedChild);
            if (mother != null) {
                genotypesContext.replace(phasedMother);
                if (father != null) {
                    genotypesContext.replace(phasedFather);
                    this.updateTrioMetricsCounters(phasedMother, phasedFather, phasedChild, mvCount, metricsCounters);
                    mvfLine = String.format("%s\t%d\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s", vc.getChr(), vc.getStart(), vc.getAttribute("AC"), sample.getFamilyID(), phasedMother.getExtendedAttribute("TP"), phasedMother.getGenotypeString(), phasedMother.getDP(), PhaseByTransmission.printAD(phasedMother.getAD()), phasedMother.getLikelihoodsString(), phasedFather.getGenotypeString(), phasedFather.getDP(), PhaseByTransmission.printAD(phasedFather.getAD()), phasedFather.getLikelihoodsString(), phasedChild.getGenotypeString(), phasedChild.getDP(), PhaseByTransmission.printAD(phasedChild.getAD()), phasedChild.getLikelihoodsString());
                    if (phasedMother.getType() != mother.getType() || phasedFather.getType() != father.getType() || phasedChild.getType() != child.getType()) {
                        metricsCounters.put(this.NUM_GENOTYPES_MODIFIED, metricsCounters.get(this.NUM_GENOTYPES_MODIFIED) + 1);
                    }
                } else {
                    this.updatePairMetricsCounters(phasedMother, phasedChild, mvCount, metricsCounters);
                    if (phasedMother.getType() != mother.getType() || phasedChild.getType() != child.getType()) {
                        metricsCounters.put(this.NUM_GENOTYPES_MODIFIED, metricsCounters.get(this.NUM_GENOTYPES_MODIFIED) + 1);
                    }
                    mvfLine = String.format("%s\t%d\t%s\t%s\t%s\t%s:%s:%s:%s\t.\t.\t.\t.\t%s\t%s\t%s\t%s", vc.getChr(), vc.getStart(), vc.getAttribute("AC"), sample.getFamilyID(), phasedMother.getExtendedAttribute("TP"), phasedMother.getGenotypeString(), phasedMother.getDP(), PhaseByTransmission.printAD(phasedMother.getAD()), phasedMother.getLikelihoodsString(), phasedChild.getGenotypeString(), phasedChild.getDP(), PhaseByTransmission.printAD(phasedChild.getAD()), phasedChild.getLikelihoodsString());
                }
            } else {
                genotypesContext.replace(phasedFather);
                this.updatePairMetricsCounters(phasedFather, phasedChild, mvCount, metricsCounters);
                if (phasedFather.getType() != father.getType() || phasedChild.getType() != child.getType()) {
                    metricsCounters.put(this.NUM_GENOTYPES_MODIFIED, metricsCounters.get(this.NUM_GENOTYPES_MODIFIED) + 1);
                }
                mvfLine = String.format("%s\t%d\t%s\t%s\t%s\t.\t.\t.\t.\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s", vc.getChr(), vc.getStart(), vc.getAttribute("AC"), sample.getFamilyID(), phasedFather.getExtendedAttribute("TP"), phasedFather.getGenotypeString(), phasedFather.getDP(), PhaseByTransmission.printAD(phasedFather.getAD()), phasedFather.getLikelihoodsString(), phasedChild.getGenotypeString(), phasedChild.getDP(), PhaseByTransmission.printAD(phasedChild.getAD()), phasedChild.getLikelihoodsString());
            }
            if (mvCount <= 0 || this.mvFile == null || vc.isFiltered()) continue;
            this.mvFile.println(mvfLine);
        }
        builder.genotypes(genotypesContext);
        this.vcfWriter.add(builder.make());
        return metricsCounters;
    }

    private static String printAD(int[] AD) {
        if (AD == null || AD.length == 0) {
            return ".";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(AD[0]);
        for (int i = 1; i < AD.length; ++i) {
            sb.append(",");
            sb.append(AD[i]);
        }
        return sb.toString();
    }

    @Override
    public HashMap<Byte, Integer> reduceInit() {
        HashMap<Byte, Integer> metricsCounters = new HashMap<Byte, Integer>(10);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_CALLED, 0);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_NOCALL, 0);
        metricsCounters.put(this.NUM_TRIO_GENOTYPES_PHASED, 0);
        metricsCounters.put(this.NUM_TRIO_HET_HET_HET, 0);
        metricsCounters.put(this.NUM_TRIO_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_CALLED, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_NOCALL, 0);
        metricsCounters.put(this.NUM_PAIR_GENOTYPES_PHASED, 0);
        metricsCounters.put(this.NUM_PAIR_HET_HET, 0);
        metricsCounters.put(this.NUM_PAIR_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_TRIO_DOUBLE_VIOLATIONS, 0);
        metricsCounters.put(this.NUM_GENOTYPES_MODIFIED, 0);
        return metricsCounters;
    }

    @Override
    public HashMap<Byte, Integer> reduce(HashMap<Byte, Integer> value, HashMap<Byte, Integer> sum) {
        sum.put(this.NUM_TRIO_GENOTYPES_CALLED, value.get(this.NUM_TRIO_GENOTYPES_CALLED) + sum.get(this.NUM_TRIO_GENOTYPES_CALLED));
        sum.put(this.NUM_TRIO_GENOTYPES_NOCALL, value.get(this.NUM_TRIO_GENOTYPES_NOCALL) + sum.get(this.NUM_TRIO_GENOTYPES_NOCALL));
        sum.put(this.NUM_TRIO_GENOTYPES_PHASED, value.get(this.NUM_TRIO_GENOTYPES_PHASED) + sum.get(this.NUM_TRIO_GENOTYPES_PHASED));
        sum.put(this.NUM_TRIO_HET_HET_HET, value.get(this.NUM_TRIO_HET_HET_HET) + sum.get(this.NUM_TRIO_HET_HET_HET));
        sum.put(this.NUM_TRIO_VIOLATIONS, value.get(this.NUM_TRIO_VIOLATIONS) + sum.get(this.NUM_TRIO_VIOLATIONS));
        sum.put(this.NUM_PAIR_GENOTYPES_CALLED, value.get(this.NUM_PAIR_GENOTYPES_CALLED) + sum.get(this.NUM_PAIR_GENOTYPES_CALLED));
        sum.put(this.NUM_PAIR_GENOTYPES_NOCALL, value.get(this.NUM_PAIR_GENOTYPES_NOCALL) + sum.get(this.NUM_PAIR_GENOTYPES_NOCALL));
        sum.put(this.NUM_PAIR_GENOTYPES_PHASED, value.get(this.NUM_PAIR_GENOTYPES_PHASED) + sum.get(this.NUM_PAIR_GENOTYPES_PHASED));
        sum.put(this.NUM_PAIR_HET_HET, value.get(this.NUM_PAIR_HET_HET) + sum.get(this.NUM_PAIR_HET_HET));
        sum.put(this.NUM_PAIR_VIOLATIONS, value.get(this.NUM_PAIR_VIOLATIONS) + sum.get(this.NUM_PAIR_VIOLATIONS));
        sum.put(this.NUM_TRIO_DOUBLE_VIOLATIONS, value.get(this.NUM_TRIO_DOUBLE_VIOLATIONS) + sum.get(this.NUM_TRIO_DOUBLE_VIOLATIONS));
        sum.put(this.NUM_GENOTYPES_MODIFIED, value.get(this.NUM_GENOTYPES_MODIFIED) + sum.get(this.NUM_GENOTYPES_MODIFIED));
        return sum;
    }

    @Override
    public void onTraversalDone(HashMap<Byte, Integer> result) {
        logger.info("Number of complete trio-genotypes: " + result.get(this.NUM_TRIO_GENOTYPES_CALLED));
        logger.info("Number of trio-genotypes containing no call(s): " + result.get(this.NUM_TRIO_GENOTYPES_NOCALL));
        logger.info("Number of trio-genotypes phased: " + result.get(this.NUM_TRIO_GENOTYPES_PHASED));
        logger.info("Number of resulting Het/Het/Het trios: " + result.get(this.NUM_TRIO_HET_HET_HET));
        logger.info("Number of remaining single mendelian violations in trios: " + result.get(this.NUM_TRIO_VIOLATIONS));
        logger.info("Number of remaining double mendelian violations in trios: " + result.get(this.NUM_TRIO_DOUBLE_VIOLATIONS));
        logger.info("Number of complete pair-genotypes: " + result.get(this.NUM_PAIR_GENOTYPES_CALLED));
        logger.info("Number of pair-genotypes containing no call(s): " + result.get(this.NUM_PAIR_GENOTYPES_NOCALL));
        logger.info("Number of pair-genotypes phased: " + result.get(this.NUM_PAIR_GENOTYPES_PHASED));
        logger.info("Number of resulting Het/Het pairs: " + result.get(this.NUM_PAIR_HET_HET));
        logger.info("Number of remaining mendelian violations in pairs: " + result.get(this.NUM_PAIR_VIOLATIONS));
        logger.info("Number of genotypes updated: " + result.get(this.NUM_GENOTYPES_MODIFIED));
    }

    private class TrioPhase {
        private final Allele REF = Allele.create("A", true);
        private final Allele VAR = Allele.create("A", false);
        private final Allele NO_CALL = Allele.create(".", false);
        private final String DUMMY_NAME = "DummySample";
        private EnumMap<FamilyMember, Genotype> trioPhasedGenotypes = new EnumMap(FamilyMember.class);

        private ArrayList<Allele> getAlleles(GenotypeType genotype) {
            ArrayList<Allele> alleles = new ArrayList<Allele>(2);
            if (genotype == GenotypeType.HOM_REF) {
                alleles.add(this.REF);
                alleles.add(this.REF);
            } else if (genotype == GenotypeType.HET) {
                alleles.add(this.REF);
                alleles.add(this.VAR);
            } else if (genotype == GenotypeType.HOM_VAR) {
                alleles.add(this.VAR);
                alleles.add(this.VAR);
            } else {
                return null;
            }
            return alleles;
        }

        private boolean isPhasable(GenotypeType genotype) {
            return genotype == GenotypeType.HOM_REF || genotype == GenotypeType.HET || genotype == GenotypeType.HOM_VAR;
        }

        private void phaseSingleIndividualAlleles(GenotypeType genotype, FamilyMember familyMember) {
            boolean phase = genotype == GenotypeType.HOM_REF || genotype == GenotypeType.HOM_VAR;
            this.trioPhasedGenotypes.put(familyMember, this.makeGenotype(genotype, phase));
        }

        private Genotype makeGenotype(GenotypeType type, boolean phase) {
            return this.makeGenotype(this.getAlleles(type), phase);
        }

        private Genotype makeGenotype(List<Allele> alleles, boolean phase) {
            GenotypeBuilder gb = new GenotypeBuilder("DummySample", alleles);
            gb.phased(phase);
            return gb.make();
        }

        private void phasePairAlleles(GenotypeType parentGenotype, GenotypeType childGenotype, FamilyMember parent) {
            if (parentGenotype == GenotypeType.HET && childGenotype == GenotypeType.HET) {
                this.trioPhasedGenotypes.put(parent, this.makeGenotype(parentGenotype, false));
                this.trioPhasedGenotypes.put(FamilyMember.CHILD, this.makeGenotype(childGenotype, false));
                return;
            }
            ArrayList<Allele> parentAlleles = this.getAlleles(parentGenotype);
            ArrayList<Allele> childAlleles = this.getAlleles(childGenotype);
            ArrayList<Allele> parentPhasedAlleles = new ArrayList<Allele>(2);
            ArrayList<Allele> childPhasedAlleles = new ArrayList<Allele>(2);
            int childTransmittedAlleleIndex = childAlleles.indexOf(parentAlleles.get(0));
            if (childTransmittedAlleleIndex > -1) {
                this.trioPhasedGenotypes.put(parent, this.makeGenotype(parentAlleles, true));
                childPhasedAlleles.add(childAlleles.remove(childTransmittedAlleleIndex));
                if (parent.equals((Object)FamilyMember.MOTHER)) {
                    childPhasedAlleles.add(childAlleles.get(0));
                } else {
                    childPhasedAlleles.add(0, childAlleles.get(0));
                }
                this.trioPhasedGenotypes.put(FamilyMember.CHILD, this.makeGenotype(childPhasedAlleles, true));
            } else {
                childTransmittedAlleleIndex = childAlleles.indexOf(parentAlleles.get(1));
                if (childTransmittedAlleleIndex > -1) {
                    parentPhasedAlleles.add(parentAlleles.get(1));
                    parentPhasedAlleles.add(parentAlleles.get(0));
                    this.trioPhasedGenotypes.put(parent, this.makeGenotype(parentPhasedAlleles, true));
                    childPhasedAlleles.add(childAlleles.remove(childTransmittedAlleleIndex));
                    if (parent.equals((Object)FamilyMember.MOTHER)) {
                        childPhasedAlleles.add(childAlleles.get(0));
                    } else {
                        childPhasedAlleles.add(0, childAlleles.get(0));
                    }
                    this.trioPhasedGenotypes.put(FamilyMember.CHILD, this.makeGenotype(childPhasedAlleles, true));
                } else {
                    this.trioPhasedGenotypes.put(parent, this.makeGenotype(parentGenotype, false));
                    this.trioPhasedGenotypes.put(FamilyMember.CHILD, this.makeGenotype(childGenotype, false));
                }
            }
        }

        private void phaseFamilyAlleles(GenotypeType mother, GenotypeType father, GenotypeType child) {
            HashSet possiblePhasedChildGenotypes = new HashSet();
            ArrayList<Allele> motherAlleles = this.getAlleles(mother);
            ArrayList<Allele> fatherAlleles = this.getAlleles(father);
            ArrayList<Allele> childAlleles = this.getAlleles(child);
            for (Allele allele : motherAlleles) {
                for (Allele fatherAllele : fatherAlleles) {
                    ArrayList<Allele> possiblePhasedChildAlleles = new ArrayList<Allele>(2);
                    possiblePhasedChildAlleles.add(allele);
                    possiblePhasedChildAlleles.add(fatherAllele);
                    possiblePhasedChildGenotypes.add(possiblePhasedChildAlleles);
                }
            }
            for (ArrayList arrayList : possiblePhasedChildGenotypes) {
                int secondAlleleIndex;
                int firstAlleleIndex = arrayList.indexOf(childAlleles.get(0));
                if (firstAlleleIndex == (secondAlleleIndex = arrayList.lastIndexOf(childAlleles.get(1))) || firstAlleleIndex <= -1 || secondAlleleIndex <= -1) continue;
                ArrayList<Allele> motherPhasedAlleles = new ArrayList<Allele>(2);
                motherPhasedAlleles.add((Allele)arrayList.get(0));
                if (motherAlleles.get(0) != motherPhasedAlleles.get(0)) {
                    motherPhasedAlleles.add(motherAlleles.get(0));
                } else {
                    motherPhasedAlleles.add(motherAlleles.get(1));
                }
                this.trioPhasedGenotypes.put(FamilyMember.MOTHER, this.makeGenotype(motherPhasedAlleles, true));
                ArrayList<Allele> fatherPhasedAlleles = new ArrayList<Allele>(2);
                fatherPhasedAlleles.add((Allele)arrayList.get(1));
                if (fatherAlleles.get(0) != fatherPhasedAlleles.get(0)) {
                    fatherPhasedAlleles.add(fatherAlleles.get(0));
                } else {
                    fatherPhasedAlleles.add(fatherAlleles.get(1));
                }
                this.trioPhasedGenotypes.put(FamilyMember.FATHER, this.makeGenotype(fatherPhasedAlleles, true));
                this.trioPhasedGenotypes.put(FamilyMember.CHILD, this.makeGenotype(arrayList, true));
                return;
            }
            this.trioPhasedGenotypes.put(FamilyMember.MOTHER, this.makeGenotype(mother, false));
            this.trioPhasedGenotypes.put(FamilyMember.FATHER, this.makeGenotype(father, false));
            this.trioPhasedGenotypes.put(FamilyMember.CHILD, this.makeGenotype(child, false));
        }

        public TrioPhase(GenotypeType mother, GenotypeType father, GenotypeType child) {
            if (!this.isPhasable(child)) {
                this.phaseSingleIndividualAlleles(mother, FamilyMember.MOTHER);
                this.phaseSingleIndividualAlleles(father, FamilyMember.FATHER);
                this.phaseSingleIndividualAlleles(child, FamilyMember.CHILD);
            } else if (!this.isPhasable(mother)) {
                this.phaseSingleIndividualAlleles(mother, FamilyMember.MOTHER);
                if (!this.isPhasable(father)) {
                    this.phaseSingleIndividualAlleles(father, FamilyMember.FATHER);
                    this.phaseSingleIndividualAlleles(child, FamilyMember.CHILD);
                } else {
                    this.phasePairAlleles(father, child, FamilyMember.FATHER);
                }
            } else if (!this.isPhasable(father)) {
                this.phasePairAlleles(mother, child, FamilyMember.MOTHER);
                this.phaseSingleIndividualAlleles(father, FamilyMember.FATHER);
            } else if (mother == GenotypeType.HET && father == GenotypeType.HET && child == GenotypeType.HET) {
                this.phaseSingleIndividualAlleles(mother, FamilyMember.MOTHER);
                this.phaseSingleIndividualAlleles(father, FamilyMember.FATHER);
                this.phaseSingleIndividualAlleles(child, FamilyMember.CHILD);
            } else {
                this.phaseFamilyAlleles(mother, father, child);
            }
            if (PhaseByTransmission.this.fatherFAlleleFirst && this.trioPhasedGenotypes.get((Object)FamilyMember.CHILD).isPhased()) {
                ArrayList<Allele> childAlleles = new ArrayList<Allele>(this.trioPhasedGenotypes.get((Object)FamilyMember.CHILD).getAlleles());
                childAlleles.add(childAlleles.remove(0));
                this.trioPhasedGenotypes.put(FamilyMember.CHILD, this.makeGenotype(childAlleles, true));
            }
        }

        public void getPhasedGenotypes(Allele ref, Allele alt, Genotype motherGenotype, Genotype fatherGenotype, Genotype childGenotype, double transmissionProb, ArrayList<Genotype> phasedGenotypes) {
            phasedGenotypes.add(this.getPhasedGenotype(ref, alt, motherGenotype, transmissionProb, this.trioPhasedGenotypes.get((Object)FamilyMember.MOTHER)));
            phasedGenotypes.add(this.getPhasedGenotype(ref, alt, fatherGenotype, transmissionProb, this.trioPhasedGenotypes.get((Object)FamilyMember.FATHER)));
            phasedGenotypes.add(this.getPhasedGenotype(ref, alt, childGenotype, transmissionProb, this.trioPhasedGenotypes.get((Object)FamilyMember.CHILD)));
        }

        private Genotype getPhasedGenotype(Allele refAllele, Allele altAllele, Genotype genotype, double transmissionProb, Genotype phasedGenotype) {
            int phredScoreTransmission = -1;
            if (transmissionProb != -1.0) {
                double dphredScoreTransmission = QualityUtils.phredScaleLog10ErrorRate(Math.log10(1.0 - transmissionProb));
                int n = phredScoreTransmission = dphredScoreTransmission < 127.0 ? (int)((int)dphredScoreTransmission) : 127;
            }
            if (phredScoreTransmission == 0 || genotype == null || !this.isPhasable(genotype.getType())) {
                return genotype;
            }
            HashMap<String, Object> genotypeAttributes = new HashMap<String, Object>();
            genotypeAttributes.putAll(genotype.getExtendedAttributes());
            if (transmissionProb > -1.0) {
                genotypeAttributes.put("TP", phredScoreTransmission);
            }
            ArrayList<Allele> phasedAlleles = new ArrayList<Allele>(2);
            for (Allele allele : phasedGenotype.getAlleles()) {
                if (allele.isReference()) {
                    phasedAlleles.add(refAllele);
                    continue;
                }
                if (allele.isNonReference()) {
                    phasedAlleles.add(altAllele);
                    continue;
                }
                throw new UserException(String.format("BUG: Unexpected allele: %s. Please report.", allele.toString()));
            }
            double log10Error = genotype.getType() == phasedGenotype.getType() ? genotype.getLog10PError() : genotype.getLikelihoods().getLog10GQ(phasedGenotype.getType());
            return new GenotypeBuilder(genotype).alleles(phasedAlleles).log10PError(log10Error).attributes(genotypeAttributes).phased(phasedGenotype.isPhased()).make();
        }
    }

    private static enum FamilyMember {
        MOTHER,
        FATHER,
        CHILD;

    }
}

