/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RefWalker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;

@DocumentedGATKFeature(groupName="Diagnostics and Quality Control Tools", extraDocs={CommandLineGATK.class})
public class CountIntervals
extends RefWalker<Long, Long> {
    @Output
    PrintStream out;
    @Input(fullName="check", shortName="check", doc="Any number of RODs", required=false)
    public List<RodBinding<Feature>> features = Collections.emptyList();
    @Argument(fullName="numOverlaps", shortName="no", doc="Count all occurrences of X or more overlapping intervals; defaults to 2", required=false)
    int numOverlaps = 2;

    @Override
    public Long reduceInit() {
        return 0L;
    }

    @Override
    public boolean isReduceByInterval() {
        return true;
    }

    @Override
    public Long map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return null;
        }
        List checkIntervals = tracker.getValues(this.features);
        return checkIntervals.size();
    }

    @Override
    public Long reduce(Long loc, Long prev) {
        if (loc == null) {
            return 0L;
        }
        return Math.max(prev, loc);
    }

    @Override
    public void onTraversalDone(List<Pair<GenomeLoc, Long>> finalReduce) {
        long count = 0L;
        for (Pair<GenomeLoc, Long> g : finalReduce) {
            if ((Long)g.second < (long)this.numOverlaps) continue;
            ++count;
        }
        this.out.printf("Number of contiguous intervals: %d", count);
    }
}

