/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.gatk.walkers.NanoSchedulable;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.collections.ExpandingArrayList;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;

@DocumentedGATKFeature(groupName="Diagnostics and Quality Control Tools", extraDocs={CommandLineGATK.class})
public class CountRODs
extends RodWalker<Datum, Pair<ExpandingArrayList<Long>, Long>>
implements TreeReducible<Pair<ExpandingArrayList<Long>, Long>>,
NanoSchedulable {
    @Output
    public PrintStream out;
    @Input(fullName="rod", shortName="rod", doc="Input VCF file(s)", required=false)
    public List<RodBinding<Feature>> rods = Collections.emptyList();
    @Argument(fullName="verbose", shortName="v", doc="If true, this tool will print out detailed information about the rods it finds and locations", required=false)
    public boolean verbose = false;
    @Argument(fullName="showSkipped", shortName="s", doc="If true, this tool will print out the skipped locations", required=false)
    public boolean showSkipped = false;

    @Override
    public Pair<ExpandingArrayList<Long>, Long> treeReduce(Pair<ExpandingArrayList<Long>, Long> lhs, Pair<ExpandingArrayList<Long>, Long> rhs) {
        ExpandingArrayList<Long> nt = new ExpandingArrayList<Long>();
        nt.addAll((Collection)lhs.first);
        int index = 0;
        for (Long l : (ExpandingArrayList)rhs.first) {
            if (nt.get(index) == null) {
                nt.add(l);
            } else {
                nt.set(index, (Long)nt.get(index) + l);
            }
            ++index;
        }
        return new Pair<ExpandingArrayList<Long>, Long>(nt, (Long)lhs.second + (Long)rhs.second);
    }

    @Override
    public Datum map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        GenomeLoc cur = context.getLocation();
        if (this.verbose && this.showSkipped) {
            for (long i = context.getSkippedBases(); i >= 0L; --i) {
                SAMSequenceDictionary dictionary = this.getToolkit().getReferenceDataSource().getReference().getSequenceDictionary();
                SAMSequenceRecord contig = dictionary.getSequence(cur.getContig());
                cur = cur.getStop() < contig.getSequenceLength() ? this.getToolkit().getGenomeLocParser().incPos(cur, 1) : this.getToolkit().getGenomeLocParser().createGenomeLoc(dictionary.getSequence(contig.getSequenceIndex() + 1).getSequenceName(), 1, 1);
                this.out.printf("%s: skipped%n", cur);
            }
        }
        long nRodsHere = 0L;
        long nTotalBases = 0L;
        if (ref == null) {
            if (this.verbose) {
                this.out.printf("Last position was %s: skipping %d bases%n", context.getLocation(), context.getSkippedBases());
            }
            nRodsHere = -1L;
            nTotalBases = context.getSkippedBases();
        } else {
            LinkedList<RODRecordList> rods = new LinkedList<RODRecordList>();
            for (RODRecordList rod : tracker.getBoundRodTracks()) {
                if (rod.getLocation().getStart() != context.getLocation().getStart() || rod.getName().equals("interval")) continue;
                rods.add(rod);
            }
            nRodsHere = rods.size();
            if (nRodsHere > 0L && this.verbose) {
                ArrayList<String> names = new ArrayList<String>();
                for (RODRecordList rod : rods) {
                    names.add(rod.getName());
                }
                this.out.printf("At %s: found %d rod(s) [%s] after skipping %d bases%n", context.getLocation(), nRodsHere, Utils.join(",", names), context.getSkippedBases());
            }
            nTotalBases = context.getSkippedBases() + 1L;
        }
        return new Datum(nRodsHere, context.getSkippedBases(), nTotalBases);
    }

    @Override
    public Pair<ExpandingArrayList<Long>, Long> reduceInit() {
        return new Pair<ExpandingArrayList<Long>, Long>(new ExpandingArrayList(), 0L);
    }

    private void updateCounts(ExpandingArrayList<Long> counts, long nRods, long nObs) {
        if (nRods >= 0L) {
            long prev = counts.get((int)nRods) == null ? 0L : counts.get((int)nRods);
            counts.set((int)nRods, nObs + prev);
        }
    }

    @Override
    public Pair<ExpandingArrayList<Long>, Long> reduce(Datum point, Pair<ExpandingArrayList<Long>, Long> sum) {
        ExpandingArrayList<Long> counts = sum.getFirst();
        this.updateCounts(counts, point.nRodsAtThisLocation, 1L);
        this.updateCounts(counts, 0L, point.nSkippedBases);
        Pair<ExpandingArrayList<Long>, Long> r = new Pair<ExpandingArrayList<Long>, Long>(counts, point.nTotalBases + sum.getSecond());
        return r;
    }

    public class Datum {
        public long nRodsAtThisLocation = 0L;
        public long nSkippedBases = 0L;
        public long nTotalBases = 0L;

        public Datum(long nRodsAtThisLocation, long nSkippedBases, long nTotalBases) {
            this.nRodsAtThisLocation = nRodsAtThisLocation;
            this.nSkippedBases = nSkippedBases;
            this.nTotalBases = nTotalBases;
        }

        public String toString() {
            return String.format("<%d %d %d>", this.nRodsAtThisLocation, this.nSkippedBases, this.nTotalBases);
        }
    }
}

