/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.NanoSchedulable;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

@DocumentedGATKFeature(groupName="Diagnostics and Quality Control Tools", extraDocs={CommandLineGATK.class})
public class Pileup
extends LocusWalker<String, Integer>
implements TreeReducible<Integer>,
NanoSchedulable {
    private static final String verboseDelimiter = "@";
    @Output
    PrintStream out;
    @Argument(fullName="showVerbose", shortName="verbose", doc="Add an extra verbose section to the pileup output")
    public boolean SHOW_VERBOSE = false;
    @Input(fullName="metadata", shortName="metadata", doc="Add these ROD bindings to the output Pileup", required=false)
    public List<RodBinding<Feature>> rods = Collections.emptyList();

    @Override
    public String map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        String rods = this.getReferenceOrderedData(tracker);
        ReadBackedPileup basePileup = context.getBasePileup();
        StringBuilder s = new StringBuilder();
        s.append(String.format("%s %s", basePileup.getPileupString(Character.valueOf((char)ref.getBase())), rods));
        if (this.SHOW_VERBOSE) {
            s.append(" ").append(Pileup.createVerboseOutput(basePileup));
        }
        s.append("\n");
        return s.toString();
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(String value, Integer sum) {
        this.out.print(value);
        return sum + 1;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return lhs + rhs;
    }

    private String getReferenceOrderedData(RefMetaDataTracker tracker) {
        ArrayList<String> rodStrings = new ArrayList<String>();
        for (Feature datum : tracker.getValues(this.rods)) {
            rodStrings.add(datum.toString());
        }
        String rodString = Utils.join(", ", rodStrings);
        if (!rodString.equals("")) {
            rodString = "[ROD: " + rodString + "]";
        }
        return rodString;
    }

    private static String createVerboseOutput(ReadBackedPileup pileup) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        sb.append(pileup.getNumberOfDeletions());
        sb.append(" ");
        for (PileupElement p : pileup) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(p.getRead().getReadName());
            sb.append(verboseDelimiter);
            sb.append(p.getOffset());
            sb.append(verboseDelimiter);
            sb.append(p.getRead().getReadLength());
            sb.append(verboseDelimiter);
            sb.append(p.getRead().getMappingQuality());
        }
        return sb.toString();
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.out.println("[REDUCE RESULT] Traversal result is: " + result);
    }
}

