/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.variant.variantcontext.VariantContext;

@Hidden
@Reference(window=@Window(start=-40, stop=40))
public class RodSystemValidation
extends RodWalker<Integer, Integer> {
    private static final String DIVIDER = ",";
    @Input(fullName="eval", shortName="eval", doc="Input VCF eval file", required=true)
    public List<RodBinding<VariantContext>> eval;
    @Output
    public PrintStream out;
    @Argument(fullName="PerLocusEqual", required=false, doc="Should we check that all records at the same site produce equivilent variant contexts")
    public boolean allRecordsVariantContextEquivalent = false;
    MessageDigest digest = null;
    List<ReferenceOrderedDataSource> rodList;

    @Override
    public void initialize() {
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ReviewedStingException("Unable to find MD5 checksumer");
        }
        this.out.println("Header:");
        this.rodList = this.getToolkit().getRodDataSources();
        for (ReferenceOrderedDataSource rod : this.rodList) {
            this.out.println(rod.getName() + DIVIDER + rod.getType());
            this.out.println(rod.getName() + DIVIDER + rod.getFile().getName());
            this.out.println(rod.getName() + DIVIDER + this.md5sum(rod.getFile()));
        }
        this.out.println("Data:");
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        int ret = 0;
        if (tracker != null && tracker.getNTracksWithBoundFeatures() > 0) {
            this.out.print(context.getLocation() + DIVIDER);
            for (RODRecordList rod : tracker.getBoundRodTracks()) {
                this.out.print(rod.getName() + DIVIDER);
            }
            this.out.println(";");
            ++ret;
        }
        if (this.allRecordsVariantContextEquivalent && tracker != null) {
            List col = tracker.getValues(this.eval);
            VariantContext con = null;
            for (VariantContext contextInList : col) {
                if (con == null) {
                    con = contextInList;
                    continue;
                }
                if (con.equals(col)) continue;
                this.out.println("FAIL: context " + col + " doesn't match " + con);
            }
        }
        return ret;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.out.println("[REDUCE RESULT] Traversal result is: " + result);
    }

    private String md5sum(File f) {
        FileInputStream is;
        try {
            is = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            return "Not a file";
        }
        byte[] buffer = new byte[8192];
        int read = 0;
        try {
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                this.digest.update(buffer, 0, read);
            }
            byte[] md5sum = this.digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String string = bigInt.toString(16);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process file for MD5", e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close input stream for MD5 calculation", e);
            }
        }
    }
}

