/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.Collections;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class AlleleFrequency
extends VariantStratifier {
    @Override
    public void initialize() {
        for (double a = 0.0; a <= 1.005; a += 0.005) {
            this.states.add(String.format("%.3f", a));
        }
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        if (eval != null) {
            try {
                return Collections.singletonList(String.format("%.3f", 5.0 * MathUtils.round(eval.getAttributeAsDouble("AF", 0.0) / 5.0, 3)));
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }
}

