/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.picard.util.IntervalTree;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.interval.IntervalUtils;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class IntervalStratification
extends VariantStratifier {
    protected static final Logger logger = Logger.getLogger(IntervalStratification.class);
    Map<String, IntervalTree<GenomeLoc>> intervalTreeByContig = null;
    final List<Object> OVERLAPPING = Arrays.asList("all", "overlaps.intervals");
    final List<Object> NOT_OVERLAPPING = Arrays.asList("all", "outside.intervals");

    @Override
    public void initialize() {
        if (this.getVariantEvalWalker().intervalsFile == null) {
            throw new UserException.MissingArgument("stratIntervals", "Must be provided when IntervalStratification is enabled");
        }
        List<GenomeLoc> locs = this.getVariantEvalWalker().intervalsFile.getIntervals(this.getVariantEvalWalker().getToolkit());
        if (locs.isEmpty()) {
            throw new UserException.BadArgumentValue("stratIntervals", "Contains no intervals.  Perhaps the file is malformed or empty?");
        }
        this.intervalTreeByContig = this.getVariantEvalWalker().createIntervalTreeByContig(this.getVariantEvalWalker().intervalsFile);
        logger.info(String.format("Creating IntervalStratification %s containing %d intervals covering %d bp", this.getVariantEvalWalker().intervalsFile.getSource(), locs.size(), IntervalUtils.intervalSize(locs)));
        this.states.addAll(Arrays.asList("all", "overlaps.intervals", "outside.intervals"));
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        if (eval != null) {
            GenomeLoc loc = this.getVariantEvalWalker().getToolkit().getGenomeLocParser().createGenomeLoc(eval);
            IntervalTree<GenomeLoc> intervalTree = this.intervalTreeByContig.get(loc.getContig());
            IntervalTree.Node<GenomeLoc> node = intervalTree.minOverlapper(loc.getStart(), loc.getStop());
            if (node != null) {
                return this.OVERLAPPING;
            }
            return this.NOT_OVERLAPPING;
        }
        return Collections.emptyList();
    }
}

