/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.Arrays;
import java.util.List;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.StandardStratification;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class Novelty
extends VariantStratifier
implements StandardStratification {
    private List<RodBinding<VariantContext>> knowns;
    private static final List<Object> KNOWN_STATES = Arrays.asList("all", "known");
    private static final List<Object> NOVEL_STATES = Arrays.asList("all", "novel");

    @Override
    public void initialize() {
        this.states.addAll(Arrays.asList("all", "known", "novel"));
        this.knowns = this.getVariantEvalWalker().getKnowns();
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        if (tracker != null && eval != null) {
            List knownComps = tracker.getValues(this.knowns, ref.getLocus());
            for (VariantContext c : knownComps) {
                if (eval.getType() != c.getType() && eval.getType() != VariantContext.Type.NO_VARIATION) continue;
                return KNOWN_STATES;
            }
        }
        return NOVEL_STATES;
    }
}

