/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager.StratNode;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager.Stratifier;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

class StratNodeIterator<T extends Stratifier>
implements Iterator<StratNode<T>> {
    Queue<Iterator<StratNode<T>>> iterators = new LinkedList<Iterator<StratNode<T>>>();
    Iterator<StratNode<T>> currentIterator;

    StratNodeIterator(StratNode<T> root) {
        this.currentIterator = Collections.singleton(root).iterator();
        for (StratNode subNode : root.subnodes.values()) {
            this.iterators.add(new StratNodeIterator(subNode));
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentIterator.hasNext() || !this.iterators.isEmpty();
    }

    @Override
    public StratNode<T> next() {
        if (this.currentIterator.hasNext()) {
            return this.currentIterator.next();
        }
        if (!this.iterators.isEmpty()) {
            this.currentIterator = this.iterators.poll();
            return this.next();
        }
        throw new IllegalStateException("Next called on empty iterator");
    }

    @Override
    public void remove() {
        throw new ReviewedStingException("Cannot remove from StratNode iterator");
    }
}

