/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEval;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.RequiredStratification;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.StandardStratification;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.VariantContextUtils;

public class VariantEvalUtils {
    private final VariantEval variantEvalWalker;
    Logger logger;

    public VariantEvalUtils(VariantEval variantEvalWalker) {
        this.variantEvalWalker = variantEvalWalker;
        this.logger = variantEvalWalker.getLogger();
    }

    public void listModulesAndExit() {
        List vsClasses = new PluginManager(VariantStratifier.class).getPlugins();
        List veClasses = new PluginManager(VariantEvaluator.class).getPlugins();
        this.logger.info("Available stratification modules:");
        this.logger.info("(Standard modules are starred)");
        for (Class vsClass : vsClasses) {
            this.logger.info("\t" + vsClass.getSimpleName() + (RequiredStratification.class.isAssignableFrom(vsClass) || StandardStratification.class.isAssignableFrom(vsClass) ? "*" : ""));
        }
        this.logger.info("");
        this.logger.info("Available evaluation modules:");
        this.logger.info("(Standard modules are starred)");
        for (Class veClass : veClasses) {
            this.logger.info("\t" + veClass.getSimpleName() + (StandardEval.class.isAssignableFrom(veClass) ? "*" : ""));
        }
        this.logger.info("");
        System.exit(0);
    }

    public List<VariantStratifier> initializeStratificationObjects(boolean noStandardStrats, String[] modulesToUse) {
        TreeSet<VariantStratifier> strats = new TreeSet<VariantStratifier>();
        HashSet<String> stratsToUse = new HashSet<String>();
        HashMap classMap = new HashMap();
        for (Class clazz : new PluginManager(VariantStratifier.class).getPlugins()) {
            classMap.put(clazz.getSimpleName(), clazz);
        }
        for (Class clazz : new PluginManager(RequiredStratification.class).getPlugins()) {
            if (!classMap.containsKey(clazz.getSimpleName())) continue;
            stratsToUse.add(clazz.getSimpleName());
        }
        if (!noStandardStrats) {
            for (Class<Object> clazz : new PluginManager(StandardStratification.class).getPlugins()) {
                if (!classMap.containsKey(clazz.getSimpleName())) continue;
                stratsToUse.add(clazz.getSimpleName());
            }
        }
        stratsToUse.addAll(Arrays.asList(modulesToUse));
        for (String string : stratsToUse) {
            if (!classMap.containsKey(string)) {
                throw new UserException.CommandLineException("Module " + string + " could not be found; please check that you have specified the class name correctly");
            }
            if (!classMap.containsKey(string)) continue;
            Class c = (Class)classMap.get(string);
            try {
                VariantStratifier vs = (VariantStratifier)c.newInstance();
                vs.setVariantEvalWalker(this.variantEvalWalker);
                vs.initialize();
                strats.add(vs);
            }
            catch (InstantiationException e) {
                throw new StingException("Unable to instantiate stratification module '" + c.getSimpleName() + "'");
            }
            catch (IllegalAccessException e) {
                throw new StingException("Illegal access error when trying to instantiate stratification module '" + c.getSimpleName() + "'");
            }
        }
        return new ArrayList<VariantStratifier>(strats);
    }

    public Set<Class<? extends VariantEvaluator>> initializeEvaluationObjects(boolean noStandardEvals, String[] modulesToUse) {
        HashSet<Class<? extends VariantEvaluator>> evals = new HashSet<Class<? extends VariantEvaluator>>();
        HashMap classMap = new HashMap();
        for (Class c : new PluginManager(VariantEvaluator.class).getPlugins()) {
            classMap.put(c.getSimpleName(), c);
        }
        if (!noStandardEvals) {
            for (Class stdClass : new PluginManager(StandardEval.class).getPlugins()) {
                if (!classMap.containsKey(stdClass.getSimpleName())) continue;
                evals.add((Class<? extends VariantEvaluator>)classMap.get(stdClass.getSimpleName()));
            }
        }
        for (String module : modulesToUse) {
            if (!classMap.containsKey(module)) {
                throw new UserException.CommandLineException("Module " + module + " could not be found; please check that you have specified the class name correctly");
            }
            if (!classMap.containsKey(module)) continue;
            evals.add((Class<? extends VariantEvaluator>)classMap.get(module));
        }
        return evals;
    }

    public VariantContext getSubsetOfVariantContext(VariantContext vc, String sampleName) {
        return this.getSubsetOfVariantContext(vc, Collections.singleton(sampleName));
    }

    public VariantContext getSubsetOfVariantContext(VariantContext vc, Set<String> sampleNames) {
        boolean deriveAlleles = this.variantEvalWalker.ignoreAC0Sites();
        return this.ensureAnnotations(vc, vc.subContextFromSamples(sampleNames, deriveAlleles));
    }

    public VariantContext ensureAnnotations(VariantContext vc, VariantContext vcsub) {
        boolean hasChrCountAnnotations;
        int newAlleleCount;
        int originalAlleleCount = vc.getHetCount() + 2 * vc.getHomVarCount();
        boolean isSingleton = originalAlleleCount == (newAlleleCount = vcsub.getHetCount() + 2 * vcsub.getHomVarCount()) && newAlleleCount == 1;
        boolean bl = hasChrCountAnnotations = vcsub.hasAttribute("AC") && vcsub.hasAttribute("AF") && vcsub.hasAttribute("AN");
        if (!isSingleton && hasChrCountAnnotations) {
            return vcsub;
        }
        VariantContextBuilder builder = new VariantContextBuilder(vcsub);
        if (isSingleton) {
            builder.attribute("ISSINGLETON", true);
        }
        if (!hasChrCountAnnotations) {
            VariantContextUtils.calculateChromosomeCounts(builder, true);
        }
        return builder.make();
    }

    public HashMap<RodBinding<VariantContext>, HashMap<String, Collection<VariantContext>>> bindVariantContexts(RefMetaDataTracker tracker, ReferenceContext ref, List<RodBinding<VariantContext>> tracks, boolean byFilter, boolean subsetBySample, boolean trackPerSample, boolean mergeTracks) {
        if (tracker == null) {
            return null;
        }
        HashMap<RodBinding<VariantContext>, HashMap<String, Collection<VariantContext>>> bindings = new HashMap<RodBinding<VariantContext>, HashMap<String, Collection<VariantContext>>>();
        RodBinding<VariantContext> firstTrack = tracks.isEmpty() ? null : tracks.get(0);
        for (RodBinding<VariantContext> track : tracks) {
            HashMap<String, Collection<VariantContext>> mapping = new HashMap<String, Collection<VariantContext>>();
            Iterator<VariantContext> i$ = tracker.getValues(track, ref.getLocus()).iterator();
            while (i$.hasNext()) {
                VariantContext vc;
                VariantContext vcsub = vc = i$.next();
                if (subsetBySample && vc.hasGenotypes()) {
                    vcsub = this.getSubsetOfVariantContext(vc, this.variantEvalWalker.getSampleNamesForEvaluation());
                }
                if (byFilter || !vcsub.isFiltered()) {
                    this.addMapping(mapping, VariantEval.getAllSampleName(), vcsub);
                }
                if (!vc.hasGenotypes() || !trackPerSample) continue;
                for (String sampleName : this.variantEvalWalker.getSampleNamesForEvaluation()) {
                    VariantContext samplevc = this.getSubsetOfVariantContext(vc, sampleName);
                    if (!byFilter && samplevc.isFiltered()) continue;
                    this.addMapping(mapping, sampleName, samplevc);
                }
            }
            if (mergeTracks && bindings.containsKey(firstTrack)) {
                HashMap<String, Collection<VariantContext>> firstMapping = bindings.get(firstTrack);
                for (Map.Entry elt : mapping.entrySet()) {
                    Collection<VariantContext> firstMappingSet = firstMapping.get(elt.getKey());
                    if (firstMappingSet != null) {
                        firstMappingSet.addAll((Collection)elt.getValue());
                        continue;
                    }
                    firstMapping.put((String)elt.getKey(), (Collection<VariantContext>)elt.getValue());
                }
                continue;
            }
            bindings.put(track, mapping);
        }
        return bindings;
    }

    private void addMapping(HashMap<String, Collection<VariantContext>> mappings, String sample, VariantContext vc) {
        if (!mappings.containsKey(sample)) {
            mappings.put(sample, new ArrayList(1));
        }
        mappings.get(sample).add(vc);
    }
}

