/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.variant.GATKVCFUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;

@DocumentedGATKFeature(groupName="Variant Evaluation and Manipulation Tools", extraDocs={CommandLineGATK.class})
@Reference(window=@Window(start=-200, stop=200))
public class LeftAlignVariants
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Output(doc="File to which variants should be written", required=true)
    protected VariantContextWriter baseWriter = null;
    private VariantContextWriter writer;

    @Override
    public void initialize() {
        String trackName = this.variantCollection.variants.getName();
        Set<String> samples = SampleUtils.getSampleListWithVCFHeader(this.getToolkit(), Arrays.asList(trackName));
        Map<String, VCFHeader> vcfHeaders = GATKVCFUtils.getVCFHeadersFromRods(this.getToolkit(), Arrays.asList(trackName));
        Set<VCFHeaderLine> headerLines = vcfHeaders.get(trackName).getMetaDataInSortedOrder();
        this.baseWriter.writeHeader(new VCFHeader(headerLines, samples));
        this.writer = VariantContextWriterFactory.sortOnTheFly(this.baseWriter, 200);
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        List<VariantContext> VCs = tracker.getValues(this.variantCollection.variants, context.getLocation());
        int changedSites = 0;
        for (VariantContext vc : VCs) {
            changedSites += this.alignAndWrite(vc, ref);
        }
        return changedSites;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.writer.close();
        System.out.println(result + " variants were aligned");
    }

    private int alignAndWrite(VariantContext vc, ReferenceContext ref) {
        if (vc.isBiallelic() && vc.isIndel() && !vc.isComplexIndel()) {
            return this.writeLeftAlignedIndel(vc, ref);
        }
        this.writer.add(vc);
        return 0;
    }

    private int writeLeftAlignedIndel(VariantContext vc, ReferenceContext ref) {
        byte[] refSeq = ref.getBases();
        int indelLength = vc.isSimpleDeletion() ? vc.getReference().length() - 1 : vc.getAlternateAllele(0).length() - 1;
        if (indelLength > 200) {
            this.writer.add(vc);
            return 0;
        }
        int originalIndex = ref.getLocus().getStart() - ref.getWindow().getStart() + 1;
        byte[] originalIndel = LeftAlignVariants.makeHaplotype(vc, refSeq, originalIndex, indelLength);
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>();
        elements.add(new CigarElement(originalIndex, CigarOperator.M));
        elements.add(new CigarElement(indelLength, vc.isSimpleDeletion() ? CigarOperator.D : CigarOperator.I));
        elements.add(new CigarElement(refSeq.length - originalIndex, CigarOperator.M));
        Cigar originalCigar = new Cigar(elements);
        Cigar newCigar = AlignmentUtils.leftAlignIndel(originalCigar, refSeq, originalIndel, 0, 0, true);
        if (!newCigar.equals(originalCigar) && newCigar.numCigarElements() > 1) {
            int difference = originalIndex - newCigar.getCigarElement(0).getLength();
            VariantContext newVC = new VariantContextBuilder(vc).start(vc.getStart() - difference).stop(vc.getEnd() - difference).make();
            int indelIndex = originalIndex - difference;
            byte[] newBases = new byte[indelLength + 1];
            newBases[0] = refSeq[indelIndex - 1];
            System.arraycopy(vc.isSimpleDeletion() ? refSeq : originalIndel, indelIndex, newBases, 1, indelLength);
            Allele newAllele = Allele.create(newBases, vc.isSimpleDeletion());
            newVC = LeftAlignVariants.updateAllele(newVC, newAllele);
            this.writer.add(newVC);
            return 1;
        }
        this.writer.add(vc);
        return 0;
    }

    private static byte[] makeHaplotype(VariantContext vc, byte[] ref, int indexOfRef, int indelLength) {
        byte[] hap = new byte[ref.length + indelLength * (vc.isSimpleDeletion() ? -1 : 1)];
        System.arraycopy(ref, 0, hap, 0, indexOfRef);
        int currentPos = indexOfRef;
        if (vc.isSimpleDeletion()) {
            indexOfRef += indelLength;
        } else {
            System.arraycopy(vc.getAlternateAllele(0).getBases(), 1, hap, currentPos, indelLength);
            currentPos += indelLength;
        }
        System.arraycopy(ref, indexOfRef, hap, currentPos, ref.length - indexOfRef);
        return hap;
    }

    public static VariantContext updateAllele(VariantContext vc, Allele newAllele) {
        HashMap<Allele, Allele> alleleMap = new HashMap<Allele, Allele>(vc.getAlleles().size());
        if (newAllele.isReference()) {
            alleleMap.put(vc.getReference(), newAllele);
            alleleMap.put(vc.getAlternateAllele(0), Allele.create(newAllele.getBases()[0], false));
        } else {
            alleleMap.put(vc.getReference(), Allele.create(newAllele.getBases()[0], true));
            alleleMap.put(vc.getAlternateAllele(0), newAllele);
        }
        GenotypesContext newGenotypes = GenotypesContext.create(vc.getNSamples());
        for (Genotype genotype : vc.getGenotypes()) {
            ArrayList<Allele> newAlleles = new ArrayList<Allele>();
            for (Allele allele : genotype.getAlleles()) {
                Allele newA = (Allele)alleleMap.get(allele);
                if (newA == null) {
                    newA = Allele.NO_CALL;
                }
                newAlleles.add(newA);
            }
            newGenotypes.add(new GenotypeBuilder(genotype).alleles(newAlleles).make());
        }
        return new VariantContextBuilder(vc).alleles(alleleMap.values()).genotypes(newGenotypes).make();
    }
}

