/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.jna.lsf.v7_0_6;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import org.broadinstitute.sting.jna.clibrary.JNAUtils;
import org.broadinstitute.sting.jna.clibrary.LibC;

public class LibLsf {
    public static final String PASSWD_FILE_LS = "passwd.lsfuser";
    public static final int PASSWORD_LEN = 64;
    public static final int MAXHOSTNAMELEN;
    public static final int MAXPATHLEN = 1024;
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRIT = 2;
    public static final int LOG_ERR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_DEBUG = 7;
    public static final int INVALID_SOCKET = -1;
    public static final String _VERSION_STR_ = "Platform LSF 7.0";
    public static final String _WORKGROUP_STR_ = "";
    public static final String _MINOR_STR_ = "";
    public static final String _BUILD_STR_ = "";
    public static final String _NOTE_STR_ = "";
    public static final String _HOTFIX_STR_ = "";
    public static final String _OS_STR_ = "";
    public static final String _DATE_STR_ = "";
    public static final String _BUILD_INFO_ = ", \nCopyright 1992-2009 Platform Computing Corporation\n\n";
    public static final String _LS_VERSION_ = "Platform LSF 7.0, \nCopyright 1992-2009 Platform Computing Corporation\n\n";
    public static final int LSF_XDR_VERSION2_0 = 1;
    public static final int LSF_XDR_VERSION2_1 = 2;
    public static final int LSF_XDR_VERSION2_2 = 3;
    public static final int LSF_XDR_VERSION3_0 = 4;
    public static final int LSF_XDR_VERSION3_1 = 5;
    public static final int LSF_XDR_VERSION3_2 = 6;
    public static final int LSF_XDR_VERSION3_2_2 = 7;
    public static final int LSF_XDR_VERSION4_0 = 8;
    public static final int LSF_XDR_VERSION4_1 = 9;
    public static final int LSF_XDR_VERSION4_2 = 10;
    public static final int LSF_XDR_VERSION5_0 = 11;
    public static final int LSF_XDR_VERSION5_1 = 12;
    public static final int LSF_XDR_VERSION6_0 = 13;
    public static final int LSF_XDR_VERSION6_1 = 14;
    public static final int LSF_XDR_VERSION6_2 = 15;
    public static final int EGO_XDR_VERSION_1_1 = 16;
    public static final int LSF_XDR_VERSION7_0 = 17;
    public static final int EGO_XDR_VERSION_1_2 = 17;
    public static final int LSF_XDR_VERSION7_0_EP1 = 18;
    public static final int LSF_XDR_VERSION7_0_EP2 = 19;
    public static final int LSF_XDR_VERSION7_0_EP3 = 20;
    public static final int LSF_XDR_VERSION7_0_EP4 = 21;
    public static final int LSF_XDR_VERSION7_0_EP5 = 22;
    public static final int LSF_XDR_VERSION7_0_EP6 = 23;
    public static final int EGO_XDR_VERSION_1_2_2 = 18;
    public static final int EGO_XDR_VERSION_1_2_3 = 19;
    public static final int EGO_XDR_VERSION = 19;
    public static final int LSF_DEFAULT_SOCKS = 15;
    public static final int MAXLINELEN = 512;
    public static final int MAXLSFNAMELEN = 40;
    public static final int MAXLSFNAMELEN_70_EP1 = 128;
    public static final int MAXSRES = 32;
    public static final int MAXRESDESLEN = 256;
    public static final int NBUILTINDEX = 11;
    public static final int MAXTYPES = 128;
    public static final int MAXMODELS = 1026;
    public static final int MAXMODELS_70 = 128;
    public static final int MAXTYPES_31 = 25;
    public static final int MAXMODELS_31 = 30;
    public static final int MAXFILENAMELEN = 256;
    public static final int MAXEVARS = 30;
    public static final int GENMALLOCPACE = 1024;
    public static final int FIRST_RES_SOCK = 20;
    public static final int R15S = 0;
    public static final int R1M = 1;
    public static final int R15M = 2;
    public static final int UT = 3;
    public static final int PG = 4;
    public static final int IO = 5;
    public static final int LS = 6;
    public static final int IT = 7;
    public static final int TMP = 8;
    public static final int SWP = 9;
    public static final int MEM = 10;
    public static final int USR1 = 11;
    public static final int USR2 = 12;
    public static final float INFINIT_LOAD = 2.1474836E9f;
    public static final float INFINIT_FLOAT = 2.1474836E9f;
    public static final int INFINIT_INT = Integer.MAX_VALUE;
    public static final long INFINIT_LONG_INT = Long.MAX_VALUE;
    public static final short INFINIT_SHORT = Short.MAX_VALUE;
    public static final int DEFAULT_RLIMIT = -1;
    public static final int LSF_RLIMIT_CPU = 0;
    public static final int LSF_RLIMIT_FSIZE = 1;
    public static final int LSF_RLIMIT_DATA = 2;
    public static final int LSF_RLIMIT_STACK = 3;
    public static final int LSF_RLIMIT_CORE = 4;
    public static final int LSF_RLIMIT_RSS = 5;
    public static final int LSF_RLIMIT_NOFILE = 6;
    public static final int LSF_RLIMIT_OPEN_MAX = 7;
    public static final int LSF_RLIMIT_VMEM = 8;
    public static final int LSF_RLIMIT_SWAP = 8;
    public static final int LSF_RLIMIT_RUN = 9;
    public static final int LSF_RLIMIT_PROCESS = 10;
    public static final int LSF_RLIMIT_THREAD = 11;
    public static final int LSF_RLIM_NLIMITS = 12;
    public static final int LSF_RLIM_NLIMITS5_1 = 11;
    public static final int LSF_NULL_MODE = 0;
    public static final int LSF_LOCAL_MODE = 1;
    public static final int LSF_REMOTE_MODE = 2;
    public static final int RF_MAXHOSTS = 5;
    public static final int RF_CMD_MAXHOSTS = 0;
    public static final int RF_CMD_RXFLAGS = 2;
    public static final int STATUS_TIMEOUT = 125;
    public static final int STATUS_IOERR = 124;
    public static final int STATUS_EXCESS = 123;
    public static final int STATUS_REX_NOMEM = 122;
    public static final int STATUS_REX_FATAL = 121;
    public static final int STATUS_REX_CWD = 120;
    public static final int STATUS_REX_PTY = 119;
    public static final int STATUS_REX_SP = 118;
    public static final int STATUS_REX_FORK = 117;
    public static final int STATUS_REX_AFS = 116;
    public static final int STATUS_REX_UNKNOWN = 115;
    public static final int STATUS_REX_NOVCL = 114;
    public static final int STATUS_REX_NOSYM = 113;
    public static final int STATUS_REX_VCL_INIT = 112;
    public static final int STATUS_REX_VCL_SPAWN = 111;
    public static final int STATUS_REX_EXEC = 110;
    public static final int STATUS_REX_MLS_INVAL = 109;
    public static final int STATUS_REX_MLS_CLEAR = 108;
    public static final int STATUS_REX_MLS_RHOST = 107;
    public static final int STATUS_REX_MLS_DOMIN = 106;
    public static final int STATUS_DENIED = 105;
    public static final int REXF_USEPTY = 1;
    public static final int REXF_CLNTDIR = 2;
    public static final int REXF_TASKPORT = 4;
    public static final int REXF_SHMODE = 8;
    public static final int REXF_TASKINFO = 16;
    public static final int REXF_REQVCL = 32;
    public static final int REXF_SYNCNIOS = 64;
    public static final int REXF_TTYASYNC = 128;
    public static final int REXF_STDERR = 256;
    public static final int EXACT = 1;
    public static final int OK_ONLY = 2;
    public static final int NORMALIZE = 4;
    public static final int LOCALITY = 8;
    public static final int IGNORE_RES = 16;
    public static final int LOCAL_ONLY = 32;
    public static final int DFT_FROMTYPE = 64;
    public static final int ALL_CLUSTERS = 128;
    public static final int EFFECTIVE = 256;
    public static final int RECV_FROM_CLUSTERS = 512;
    public static final int NEED_MY_CLUSTER_NAME = 1024;
    public static final int SEND_TO_CLUSTERS = 1024;
    public static final int NO_SORT = 2048;
    public static final int EXCLUSIVE_RESOURCE = 4096;
    public static final int DT_CLUSTER_LOAD = 8192;
    public static final int FROM_MASTER = 1;
    public static final int KEEPUID = 1;
    public static final int RES_CMD_REBOOT = 1;
    public static final int RES_CMD_SHUTDOWN = 2;
    public static final int RES_CMD_LOGON = 3;
    public static final int RES_CMD_LOGOFF = 4;
    public static final int LIM_CMD_REBOOT = 1;
    public static final int LIM_CMD_SHUTDOWN = 2;
    public static final int LIM_CMD_REMOVEHOST = 3;
    public static final int LIM_CMD_ACTIVATE = 4;
    public static final int LIM_CMD_DEACTIVATE = 5;
    public static final int LIM_CMD_ELIM_ENV = 6;
    public static final int INTEGER_BITS = 32;
    public static final int LIM_UNAVAIL = 65536;
    public static final int LIM_LOCKEDU = 131072;
    public static final int LIM_LOCKEDW = 262144;
    public static final int LIM_BUSY = 524288;
    public static final int LIM_RESDOWN = 0x100000;
    public static final int LIM_UNLICENSED = 0x200000;
    public static final int LIM_SBDDOWN = 0x400000;
    public static final int LIM_LOCKEDM = 0x800000;
    public static final int LIM_OK_MASK = 0xBF0000;
    public static final int LIM_PEMDOWN = 0x1000000;
    public static final int LIM_LOCKEDU_RMS = Integer.MIN_VALUE;
    public static final int RESF_BUILTIN = 1;
    public static final int RESF_DYNAMIC = 2;
    public static final int RESF_GLOBAL = 4;
    public static final int RESF_SHARED = 8;
    public static final int RESF_LIC = 16;
    public static final int RESF_EXTERNAL = 32;
    public static final int RESF_RELEASE = 64;
    public static final int RESF_DEFINED_IN_RESOURCEMAP = 128;
    public static final int RESF_NON_CONSUMABLE = 256;
    public static final int RESF_REDEFINABLE = 512;
    public static final int RESF_ESRES = 1024;
    public static final int CLUST_STAT_OK = 1;
    public static final int CLUST_STAT_UNAVAIL = 2;
    public static final int CLUST_STAT_RECV_FROM = 4;
    public static final int CLUST_STAT_SEND_TO = 8;
    public static final int NUM_SUBS = 2;
    public static final int LEN_SUBS = 64;
    public static final int NUM_CLASS_TYPE = 3;
    public static final int LSE_NO_ERR = 0;
    public static final int LSE_BAD_XDR = 1;
    public static final int LSE_MSG_SYS = 2;
    public static final int LSE_BAD_ARGS = 3;
    public static final int LSE_MASTR_UNKNW = 4;
    public static final int LSE_LIM_DOWN = 5;
    public static final int LSE_PROTOC_LIM = 6;
    public static final int LSE_SOCK_SYS = 7;
    public static final int LSE_ACCEPT_SYS = 8;
    public static final int LSE_BAD_TASKF = 9;
    public static final int LSE_NO_HOST = 10;
    public static final int LSE_NO_ELHOST = 11;
    public static final int LSE_TIME_OUT = 12;
    public static final int LSE_NIOS_DOWN = 13;
    public static final int LSE_LIM_DENIED = 14;
    public static final int LSE_LIM_IGNORE = 15;
    public static final int LSE_LIM_BADHOST = 16;
    public static final int LSE_LIM_ALOCKED = 17;
    public static final int LSE_LIM_NLOCKED = 18;
    public static final int LSE_LIM_BADMOD = 19;
    public static final int LSE_SIG_SYS = 20;
    public static final int LSE_BAD_EXP = 21;
    public static final int LSE_NORCHILD = 22;
    public static final int LSE_MALLOC = 23;
    public static final int LSE_LSFCONF = 24;
    public static final int LSE_BAD_ENV = 25;
    public static final int LSE_LIM_NREG = 26;
    public static final int LSE_RES_NREG = 27;
    public static final int LSE_RES_NOMORECONN = 28;
    public static final int LSE_BADUSER = 29;
    public static final int LSE_RES_ROOTSECURE = 30;
    public static final int LSE_RES_DENIED = 31;
    public static final int LSE_BAD_OPCODE = 32;
    public static final int LSE_PROTOC_RES = 33;
    public static final int LSE_RES_CALLBACK = 34;
    public static final int LSE_RES_NOMEM = 35;
    public static final int LSE_RES_FATAL = 36;
    public static final int LSE_RES_PTY = 37;
    public static final int LSE_RES_SOCK = 38;
    public static final int LSE_RES_FORK = 39;
    public static final int LSE_NOMORE_SOCK = 40;
    public static final int LSE_WDIR = 41;
    public static final int LSE_LOSTCON = 42;
    public static final int LSE_RES_INVCHILD = 43;
    public static final int LSE_RES_KILL = 44;
    public static final int LSE_PTYMODE = 45;
    public static final int LSE_BAD_HOST = 46;
    public static final int LSE_PROTOC_NIOS = 47;
    public static final int LSE_WAIT_SYS = 48;
    public static final int LSE_SETPARAM = 49;
    public static final int LSE_RPIDLISTLEN = 50;
    public static final int LSE_BAD_CLUSTER = 51;
    public static final int LSE_RES_VERSION = 52;
    public static final int LSE_EXECV_SYS = 53;
    public static final int LSE_RES_DIR = 54;
    public static final int LSE_RES_DIRW = 55;
    public static final int LSE_BAD_SERVID = 56;
    public static final int LSE_NLSF_HOST = 57;
    public static final int LSE_UNKWN_RESNAME = 58;
    public static final int LSE_UNKWN_RESVALUE = 59;
    public static final int LSE_TASKEXIST = 60;
    public static final int LSE_BAD_TID = 61;
    public static final int LSE_TOOMANYTASK = 62;
    public static final int LSE_LIMIT_SYS = 63;
    public static final int LSE_BAD_NAMELIST = 64;
    public static final int LSE_NO_LICENSE = 65;
    public static final int LSE_LIM_NOMEM = 66;
    public static final int LSE_NIO_INIT = 67;
    public static final int LSE_CONF_SYNTAX = 68;
    public static final int LSE_FILE_SYS = 69;
    public static final int LSE_CONN_SYS = 70;
    public static final int LSE_SELECT_SYS = 71;
    public static final int LSE_EOF = 72;
    public static final int LSE_ACCT_FORMAT = 73;
    public static final int LSE_BAD_TIME = 74;
    public static final int LSE_FORK = 75;
    public static final int LSE_PIPE = 76;
    public static final int LSE_ESUB = 77;
    public static final int LSE_DCE_EXEC = 78;
    public static final int LSE_EAUTH = 79;
    public static final int LSE_NO_FILE = 80;
    public static final int LSE_NO_CHAN = 81;
    public static final int LSE_BAD_CHAN = 82;
    public static final int LSE_INTERNAL = 83;
    public static final int LSE_PROTOCOL = 84;
    public static final int LSE_THRD_SYS = 85;
    public static final int LSE_MISC_SYS = 86;
    public static final int LSE_LOGON_FAIL = 87;
    public static final int LSE_RES_RUSAGE = 88;
    public static final int LSE_NO_RESOURCE = 89;
    public static final int LSE_BAD_RESOURCE = 90;
    public static final int LSE_RES_PARENT = 91;
    public static final int LSE_NO_PASSWD = 92;
    public static final int LSE_SUDOERS_CONF = 93;
    public static final int LSE_SUDOERS_ROOT = 94;
    public static final int LSE_I18N_SETLC = 95;
    public static final int LSE_I18N_CATOPEN = 96;
    public static final int LSE_I18N_NOMEM = 97;
    public static final int LSE_NO_MEM = 98;
    public static final int LSE_REGISTRY_SYS = 99;
    public static final int LSE_FILE_CLOSE = 100;
    public static final int LSE_LIMCONF_NOTREADY = 101;
    public static final int LSE_MASTER_LIM_DOWN = 102;
    public static final int LSE_MLS_INVALID = 103;
    public static final int LSE_MLS_CLEARANCE = 104;
    public static final int LSE_MLS_RHOST = 105;
    public static final int LSE_MLS_DOMINATE = 106;
    public static final int LSE_NO_CAL = 107;
    public static final int LSE_NO_NETWORK = 108;
    public static final int LSE_GETCONF_FAILED = 109;
    public static final int LSE_TSSINIT = 110;
    public static final int LSE_DYNM_DENIED = 111;
    public static final int LSE_LIC_OVERUSE = 112;
    public static final int LSE_EGOCONF = 113;
    public static final int LSE_BAD_EGO_ENV = 114;
    public static final int LSE_EGO_CONF_SYNTAX = 115;
    public static final int LSE_EGO_GETCONF_FAILED = 116;
    public static final int LSE_NS_LOOKUP = 117;
    public static final int LSE_BAD_PASSWD = 118;
    public static final int LSE_UNKWN_USER = 119;
    public static final int LSE_NOT_WINHOST = 120;
    public static final int LSE_NOT_MASTERCAND = 121;
    public static final int LSE_HOST_UNAUTH = 122;
    public static final int LSE_UNRESOLVALBE_HOST = 123;
    public static final int LSE_RESOURCE_NOT_CONSUMABLE = 124;
    public static final int LSE_SHUTDOWN = 125;
    public static final int LSE_BAD_SYNTAX = 126;
    public static final int LSE_NERR = 127;
    public static final int LC_SCHED = 1;
    public static final int LC_EXEC = 2;
    public static final int LC_TRACE = 4;
    public static final int LC_COMM = 8;
    public static final int LC_XDR = 16;
    public static final int LC_CHKPNT = 32;
    public static final int LC_LICENCE = 64;
    public static final int LC_LICENSE = 64;
    public static final int LC_FILE = 128;
    public static final int LC_AFS = 256;
    public static final int LC_AUTH = 512;
    public static final int LC_HANG = 1024;
    public static final int LC_MULTI = 2048;
    public static final int LC_SIGNAL = 4096;
    public static final int LC_DCE = 8192;
    public static final int LC_PIM = 16384;
    public static final int LC_MEMORY = 16384;
    public static final int LC_SYS = 32768;
    public static final int LC_JLIMIT = 65536;
    public static final int LC_FAIR = 131072;
    public static final int LC_PREEMPT = 262144;
    public static final int LC_PEND = 524288;
    public static final int LC_EEVENTD = 0x100000;
    public static final int LC_LOADINDX = 0x200000;
    public static final int LC_RESOURCE = 0x200000;
    public static final int LC_JGRP = 0x400000;
    public static final int LC_JARRAY = 0x800000;
    public static final int LC_MPI = 0x1000000;
    public static final int LC_ELIM = 0x2000000;
    public static final int LC_M_LOG = 0x4000000;
    public static final int LC_PERFM = 0x8000000;
    public static final int LC_DLOG = 0x10000000;
    public static final int LC_HPC = 0x20000000;
    public static final int LC_LICSCHED = 0x40000000;
    public static final int LC_XDRVERSION = Integer.MIN_VALUE;
    public static final int LC_FLEX = Integer.MIN_VALUE;
    public static final int LC_ADVRSV = 0x10000000;
    public static final int LC_RESREQ = 0x4000000;
    public static final int LOG_DEBUG1 = 8;
    public static final int LOG_DEBUG2 = 9;
    public static final int LOG_DEBUG3 = 10;
    public static final int LSF_EVENT_LIM_DOWN = 1;
    public static final int LSF_EVENT_RES_DOWN = 2;
    public static final int LSF_EVENT_SBD_DOWN = 3;
    public static final int LSF_EVENT_HOST_UNLIC = 4;
    public static final int LSF_EVENT_MASTER_ELECT = 5;
    public static final int LSF_EVENT_MASTER_RESIGN = 6;
    public static final int LSF_EVENT_MBD_UP = 7;
    public static final int LSF_EVENT_MBD_DOWN = 8;
    public static final int LSF_EVENT_MBD_RECONFIG = 9;
    public static final int LSF_EVENT_WORKDIR_FULL = 10;
    public static final int LSF_EVENT_HOST_OPENED = 11;
    public static final int LSF_EVENT_HOST_CLOSED = 12;
    public static final int LSF_EVENT_QUEUE_OPENED = 13;
    public static final int LSF_EVENT_QUEUE_CLOSED = 14;
    public static final int LSF_EVENT_SCH_DOWN = 15;
    public static final int LSF_EVENT_LIC_OVERUSE = 16;
    public static final int LSF_NIOS_REQUEUE = 127;
    public static final int LSF_VERSION = 23;
    public static final String LSF_CURRENT_VERSION = "7.06";
    public static final String LSF_PRODUCT_COPYRIGHT_STR = "Copyright 1992-2009 Platform Computing Corp.";
    public static final String LSF_NAME_STR = "Platform LSF";
    public static final String LSF_IDENTIFIER_STR = "";
    public static final String LSF_PRODUCT_NAME_STR = "Platform LSF";
    public static final String LSF_PRODUCT_COMMENT_STR = "";
    public static final String LSF_PRODUCT_BUILD_STR = "";
    public static final String LSF_PRODUCT_BUILD_DATE_STR = "";
    public static final int LSF_PRODUCT_MAJOR_VERSION = 7;
    public static final int LSF_PRODUCT_MINOR_VERSION = 0;
    public static final int LSF_PRODUCT_MAINTAIN_VERSION = 6;
    public static final String LSF_PRODUCT_MAJOR_VERSION_STR = "7";
    public static final String LSF_PRODUCT_MINOR_VERSION_STR = "0";
    public static final String LSF_PRODUCT_MAINTAIN_VERSION_STR = "6";
    public static final String LSF_PRODUCT_VERSION_STR = "7.0.6";
    public static final String LSF_FILE_VERSION_STR = "7.0.6";
    public static final String _VERSION_STR_LSID_ = "Platform LSF HPC 7";
    public static final String _LSID_VERSION_ = "Platform LSF HPC 7 Update , \nCopyright 1992-2009 Platform Computing Corporation\n";
    public int lsf_res_version;

    public static boolean SOCK_INVALID(int c) {
        return c == -1;
    }

    public static boolean REX_FATAL_ERROR(int s) {
        return s == 114 || s == 113 || s == 122 || s == 121 || s == 120 || s == 119 || s == 112 || s == 111 || s == 109 || s == 108 || s == 107 || s == 106;
    }

    public static int GET_INTNUM(int i) {
        return i / 32 + 1;
    }

    public static boolean LS_ISUNAVAIL(int[] status) {
        return status != null && (status[0] & 0x10000) != 0;
    }

    public static boolean LS_ISBUSYON(int[] status, int index) {
        return status != null && (status[1 + index / 32] & 1 << index % 32) != 0;
    }

    public static boolean LS_ISBUSY(int[] status) {
        return status != null && (status[0] & 0x80000) != 0;
    }

    public static boolean LS_ISRMSLOCK(int[] status) {
        return status != null && (status[0] & Integer.MIN_VALUE) != 0;
    }

    public static boolean LS_ISLOCKEDU(int[] status) {
        return status != null && (status[0] & 0x20000) != 0;
    }

    public static boolean LS_ISLOCKEDW(int[] status) {
        return status != null && (status[0] & 0x40000) != 0;
    }

    public static boolean LS_ISLOCKEDM(int[] status) {
        return status != null && (status[0] & 0x800000) != 0;
    }

    public static boolean LS_ISLOCKED(int[] status) {
        return status != null && (status[0] & 0x860000) != 0;
    }

    public static boolean LS_ISRESDOWN(int[] status) {
        return status != null && (status[0] & 0x100000) != 0;
    }

    public static boolean LS_ISSBDDOWN(int[] status) {
        return status != null && (status[0] & 0x400000) != 0;
    }

    public static boolean LS_ISPEMDOWN(int[] status) {
        return (status[0] & 0x1000000) != 0;
    }

    public static boolean LS_ISUNLICENSED(int[] status) {
        return status != null && (status[0] & 0x200000) != 0;
    }

    public static boolean LS_ISOK(int[] status) {
        return status != null && (status[0] & 0xBF0000) == 0;
    }

    public static boolean LS_ISOKNRES(int[] status) {
        return status != null && (status[0] & Integer.MAX_VALUE & 0xFEAFFFFF) == 0;
    }

    public static boolean IS_DEFAULT_AUTH(byte[] auth) {
        return auth == null || auth[0] == 0;
    }

    public static boolean HAS_BATCH_LICENSES(int featureEnabled) {
        return JNAUtils.toBoolean(featureEnabled & 0x100000) || JNAUtils.toBoolean(featureEnabled & 0x200000) || JNAUtils.toBoolean(featureEnabled & 0x40000000) || JNAUtils.toBoolean(featureEnabled & 0x2000000) || JNAUtils.toBoolean(featureEnabled & 0x4000000);
    }

    public static boolean HAS_SYMPHONY_LICENSES(int featureEnabled) {
        return JNAUtils.toBoolean(featureEnabled & 0x2000000) || JNAUtils.toBoolean(featureEnabled & 0x4000000);
    }

    public static boolean LSE_ISBAD_RESREQ(int s) {
        return s == 21 || s == 58 || s == 59;
    }

    public static boolean LSE_SYSCALL(int s) {
        return s == 71 || s == 70 || s == 69 || s == 2 || s == 7 || s == 8 || s == 20 || s == 48 || s == 53 || s == 63 || s == 76 || s == 77 || s == 99 || s == 86;
    }

    public static native int ls_readconfenv(config_param var0, String var1);

    public static native Pointer ls_placereq(String var0, IntByReference var1, int var2, String var3);

    public static native Pointer ls_placeofhosts(String var0, IntByReference var1, int var2, String var3, Pointer var4, int var5);

    public static native hostLoad.ByReference ls_load(String var0, IntByReference var1, int var2, String var3);

    public static native hostLoad.ByReference ls_loadofhosts(String var0, IntByReference var1, int var2, String var3, Pointer var4, int var5);

    public static native hostLoad.ByReference ls_loadinfo(String var0, IntByReference var1, int var2, String var3, Pointer var4, int var5, Pointer var6);

    public static native int ls_loadadj(String var0, placeInfo var1, int var2);

    public static native int ls_eligible(String var0, String var1, byte var2);

    public static native String ls_resreq(String var0);

    public static native int ls_insertrtask(String var0);

    public static native int ls_insertltask(String var0);

    public static native int ls_deletertask(String var0);

    public static native int ls_deleteltask(String var0);

    public static native int ls_listrtask(Pointer var0, int var1);

    public static native int ls_listltask(Pointer var0, int var1);

    public static native Pointer ls_findmyconnections();

    public static native int ls_isconnected(String var0);

    public static native String ls_getclustername();

    public static native clusterInfo.ByReference ls_clusterinfo(String var0, IntByReference var1, Pointer var2, int var3, int var4);

    public static native lsSharedResourceInfo.ByReference ls_sharedresourceinfo(Pointer var0, IntByReference var1, String var2, int var3);

    public static native String ls_getmastername();

    public static native String ls_getmyhostname();

    public static native String ls_getmyhostname2();

    public static native hostInfo.ByReference ls_gethostinfo(String var0, IntByReference var1, Pointer var2, int var3, int var4);

    public static native String ls_getISVmode();

    public static native int ls_isshutdown();

    public static native int ls_isPartialLicensingEnabled();

    public static native lsInfo.ByReference ls_info();

    public static native Pointer ls_indexnames(lsInfo var0);

    public static native int ls_isclustername(String var0);

    public static native String ls_gethosttype(String var0);

    public static native FloatByReference ls_getmodelfactor(String var0);

    public static native FloatByReference ls_gethostfactor(String var0);

    public static native String ls_gethostmodel(String var0);

    public static native int ls_lockhost(NativeLong var0);

    public static native int ls_unlockhost();

    public static native int ls_limcontrol(String var0, int var1);

    public static native void ls_remtty(int var0, int var1);

    public static native void ls_loctty(int var0);

    public static native String ls_sysmsg();

    public static native void ls_perror(String var0);

    public static native lsConf.ByReference ls_getconf(String var0);

    public static native void ls_freeconf(lsConf var0);

    public static native sharedConf.ByReference ls_readshared(String var0);

    public static native clusterConf.ByReference ls_readcluster(String var0, lsInfo var1);

    public static native clusterConf.ByReference ls_readcluster_ex(String var0, lsInfo var1, int var2);

    public static native int _ls_initdebug(String var0);

    public static native void ls_syslog(int var0, String var1, Pointer var2);

    public static native void ls_errlog(Pointer var0, String var1, Pointer var2);

    public static native int ls_fdbusy(int var0);

    public static native String ls_getmnthost(String var0);

    public static native int ls_servavail(int var0, int var1);

    public static native int ls_getpriority(IntByReference var0);

    public static native int ls_setpriority(int var0);

    public static native void ls_ruunix2lsf(rusage var0, lsfRusage var1);

    public static native void ls_rulsf2unix(lsfRusage var0, rusage var1);

    public static native void cleanLsfRusage(lsfRusage var0);

    public static native void cleanRusage(rusage var0);

    public static native int ls_postevent(int var0, String var1, Pointer var2, int var3);

    public static native int ls_postmultievent(int var0, String var1, Pointer var2, int var3, int var4);

    public static int isspace(byte c) {
        return c == 32 || c == 9 || c == 10 || c == 11 || c == 12 || c == 13 ? 8 : 0;
    }

    public static native int ls_initdebug(String var0);

    public static native int ls_initrex(int var0, int var1);

    public static int ls_init(int a, int b) {
        return LibLsf.ls_initrex(a, b);
    }

    public static native int ls_donerex();

    public static native int ls_niossync(int var0);

    public static native int ls_setstdin(int var0, IntByReference var1, int var2);

    public static native int ls_getstdin(int var0, IntByReference var1, int var2);

    public static native int ls_setstdout(int var0, String var1);

    public static native int ls_stdinmode(int var0);

    public static native int ls_stoprex();

    public static native int ls_chdir(String var0, String var1);

    public static native int ls_connect(String var0);

    public static native int ls_rkill(int var0, int var1);

    public static native int ls_rsetenv(String var0, Pointer var1);

    public static native int ls_rsetenv_async(String var0, Pointer var1);

    public static native int ls_rescontrol(String var0, int var1, int var2);

    public static native lsfAcctRec.ByReference ls_getacctrec(Pointer var0, IntByReference var1);

    public static native int ls_putacctrec(Pointer var0, lsfAcctRec var1);

    public static native int ls_rexecv(String var0, Pointer var1, int var2);

    public static native int ls_rexecve(String var0, Pointer var1, int var2, Pointer var3);

    public static native int ls_rexecv2(String var0, Pointer var1, int var2);

    public static native int ls_startserver(String var0, Pointer var1, int var2);

    public static native int ls_rtask(String var0, Pointer var1, int var2);

    public static native int ls_rtaske(String var0, Pointer var1, int var2, Pointer var3);

    public static native int ls_rtask2(String var0, Pointer var1, int var2, Pointer var3);

    public static native int ls_rwait(IntByReference var0, int var1, rusage var2);

    public static native int ls_rwaittid(int var0, IntByReference var1, int var2, rusage var3);

    public static native int ls_conntaskport(int var0);

    public static native int ls_ropen(String var0, String var1, int var2, int var3);

    public static native int ls_rclose(int var0);

    public static native int ls_rwrite(int var0, String var1, int var2);

    public static native int ls_rread(int var0, String var1, int var2);

    public static native NativeLong ls_rlseek(int var0, NativeLong var1, int var2);

    public static native int ls_runlink(String var0, String var1);

    public static native int ls_rfstat(int var0, Pointer var1);

    public static native int ls_rstat(String var0, String var1, Pointer var2);

    public static native String ls_rgetmnthost(String var0, String var1);

    public static native int ls_rfcontrol(int var0, int var1);

    public static native int ls_rfterminate(String var0);

    static {
        String lsfLibDir;
        if (Platform.isMac()) {
            NativeLibrary.getInstance("environhack");
        }
        if ((lsfLibDir = System.getenv("LSF_LIBDIR")) != null) {
            NativeLibrary.addSearchPath("lsf", lsfLibDir);
        }
        Native.register("lsf");
        MAXHOSTNAMELEN = JNAUtils.MAXHOSTNAMELEN;
    }

    public static class extResInfo
    extends Structure {
        public String name;
        public String type;
        public String interval;
        public String increasing;
        public String des;

        public extResInfo() {
        }

        public extResInfo(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends extResInfo
        implements Structure.ByValue {
        }

        public static class ByReference
        extends extResInfo
        implements Structure.ByReference {
        }
    }

    public static class ls_timeval
    extends Structure {
        public float rtime;
        public float utime;
        public float stime;

        public ls_timeval() {
        }

        public ls_timeval(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends ls_timeval
        implements Structure.ByValue {
        }

        public static class ByReference
        extends ls_timeval
        implements Structure.ByReference {
        }
    }

    public static class params_key_value_pair
    extends Structure {
        public int num_params;
        public String daemon_time;
        public Pointer param;

        public params_key_value_pair() {
        }

        public params_key_value_pair(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends params_key_value_pair
        implements Structure.ByValue {
        }

        public static class ByReference
        extends params_key_value_pair
        implements Structure.ByReference {
        }
    }

    public static class param_entry
    extends Structure {
        public static int HAS_PARAM_VALUE = 1;
        public static final int HAS_PARAM_DEFAULT = 2;
        public int flags;
        public String key;
        public String value;
        public String default_value;

        public param_entry() {
        }

        public param_entry(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends param_entry
        implements Structure.ByValue {
        }

        public static class ByReference
        extends param_entry
        implements Structure.ByReference {
        }
    }

    public static class lsfLicUsage
    extends Structure {
        public licUsage licUsage;
        public hostClassInfo[] hostInfo = new hostClassInfo[3];
        public byte[] substitution = new byte[128];
        public byte[] cluster = new byte[256];

        public lsfLicUsage() {
        }

        public lsfLicUsage(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends lsfLicUsage
        implements Structure.ByValue {
        }

        public static class ByReference
        extends lsfLicUsage
        implements Structure.ByReference {
        }
    }

    public static class hostClassInfo
    extends Structure {
        public int numHosts;
        public int numCpus;
        public int numCores;

        public hostClassInfo() {
        }

        public hostClassInfo(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends hostClassInfo
        implements Structure.ByValue {
        }

        public static class ByReference
        extends hostClassInfo
        implements Structure.ByReference {
        }
    }

    public static class licUsage
    extends Structure {
        public int licDisplayMask;
        public int usingDemoLicense;
        public float[] total = new float[31];
        public float[] inUse = new float[31];

        public licUsage() {
        }

        public licUsage(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends licUsage
        implements Structure.ByValue {
        }

        public static class ByReference
        extends licUsage
        implements Structure.ByReference {
        }
    }

    public static class jRusage
    extends Structure {
        public int mem;
        public int swap;
        public int utime;
        public int stime;
        public int npids;
        public Pointer pidInfo;
        public int npgids;
        public IntByReference pgid;
        public int nthreads;

        public jRusage() {
        }

        public jRusage(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends jRusage
        implements Structure.ByValue {
        }

        public static class ByReference
        extends jRusage
        implements Structure.ByReference {
        }
    }

    public static class pidInfo
    extends Structure {
        public int pid;
        public int ppid;
        public int pgid;
        public int jobid;

        public pidInfo() {
        }

        public pidInfo(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends pidInfo
        implements Structure.ByValue {
        }

        public static class ByReference
        extends pidInfo
        implements Structure.ByReference {
        }
    }

    public static class clusterConf
    extends Structure {
        public clusterInfo.ByReference clinfo;
        public int numHosts;
        public Pointer hosts;
        public int defaultFeatures;
        public int numShareRes;
        public Pointer shareRes;

        public clusterConf() {
        }

        public clusterConf(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends clusterConf
        implements Structure.ByValue {
        }

        public static class ByReference
        extends clusterConf
        implements Structure.ByReference {
        }
    }

    public static class lsSharedResourceInfo
    extends Structure {
        public String resourceName;
        public int nInstances;
        public Pointer instances;

        public lsSharedResourceInfo() {
        }

        public lsSharedResourceInfo(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends lsSharedResourceInfo
        implements Structure.ByValue {
        }

        public static class ByReference
        extends lsSharedResourceInfo
        implements Structure.ByReference {
        }
    }

    public static class lsSharedResourceInstance
    extends Structure {
        public String value;
        public int nHosts;
        public Pointer hostList;

        public lsSharedResourceInstance() {
        }

        public lsSharedResourceInstance(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends lsSharedResourceInstance
        implements Structure.ByValue {
        }

        public static class ByReference
        extends lsSharedResourceInstance
        implements Structure.ByReference {
        }
    }

    public static class sharedConf
    extends Structure {
        public lsInfo.ByReference lsinfo;
        public int numCls;
        public Pointer clusterNames;
        public Pointer servers;

        public sharedConf() {
        }

        public sharedConf(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends sharedConf
        implements Structure.ByValue {
        }

        public static class ByReference
        extends sharedConf
        implements Structure.ByReference {
        }
    }

    public static class lsConf
    extends Structure {
        public confHandle.ByReference confhandle;
        public int numConds;
        public Pointer conds;
        public IntByReference values;

        public lsConf() {
        }

        public lsConf(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends lsConf
        implements Structure.ByValue {
        }

        public static class ByReference
        extends lsConf
        implements Structure.ByReference {
        }
    }

    public static class confHandle
    extends Structure {
        public confNode.ByReference rootNode;
        public String fname;
        public confNode.ByReference curNode;
        public int lineCount;
        public pStack.ByReference ptrStack;

        public confHandle() {
        }

        public confHandle(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends confHandle
        implements Structure.ByValue {
        }

        public static class ByReference
        extends confHandle
        implements Structure.ByReference {
        }
    }

    public static class pStack
    extends Structure {
        public int top;
        public int size;
        public PointerByReference nodes;

        public pStack() {
        }

        public pStack(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends pStack
        implements Structure.ByValue {
        }

        public static class ByReference
        extends pStack
        implements Structure.ByReference {
        }
    }

    public static class confNode
    extends Structure {
        public ByReference leftPtr;
        public ByReference rightPtr;
        public ByReference fwPtr;
        public String cond;
        public int beginLineNum;
        public int numLines;
        public Pointer lines;
        public byte tag;

        public confNode() {
        }

        public confNode(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends confNode
        implements Structure.ByValue {
        }

        public static class ByReference
        extends confNode
        implements Structure.ByReference {
        }
    }

    public static class lsfAcctRec
    extends Structure {
        public int pid;
        public String username;
        public int exitStatus;
        public NativeLong dispTime;
        public NativeLong termTime;
        public String fromHost;
        public String execHost;
        public String cwd;
        public String cmdln;
        public lsfRusage lsfRu;

        public lsfAcctRec() {
        }

        public lsfAcctRec(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends lsfAcctRec
        implements Structure.ByValue {
        }

        public static class ByReference
        extends lsfAcctRec
        implements Structure.ByReference {
        }
    }

    public static class lsfRusage
    extends Structure {
        public double ru_utime;
        public double ru_stime;
        public double ru_maxrss;
        public double ru_ixrss;
        public double ru_ismrss;
        public double ru_idrss;
        public double ru_isrss;
        public double ru_minflt;
        public double ru_majflt;
        public double ru_nswap;
        public double ru_inblock;
        public double ru_oublock;
        public double ru_ioch;
        public double ru_msgsnd;
        public double ru_msgrcv;
        public double ru_nsignals;
        public double ru_nvcsw;
        public double ru_nivcsw;
        public double ru_exutime;

        public lsfRusage() {
        }

        public lsfRusage(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends lsfRusage
        implements Structure.ByValue {
        }

        public static class ByReference
        extends lsfRusage
        implements Structure.ByReference {
        }
    }

    public static class config_param
    extends Structure {
        public String paramName;
        public String paramValue;

        public config_param() {
        }

        public config_param(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends config_param
        implements Structure.ByValue {
        }

        public static class ByReference
        extends config_param
        implements Structure.ByReference {
        }
    }

    public static class hostInfo
    extends Structure {
        public byte[] hostName = new byte[MAXHOSTNAMELEN];
        public String hostType;
        public String hostModel;
        public float cpuFactor;
        public int maxCpus;
        public int maxMem;
        public int maxSwap;
        public int maxTmp;
        public int nDisks;
        public int nRes;
        public Pointer resources;
        public int nDRes;
        public Pointer DResources;
        public String windows;
        public int numIndx;
        public FloatByReference busyThreshold;
        public byte isServer;
        public byte licensed;
        public int rexPriority;
        public int licFeaturesNeeded;
        public static final int LSF_BASE_LIC = 0;
        public static final int LSF_BATCH_LIC_OBSOLETE = 1;
        public static final int LSF_JS_SCHEDULER_LIC = 2;
        public static final int LSF_JS_LIC = 3;
        public static final int LSF_CLIENT_LIC = 4;
        public static final int LSF_MC_LIC = 5;
        public static final int LSF_ANALYZER_SERVER_LIC = 6;
        public static final int LSF_MAKE_LIC = 7;
        public static final int LSF_PARALLEL_LIC = 8;
        public static final int LSF_FLOAT_CLIENT_LIC = 9;
        public static final int LSF_FTA_LIC = 10;
        public static final int LSF_AFTER_HOURS_LIC = 11;
        public static final int LSF_RESOURCE_PREEMPT_LIC = 12;
        public static final int LSF_BACCT_LIC = 13;
        public static final int LSF_SCHED_FAIRSHARE_LIC = 14;
        public static final int LSF_SCHED_RESERVE_LIC = 15;
        public static final int LSF_SCHED_PREEMPTION_LIC = 16;
        public static final int LSF_SCHED_PARALLEL_LIC = 17;
        public static final int LSF_SCHED_ADVRSV_LIC = 18;
        public static final int LSF_API_CLIENT_LIC = 19;
        public static final int CLUSTERWARE_MANAGER_LIC = 20;
        public static final int LSF_MANAGER_LIC = 21;
        public static final int LSF_PCC_HPC_LIC = 22;
        public static final int sCLUSTERWARE_LIC = 23;
        public static final int OTTAWA_MANAGER_LIC = 24;
        public static final int SYMPHONY_MANAGER_ONLINE_LIC = 25;
        public static final int SYMPHONY_MANAGER_BATCH_LIC = 26;
        public static final int SYMPHONY_SCHED_JOB_PRIORITY_LIC = 27;
        public static final int LSF_DUALCORE_X86_LIC = 28;
        public static final int LSF_TSCHED_LIC = 29;
        public static final int LSF_WORKGROUP_LIC = 30;
        public static final int LSF_NUM_LIC_TYPE = 31;
        public static final int LSF_WG_NUM_LIC_TYPE = 2;
        public static final int LSF_NO_NEED_LIC = 32;
        public int licClass;
        public int cores;
        public static final int INET6_ADDRSTRLEN = 46;
        public byte[] hostAddr = new byte[46];
        public int pprocs;
        public int cores_per_proc;
        public int threads_per_core;

        public hostInfo() {
        }

        public hostInfo(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends hostInfo
        implements Structure.ByValue {
        }

        public static class ByReference
        extends hostInfo
        implements Structure.ByReference {
        }
    }

    public static class clusterInfo
    extends Structure {
        public byte[] clusterName = new byte[40];
        public int status;
        public byte[] masterName = new byte[MAXHOSTNAMELEN];
        public byte[] managerName = new byte[40];
        public int managerId;
        public int numServers;
        public int numClients;
        public int nRes;
        public Pointer resources;
        public int nTypes;
        public Pointer hostTypes;
        public int nModels;
        public Pointer hostModels;
        public int nAdmins;
        public IntByReference adminIds;
        public Pointer admins;
        public int analyzerLicFlag;
        public int jsLicFlag;
        public byte[] afterHoursWindow = new byte[512];
        public byte[] preferAuthName = new byte[40];
        public byte[] inUseAuthName = new byte[40];

        public clusterInfo() {
        }

        public clusterInfo(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends clusterInfo
        implements Structure.ByValue {
        }

        public static class ByReference
        extends clusterInfo
        implements Structure.ByReference {
        }
    }

    public static class lsInfo
    extends Structure {
        public int nRes;
        public Pointer resTable;
        public int nTypes;
        public byte[] hostTypes = new byte[5120];
        public int nModels;
        public byte[] hostModels = new byte[41040];
        public byte[] hostArchs = new byte[131328];
        public int[] modelRefs = new int[1026];
        public float[] cpuFactor = new float[1026];
        public int numIndx;
        public int numUsrIndx;

        public lsInfo() {
        }

        public lsInfo(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends lsInfo
        implements Structure.ByValue {
        }

        public static class ByReference
        extends lsInfo
        implements Structure.ByReference {
        }
    }

    public static class resItem
    extends Structure {
        public byte[] name = new byte[40];
        public byte[] des = new byte[256];
        public int valueType;
        public int orderType;
        public int flags;
        public int interval;

        public resItem() {
        }

        public resItem(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends resItem
        implements Structure.ByValue {
        }

        public static class ByReference
        extends resItem
        implements Structure.ByReference {
        }
    }

    public static interface orderType {
        public static final int INCR = 0;
        public static final int DECR = 1;
        public static final int NA = 2;
    }

    public static interface valueType {
        public static final int LS_BOOLEAN = 0;
        public static final int LS_NUMERIC = 1;
        public static final int LS_STRING = 2;
        public static final int LS_EXTERNAL = 3;
    }

    public static class hostLoad
    extends Structure {
        public byte[] hostName = new byte[MAXHOSTNAMELEN];
        public IntByReference status;
        public FloatByReference li;

        public hostLoad() {
        }

        public hostLoad(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends hostLoad
        implements Structure.ByValue {
        }

        public static class ByReference
        extends hostLoad
        implements Structure.ByReference {
        }
    }

    public static class placeInfo
    extends Structure {
        public byte[] hostName = new byte[MAXHOSTNAMELEN];
        public int numtask;

        public placeInfo() {
        }

        public placeInfo(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends placeInfo
        implements Structure.ByValue {
        }

        public static class ByReference
        extends placeInfo
        implements Structure.ByReference {
        }
    }

    public static class connectEnt
    extends Structure {
        public String hostname;
        public int[] csock = new int[2];

        public connectEnt() {
        }

        public connectEnt(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends connectEnt
        implements Structure.ByValue {
        }

        public static class ByReference
        extends connectEnt
        implements Structure.ByReference {
        }
    }

    public static class rusage
    extends Structure {
        public LibC.timeval ru_utime;
        public LibC.timeval ru_stime;
        public NativeLong ru_maxrss;
        public NativeLong ru_ixrss;
        public NativeLong ru_idrss;
        public NativeLong ru_isrss;
        public NativeLong ru_minflt;
        public NativeLong ru_majflt;
        public NativeLong ru_nswap;
        public NativeLong ru_inblock;
        public NativeLong ru_oublock;
        public NativeLong ru_msgsnd;
        public NativeLong ru_msgrcv;
        public NativeLong ru_nsignals;
        public NativeLong ru_nvcsw;
        public NativeLong ru_nivcsw;

        public rusage() {
        }

        public rusage(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends rusage
        implements Structure.ByValue {
        }

        public static class ByReference
        extends rusage
        implements Structure.ByReference {
        }
    }

    public static class rlimit
    extends Structure {
        public NativeLong rlim_cur;
        public NativeLong rlim_max;

        public rlimit() {
        }

        public rlimit(Pointer p) {
            super(p);
            this.read();
        }

        public static class ByValue
        extends rlimit
        implements Structure.ByValue {
        }

        public static class ByReference
        extends rlimit
        implements Structure.ByReference {
        }
    }
}

