/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.locusiterator;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecordIterator;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.iterators.GATKSAMIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.SimpleTimer;
import org.broadinstitute.sting.utils.fasta.CachingIndexedFastaSequenceFile;
import org.broadinstitute.sting.utils.locusiterator.LIBSDownsamplingInfo;
import org.broadinstitute.sting.utils.locusiterator.LocusIteratorByState;
import org.broadinstitute.sting.utils.sam.GATKSamRecordFactory;

public class LIBSPerformance
extends CommandLineProgram {
    private static Logger logger = Logger.getLogger(LIBSPerformance.class);
    @Input(fullName="input_file", shortName="I", doc="SAM or BAM file(s)", required=true)
    public File samFile = null;
    @Input(fullName="reference_sequence", shortName="R", doc="Reference sequence file", required=true)
    public File referenceFile = null;
    @Argument(fullName="L", shortName="L", doc="Query location", required=false)
    public String location = null;
    @Argument(fullName="dt", shortName="dt", doc="Enable downsampling", required=false)
    public boolean downsample = false;

    @Override
    public int execute() throws IOException {
        SAMRecordIterator rawIterator;
        CachingIndexedFastaSequenceFile reference = new CachingIndexedFastaSequenceFile(this.referenceFile);
        GenomeLocParser genomeLocParser = new GenomeLocParser(reference);
        SAMFileReader reader = new SAMFileReader(this.samFile);
        reader.setSAMRecordFactory(new GATKSamRecordFactory());
        if (this.location == null) {
            rawIterator = reader.iterator();
        } else {
            GenomeLoc loc = genomeLocParser.parseGenomeLoc(this.location);
            rawIterator = reader.query(loc.getContig(), loc.getStart(), loc.getStop(), false);
        }
        GATKSAMIterator iterator = new GATKSAMIterator(rawIterator);
        HashSet<String> samples = new HashSet<String>();
        for (SAMReadGroupRecord rg : reader.getFileHeader().getReadGroups()) {
            samples.add(rg.getSample());
        }
        LIBSDownsamplingInfo ds = new LIBSDownsamplingInfo(this.downsample, 250);
        LocusIteratorByState libs = new LocusIteratorByState(iterator, ds, true, genomeLocParser, samples, false);
        SimpleTimer timer = new SimpleTimer().start();
        int bp = 0;
        double lastElapsed = 0.0;
        while (libs.hasNext()) {
            AlignmentContext context = libs.next();
            ++bp;
            if (!(timer.getElapsedTime() - lastElapsed > 10.0)) continue;
            logger.info(bp + " iterations at " + context.getLocation());
            lastElapsed = timer.getElapsedTime();
        }
        logger.info(String.format("runtime in seconds: %.2f", timer.getElapsedTime()));
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int returnCode = 0;
        try {
            LIBSPerformance instance = new LIBSPerformance();
            LIBSPerformance.start(instance, argv);
            returnCode = 0;
        }
        catch (Exception ex) {
            returnCode = 1;
            ex.printStackTrace();
            throw ex;
        }
        finally {
            System.exit(returnCode);
        }
    }
}

