/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pairhmm;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.MathUtils;

public abstract class PairHMM {
    protected static final Logger logger = Logger.getLogger(PairHMM.class);
    protected static final Byte MAX_CACHED_QUAL = 127;
    protected static final byte DEFAULT_GOP = 45;
    protected static final byte DEFAULT_GCP = 10;
    protected double[][] matchMetricArray = null;
    protected double[][] XMetricArray = null;
    protected double[][] YMetricArray = null;
    protected int maxHaplotypeLength;
    protected int maxReadLength;
    protected int X_METRIC_MAX_LENGTH;
    protected int Y_METRIC_MAX_LENGTH;
    private boolean initialized = false;

    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        if (readMaxLength <= 0) {
            throw new IllegalArgumentException("READ_MAX_LENGTH must be > 0 but got " + readMaxLength);
        }
        if (haplotypeMaxLength <= 0) {
            throw new IllegalArgumentException("HAPLOTYPE_MAX_LENGTH must be > 0 but got " + haplotypeMaxLength);
        }
        this.maxHaplotypeLength = haplotypeMaxLength;
        this.maxReadLength = readMaxLength;
        this.X_METRIC_MAX_LENGTH = readMaxLength + 2;
        this.Y_METRIC_MAX_LENGTH = haplotypeMaxLength + 2;
        this.matchMetricArray = new double[this.X_METRIC_MAX_LENGTH][this.Y_METRIC_MAX_LENGTH];
        this.XMetricArray = new double[this.X_METRIC_MAX_LENGTH][this.Y_METRIC_MAX_LENGTH];
        this.YMetricArray = new double[this.X_METRIC_MAX_LENGTH][this.Y_METRIC_MAX_LENGTH];
        this.initialized = true;
    }

    public final double computeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues) {
        if (!this.initialized) {
            throw new IllegalStateException("Must call initialize before calling computeReadLikelihoodGivenHaplotypeLog10");
        }
        if (haplotypeBases == null) {
            throw new IllegalArgumentException("haplotypeBases cannot be null");
        }
        if (haplotypeBases.length > this.maxHaplotypeLength) {
            throw new IllegalArgumentException("Haplotype bases is too long, got " + haplotypeBases.length + " but max is " + this.maxHaplotypeLength);
        }
        if (readBases == null) {
            throw new IllegalArgumentException("readBases cannot be null");
        }
        if (readBases.length > this.maxReadLength) {
            throw new IllegalArgumentException("readBases is too long, got " + readBases.length + " but max is " + this.maxReadLength);
        }
        if (readQuals.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and read quals aren't the same size: " + readBases.length + " vs " + readQuals.length);
        }
        if (insertionGOP.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and read insertion quals aren't the same size: " + readBases.length + " vs " + insertionGOP.length);
        }
        if (deletionGOP.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and read deletion quals aren't the same size: " + readBases.length + " vs " + deletionGOP.length);
        }
        if (overallGCP.length != readBases.length) {
            throw new IllegalArgumentException("Read bases and overall GCP aren't the same size: " + readBases.length + " vs " + overallGCP.length);
        }
        if (hapStartIndex < 0 || hapStartIndex > haplotypeBases.length) {
            throw new IllegalArgumentException("hapStartIndex is bad, must be between 0 and haplotype length " + haplotypeBases.length + " but got " + hapStartIndex);
        }
        double result = this.subComputeReadLikelihoodGivenHaplotypeLog10(haplotypeBases, readBases, readQuals, insertionGOP, deletionGOP, overallGCP, hapStartIndex, recacheReadValues);
        if (MathUtils.goodLog10Probability(result = Math.min(result, 0.0))) {
            return result;
        }
        throw new IllegalStateException("Bad likelihoods detected: " + result);
    }

    @Requires(value={"readBases.length == readQuals.length", "readBases.length == insertionGOP.length", "readBases.length == deletionGOP.length", "readBases.length == overallGCP.length", "matchMetricArray!=null", "XMetricArray!=null", "YMetricArray!=null"})
    protected abstract double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, int var7, boolean var8);

    @Ensures(value={"result >= 1"})
    protected int getNPotentialXStarts(int haplotypeSize, int readSize) {
        return Math.max(haplotypeSize - readSize + 1, 1);
    }

    @Ensures(value={"MathUtils.goodLog10Probability(result)"})
    protected double getNPotentialXStartsLikelihoodPenaltyLog10(int haplotypeSize, int readSize) {
        return -Math.log10(this.getNPotentialXStarts(haplotypeSize, readSize));
    }

    protected void dumpMatrices() {
        this.dumpMatrix("matchMetricArray", this.matchMetricArray);
        this.dumpMatrix("XMetricArray", this.XMetricArray);
        this.dumpMatrix("YMetricArray", this.YMetricArray);
    }

    @Requires(value={"name != null", "matrix != null"})
    private void dumpMatrix(String name, double[][] matrix) {
        System.out.printf("%s%n", name);
        for (int i = 0; i < matrix.length; ++i) {
            System.out.printf("\t%s[%d]", name, i);
            for (int j = 0; j < matrix[i].length; ++j) {
                if (Double.isInfinite(matrix[i][j])) {
                    System.out.printf(" %15s", String.format("%f", matrix[i][j]));
                    continue;
                }
                System.out.printf(" % 15.5e", matrix[i][j]);
            }
            System.out.println();
        }
    }

    public static int findFirstPositionWhereHaplotypesDiffer(byte[] haplotype1, byte[] haplotype2) {
        if (haplotype1 == null || haplotype1.length == 0) {
            throw new IllegalArgumentException("Haplotype1 is bad " + haplotype1);
        }
        if (haplotype2 == null || haplotype2.length == 0) {
            throw new IllegalArgumentException("Haplotype2 is bad " + haplotype2);
        }
        for (int iii = 0; iii < haplotype1.length && iii < haplotype2.length; ++iii) {
            if (haplotype1[iii] == haplotype2[iii]) continue;
            return iii;
        }
        return Math.min(haplotype1.length, haplotype2.length);
    }

    public static enum HMM_IMPLEMENTATION {
        EXACT,
        ORIGINAL,
        LOGLESS_CACHING;

    }
}

