/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import org.broadinstitute.sting.alignment.reference.bwt.BWT;
import org.broadinstitute.sting.alignment.reference.bwt.SequenceBlock;
import org.broadinstitute.sting.alignment.reference.packing.BasePackedOutputStream;
import org.broadinstitute.sting.alignment.reference.packing.UnsignedIntPackedOutputStream;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BWTWriter {
    private final OutputStream outputStream;

    public BWTWriter(File outputFile) {
        try {
            this.outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        }
        catch (FileNotFoundException ex) {
            throw new ReviewedStingException("Unable to open output file", ex);
        }
    }

    public void write(BWT bwt) {
        UnsignedIntPackedOutputStream intPackedOutputStream = new UnsignedIntPackedOutputStream(this.outputStream, ByteOrder.LITTLE_ENDIAN);
        BasePackedOutputStream<Integer> basePackedOutputStream = new BasePackedOutputStream<Integer>(Integer.class, this.outputStream, ByteOrder.LITTLE_ENDIAN);
        try {
            intPackedOutputStream.write(bwt.inverseSA0);
            intPackedOutputStream.write(bwt.counts.toArray(true));
            for (SequenceBlock block : bwt.sequenceBlocks) {
                intPackedOutputStream.write(block.occurrences.toArray(false));
                basePackedOutputStream.write(block.sequence);
            }
            intPackedOutputStream.write(bwt.counts.toArray(false));
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to read BWT from input stream.", ex);
        }
    }

    public void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to close input file", ex);
        }
    }
}

