/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk;

import com.google.java.contract.Ensures;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.ArgumentException;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.CommandLineUtils;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.arguments.GATKArgumentCollection;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.gatk.datasources.reads.LocusShardBalancer;
import org.broadinstitute.sting.gatk.datasources.reads.ReadShardBalancer;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.reference.ReferenceDataSource;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.downsampling.DownsamplingMethod;
import org.broadinstitute.sting.gatk.executive.MicroScheduler;
import org.broadinstitute.sting.gatk.filters.FilterManager;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.gatk.filters.ReadGroupBlackListFilter;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.io.stubs.Stub;
import org.broadinstitute.sting.gatk.iterators.ReadTransformer;
import org.broadinstitute.sting.gatk.iterators.ReadTransformersMode;
import org.broadinstitute.sting.gatk.phonehome.GATKRunReport;
import org.broadinstitute.sting.gatk.refdata.tracks.IndexDictionaryUtils;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrackBuilder;
import org.broadinstitute.sting.gatk.refdata.utils.RMDTriplet;
import org.broadinstitute.sting.gatk.resourcemanagement.ThreadAllocation;
import org.broadinstitute.sting.gatk.samples.SampleDB;
import org.broadinstitute.sting.gatk.samples.SampleDBBuilder;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionWalker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.DuplicateWalker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.ReadPairWalker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.RemoveProgramRecords;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.SequenceDictionaryUtils;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.interval.IntervalUtils;
import org.broadinstitute.sting.utils.recalibration.BQSRArgumentSet;
import org.broadinstitute.sting.utils.threading.ThreadEfficiencyMonitor;

public class GenomeAnalysisEngine {
    private static Logger logger = Logger.getLogger(GenomeAnalysisEngine.class);
    public static final long NO_RUNTIME_LIMIT = -1L;
    private ParsingEngine parsingEngine;
    private GenomeLocParser genomeLocParser;
    private SAMDataSource readsDataSource = null;
    private ReferenceDataSource referenceDataSource = null;
    private SampleDB sampleDB = null;
    private List<ReferenceOrderedDataSource> rodDataSources;
    private GATKArgumentCollection argCollection;
    private GenomeLocSortedSet intervals = null;
    private Map<ArgumentSource, Object> inputs = new HashMap<ArgumentSource, Object>();
    private Collection<Stub<?>> outputs = new ArrayList();
    private Collection<ReadFilter> filters;
    private List<ReadTransformer> readTransformers;
    private ThreadAllocation threadAllocation;
    private ReadMetrics cumulativeMetrics = null;
    private String myName = "GATK_" + Math.abs(GenomeAnalysisEngine.getRandomGenerator().nextInt());
    private final WalkerManager walkerManager = new WalkerManager();
    private Walker<?, ?> walker;
    private Collection<SAMReaderID> samReaderIDs = Collections.emptyList();
    private Collection<RMDTriplet> referenceMetaDataFiles;
    private ThreadEfficiencyMonitor threadEfficiencyMonitor = null;
    private static final long GATK_RANDOM_SEED = 47382911L;
    private static Random randomGenerator = new Random(47382911L);
    private BQSRArgumentSet bqsrArgumentSet = null;
    private static Map<String, String> deprecatedGATKWalkers = new HashMap<String, String>();
    private final FilterManager filterManager = new FilterManager();
    private Date startTime = null;

    public void setIntervals(GenomeLocSortedSet intervals) {
        this.intervals = intervals;
    }

    public void setWalker(Walker<?, ?> walker) {
        this.walker = walker;
    }

    public void setSAMFileIDs(Collection<SAMReaderID> samReaderIDs) {
        this.samReaderIDs = samReaderIDs;
    }

    public void setReferenceMetaDataFiles(Collection<RMDTriplet> referenceMetaDataFiles) {
        this.referenceMetaDataFiles = referenceMetaDataFiles;
    }

    public static Random getRandomGenerator() {
        return randomGenerator;
    }

    public static void resetRandomGenerator() {
        randomGenerator.setSeed(47382911L);
    }

    public static void resetRandomGenerator(long seed) {
        randomGenerator.setSeed(seed);
    }

    public BQSRArgumentSet getBQSRArgumentSet() {
        return this.bqsrArgumentSet;
    }

    public boolean hasBQSRArgumentSet() {
        return this.bqsrArgumentSet != null;
    }

    public void setBaseRecalibration(GATKArgumentCollection args) {
        this.bqsrArgumentSet = new BQSRArgumentSet(args);
    }

    public Object execute() {
        GATKRunReport.checkAWSAreValid();
        this.setStartTime(new Date());
        GATKArgumentCollection args = this.getArguments();
        if (args == null) {
            throw new ReviewedStingException("The GATKArgumentCollection passed to GenomeAnalysisEngine can not be null.");
        }
        if (this.walker == null) {
            throw new ReviewedStingException("The walker passed to GenomeAnalysisEngine can not be null.");
        }
        if (args.nonDeterministicRandomSeed) {
            GenomeAnalysisEngine.resetRandomGenerator(System.currentTimeMillis());
        }
        if (args.BQSR_RECAL_FILE != null) {
            this.setBaseRecalibration(args);
        }
        this.determineThreadAllocation();
        this.initializeDataSources();
        this.initializeIntervals();
        this.validateSuppliedIntervals();
        this.validateDataSourcesAgainstReference(this.readsDataSource, this.referenceDataSource.getReference(), this.rodDataSources);
        this.initializeSampleDB();
        MicroScheduler microScheduler = this.createMicroscheduler();
        this.threadEfficiencyMonitor = microScheduler.getThreadEfficiencyMonitor();
        this.initializeTempDirectory();
        this.initializeOutputStreams(microScheduler.getOutputTracker());
        logger.info("Creating shard strategy for " + this.readsDataSource.getReaderIDs().size() + " BAM files");
        Iterable<Shard> shardStrategy = this.getShardStrategy(this.readsDataSource, microScheduler.getReference(), this.intervals);
        logger.info("Done creating shard strategy");
        return microScheduler.execute(this.walker, shardStrategy);
    }

    public static boolean isDeprecatedWalker(String walkerName) {
        return deprecatedGATKWalkers.containsKey(walkerName);
    }

    public static String getDeprecatedMajorVersionNumber(String walkerName) {
        return deprecatedGATKWalkers.get(walkerName);
    }

    public Walker<?, ?> getWalkerByName(String walkerName) {
        try {
            return (Walker)this.walkerManager.createByName(walkerName);
        }
        catch (UserException e2) {
            UserException.DeprecatedWalker e2;
            if (GenomeAnalysisEngine.isDeprecatedWalker(walkerName)) {
                e2 = new UserException.DeprecatedWalker(walkerName, GenomeAnalysisEngine.getDeprecatedMajorVersionNumber(walkerName));
            }
            throw e2;
        }
    }

    public String getWalkerName(Class<? extends Walker> walkerType) {
        return this.walkerManager.getName(walkerType);
    }

    public String getName() {
        return this.myName;
    }

    public Collection<ReadFilter> createFilters() {
        List<ReadFilter> filters = WalkerManager.getReadFilters(this.walker, this.getFilterManager());
        if (this.getArguments().readGroupBlackList != null && this.getArguments().readGroupBlackList.size() > 0) {
            filters.add(new ReadGroupBlackListFilter(this.getArguments().readGroupBlackList));
        }
        for (String filterName : this.getArguments().readFilters) {
            filters.add((ReadFilter)this.getFilterManager().createByName(filterName));
        }
        return Collections.unmodifiableList(filters);
    }

    public void initializeReadTransformers(Walker walker) {
        ArrayList<ReadTransformer> activeTransformers = new ArrayList<ReadTransformer>();
        ReadTransformersMode overrideMode = WalkerManager.getWalkerAnnotation(walker, ReadTransformersMode.class);
        ReadTransformer.ApplicationTime overrideTime = overrideMode != null ? overrideMode.ApplicationTime() : null;
        PluginManager pluginManager = new PluginManager(ReadTransformer.class);
        for (ReadTransformer transformer : pluginManager.createAllTypes()) {
            transformer.initialize(overrideTime, this, walker);
            if (!transformer.enabled()) continue;
            activeTransformers.add(transformer);
        }
        this.setReadTransformers(activeTransformers);
    }

    public List<ReadTransformer> getReadTransformers() {
        return this.readTransformers;
    }

    private void setReadTransformers(List<ReadTransformer> readTransformers) {
        if (readTransformers == null) {
            throw new ReviewedStingException("read transformers cannot be null");
        }
        this.readTransformers = readTransformers;
    }

    private void determineThreadAllocation() {
        if (this.argCollection.numberOfDataThreads < 1) {
            throw new UserException.BadArgumentValue("num_threads", "cannot be less than 1, but saw " + this.argCollection.numberOfDataThreads);
        }
        if (this.argCollection.numberOfCPUThreadsPerDataThread < 1) {
            throw new UserException.BadArgumentValue("num_cpu_threads", "cannot be less than 1, but saw " + this.argCollection.numberOfCPUThreadsPerDataThread);
        }
        if (this.argCollection.numberOfIOThreads < 0) {
            throw new UserException.BadArgumentValue("num_io_threads", "cannot be less than 0, but saw " + this.argCollection.numberOfIOThreads);
        }
        this.threadAllocation = new ThreadAllocation(this.argCollection.numberOfDataThreads, this.argCollection.numberOfCPUThreadsPerDataThread, this.argCollection.numberOfIOThreads, this.argCollection.monitorThreadEfficiency);
    }

    public int getTotalNumberOfThreads() {
        return this.threadAllocation == null ? 1 : this.threadAllocation.getTotalNumThreads();
    }

    protected WalkerManager getWalkerManager() {
        return this.walkerManager;
    }

    private MicroScheduler createMicroscheduler() {
        if ((this.walker instanceof ReadWalker || this.walker instanceof DuplicateWalker || this.walker instanceof ReadPairWalker) && this.getArguments().referenceFile == null) {
            throw new UserException.CommandLineException("Read-based traversals require a reference file but none was given");
        }
        return MicroScheduler.create(this, this.walker, this.getReadsDataSource(), this.getReferenceDataSource().getReference(), this.getRodDataSources(), this.threadAllocation);
    }

    protected DownsamplingMethod getDownsamplingMethod() {
        GATKArgumentCollection argCollection = this.getArguments();
        DownsamplingMethod commandLineMethod = argCollection.getDownsamplingMethod();
        DownsamplingMethod walkerMethod = WalkerManager.getDownsamplingMethod(this.walker);
        DownsamplingMethod defaultMethod = DownsamplingMethod.getDefaultDownsamplingMethod(this.walker);
        DownsamplingMethod method = commandLineMethod != null ? commandLineMethod : (walkerMethod != null ? walkerMethod : defaultMethod);
        method.checkCompatibilityWithWalker(this.walker);
        return method;
    }

    protected void setDownsamplingMethod(DownsamplingMethod method) {
        this.argCollection.setDownsamplingMethod(method);
    }

    protected boolean includeReadsWithDeletionAtLoci() {
        return this.walker.includeReadsWithDeletionAtLoci();
    }

    protected void validateSuppliedReads() {
        GATKArgumentCollection arguments = this.getArguments();
        if (WalkerManager.isRequired(this.walker, DataSource.READS) && (arguments.samFiles == null || arguments.samFiles.size() == 0)) {
            throw new ArgumentException("Walker requires reads but none were provided.");
        }
        if (arguments.samFiles != null && arguments.samFiles.size() > 0 && !WalkerManager.isAllowed(this.walker, DataSource.READS)) {
            throw new ArgumentException("Walker does not allow reads but reads were provided.");
        }
        this.checkForDuplicateSamFiles();
    }

    protected void checkForDuplicateSamFiles() {
        HashSet<SAMReaderID> encounteredSamFiles = new HashSet<SAMReaderID>();
        LinkedHashSet<String> duplicateSamFiles = new LinkedHashSet<String>();
        for (SAMReaderID samFile : this.samReaderIDs) {
            if (encounteredSamFiles.contains(samFile)) {
                duplicateSamFiles.add(samFile.getSamFilePath());
                continue;
            }
            encounteredSamFiles.add(samFile);
        }
        if (duplicateSamFiles.size() > 0) {
            throw new ArgumentException("The following BAM files appear multiple times in the list of input files: " + duplicateSamFiles + " BAM files may be specified at most once.");
        }
    }

    protected void validateSuppliedReference() {
        GATKArgumentCollection arguments = this.getArguments();
        if (arguments.referenceFile == null) {
            throw new ArgumentException("Walker requires a reference but none was provided.");
        }
        if (arguments.referenceFile != null && !WalkerManager.isAllowed(this.walker, DataSource.REFERENCE)) {
            throw new ArgumentException("Walker does not allow a reference but one was provided.");
        }
    }

    protected void validateSuppliedIntervals() {
        GenomeLocSortedSet intervals;
        if (!(this.walker instanceof ReadWalker) && (intervals = this.getIntervals()) != null && this.getIntervals().contains(GenomeLoc.UNMAPPED)) {
            throw new ArgumentException("Interval list specifies unmapped region.  Only read walkers may include the unmapped region.");
        }
        if (this.intervals != null && this.intervals.isEmpty()) {
            logger.warn("The given combination of -L and -XL options results in an empty set.  No intervals to process.");
        }
    }

    protected Iterable<Shard> getShardStrategy(SAMDataSource readsDataSource, ReferenceSequenceFile drivingDataSource, GenomeLocSortedSet intervals) {
        int SHARD_SIZE;
        ValidationExclusion exclusions = readsDataSource != null ? readsDataSource.getReadsInfo().getValidationExclusionList() : null;
        DownsamplingMethod downsamplingMethod = readsDataSource != null ? readsDataSource.getReadsInfo().getDownsamplingMethod() : null;
        ReferenceDataSource referenceDataSource = this.getReferenceDataSource();
        if (!readsDataSource.isEmpty()) {
            if (!readsDataSource.hasIndex() && !exclusions.contains(ValidationExclusion.TYPE.ALLOW_UNINDEXED_BAM)) {
                throw new UserException.CommandLineException("Cannot process the provided BAM file(s) because they were not indexed.  The GATK does offer limited processing of unindexed BAMs in --unsafe mode, but this GATK feature is currently unsupported.");
            }
            if (!readsDataSource.hasIndex() && intervals != null && !this.argCollection.allowIntervalsWithUnindexedBAM) {
                throw new UserException.CommandLineException("Cannot perform interval processing when reads are present but no index is available.");
            }
            if (this.walker instanceof LocusWalker) {
                if (readsDataSource.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
                    throw new UserException.MissortedBAM(SAMFileHeader.SortOrder.coordinate, "Locus walkers can only traverse coordinate-sorted data.  Please resort your input BAM file(s) or set the Sort Order tag in the header appropriately.");
                }
                if (intervals == null) {
                    return readsDataSource.createShardIteratorOverMappedReads(referenceDataSource.getReference().getSequenceDictionary(), new LocusShardBalancer());
                }
                return readsDataSource.createShardIteratorOverIntervals(intervals, new LocusShardBalancer());
            }
            if (this.walker instanceof ActiveRegionWalker) {
                if (readsDataSource.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
                    throw new UserException.MissortedBAM(SAMFileHeader.SortOrder.coordinate, "Active region walkers can only traverse coordinate-sorted data.  Please resort your input BAM file(s) or set the Sort Order tag in the header appropriately.");
                }
                if (intervals == null) {
                    return readsDataSource.createShardIteratorOverMappedReads(referenceDataSource.getReference().getSequenceDictionary(), new LocusShardBalancer());
                }
                return readsDataSource.createShardIteratorOverIntervals(((ActiveRegionWalker)this.walker).extendIntervals(intervals, this.genomeLocParser, this.getReferenceDataSource().getReference()), new LocusShardBalancer());
            }
            if (this.walker instanceof ReadWalker || this.walker instanceof ReadPairWalker || this.walker instanceof DuplicateWalker) {
                if (this.walker instanceof ReadPairWalker) {
                    if (readsDataSource.getSortOrder() != SAMFileHeader.SortOrder.queryname) {
                        throw new UserException.MissortedBAM(SAMFileHeader.SortOrder.queryname, "Read pair walkers are exceptions in that they cannot be run on coordinate-sorted BAMs but instead require query name-sorted files.  You will need to resort your input BAM file in query name order to use this walker.");
                    }
                    if (intervals != null && !intervals.isEmpty()) {
                        throw new UserException.CommandLineException("Pairs traversal cannot be used in conjunction with intervals.");
                    }
                }
                if (intervals == null) {
                    return readsDataSource.createShardIteratorOverAllReads(new ReadShardBalancer());
                }
                return readsDataSource.createShardIteratorOverIntervals(intervals, new ReadShardBalancer());
            }
            throw new ReviewedStingException("Unable to determine walker type for walker " + this.walker.getClass().getName());
        }
        int n = SHARD_SIZE = this.walker instanceof RodWalker ? 1000000 : 100000;
        if (intervals == null) {
            return referenceDataSource.createShardsOverEntireReference(readsDataSource, this.genomeLocParser, SHARD_SIZE);
        }
        return referenceDataSource.createShardsOverIntervals(readsDataSource, intervals, SHARD_SIZE);
    }

    protected boolean flashbackData() {
        return this.walker instanceof ReadWalker;
    }

    private void initializeTempDirectory() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new UserException.BadTmpDir("Unable to create directory");
        }
    }

    private void initializeOutputStreams(OutputTracker outputTracker) {
        for (Map.Entry<ArgumentSource, Object> entry : this.getInputs().entrySet()) {
            outputTracker.addInput(entry.getKey(), entry.getValue());
        }
        for (Stub stub : this.getOutputs()) {
            outputTracker.addOutput(stub);
        }
        outputTracker.prepareWalker(this.walker, this.getArguments().strictnessLevel);
    }

    public ReferenceDataSource getReferenceDataSource() {
        return this.referenceDataSource;
    }

    public GenomeLocParser getGenomeLocParser() {
        return this.genomeLocParser;
    }

    public void setParser(ParsingEngine parsingEngine) {
        this.parsingEngine = parsingEngine;
    }

    public void setGenomeLocParser(GenomeLocParser genomeLocParser) {
        this.genomeLocParser = genomeLocParser;
    }

    protected void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    protected void initializeIntervals() {
        this.intervals = IntervalUtils.parseIntervalArguments(this.referenceDataSource, this.argCollection.intervalArguments);
    }

    public void addInput(ArgumentSource argumentSource, Object value) {
        this.inputs.put(argumentSource, value);
    }

    public void addOutput(Stub<?> stub) {
        this.outputs.add(stub);
    }

    public Tags getTags(Object key) {
        return this.parsingEngine.getTags(key);
    }

    protected void initializeDataSources() {
        logger.info("Strictness is " + (Object)((Object)this.argCollection.strictnessLevel));
        this.validateSuppliedReference();
        this.setReferenceDataSource(this.argCollection.referenceFile);
        this.validateSuppliedReads();
        this.initializeReadTransformers(this.walker);
        this.readsDataSource = this.createReadsDataSource(this.argCollection, this.genomeLocParser, this.referenceDataSource.getReference());
        for (ReadFilter filter : this.filters) {
            filter.initialize(this);
        }
        this.rodDataSources = this.getReferenceOrderedDataSources(this.referenceMetaDataFiles, this.referenceDataSource.getReference().getSequenceDictionary(), this.genomeLocParser, this.argCollection.unsafe);
    }

    private void initializeSampleDB() {
        SampleDBBuilder sampleDBBuilder = new SampleDBBuilder(this, this.argCollection.pedigreeValidationType);
        sampleDBBuilder.addSamplesFromSAMHeader(this.getSAMFileHeader());
        sampleDBBuilder.addSamplesFromSampleNames(SampleUtils.getUniqueSamplesFromRods(this));
        sampleDBBuilder.addSamplesFromPedigreeFiles(this.argCollection.pedigreeFiles);
        sampleDBBuilder.addSamplesFromPedigreeStrings(this.argCollection.pedigreeStrings);
        this.sampleDB = sampleDBBuilder.getFinalSampleDB();
    }

    public SAMReaderID getReaderIDForRead(SAMRecord read) {
        return this.getReadsDataSource().getReaderID(read);
    }

    public File getSourceFileForReaderID(SAMReaderID id) {
        return this.getReadsDataSource().getSAMFile(id);
    }

    private void validateDataSourcesAgainstReference(SAMDataSource reads, ReferenceSequenceFile reference, Collection<ReferenceOrderedDataSource> rods) {
        if (reads.isEmpty() && (rods == null || rods.isEmpty()) || reference == null) {
            return;
        }
        SAMSequenceDictionary referenceDictionary = reference.getSequenceDictionary();
        if (!reads.isEmpty()) {
            SAMSequenceDictionary readsDictionary = reads.getHeader().getSequenceDictionary();
            if (readsDictionary.size() == 0) {
                logger.info("Reads file is unmapped.  Skipping validation against reference.");
                return;
            }
            SequenceDictionaryUtils.validateDictionaries(logger, this.getArguments().unsafe, "reads", readsDictionary, "reference", referenceDictionary, true, this.intervals);
        }
        for (ReferenceOrderedDataSource rod : rods) {
            IndexDictionaryUtils.validateTrackSequenceDictionary(rod.getName(), rod.getSequenceDictionary(), referenceDictionary, this.getArguments().unsafe);
        }
    }

    private SAMDataSource createReadsDataSource(GATKArgumentCollection argCollection, GenomeLocParser genomeLocParser, IndexedFastaSequenceFile refReader) {
        boolean removeProgramRecords;
        DownsamplingMethod downsamplingMethod = this.getDownsamplingMethod();
        this.setDownsamplingMethod(downsamplingMethod);
        logger.info(downsamplingMethod);
        if (argCollection.removeProgramRecords && argCollection.keepProgramRecords) {
            throw new UserException.BadArgumentValue("rpr / kpr", "Cannot enable both options");
        }
        boolean bl = removeProgramRecords = argCollection.removeProgramRecords || this.walker.getClass().isAnnotationPresent(RemoveProgramRecords.class);
        if (argCollection.keepProgramRecords) {
            removeProgramRecords = false;
        }
        boolean keepReadsInLIBS = this.walker instanceof ActiveRegionWalker;
        return new SAMDataSource(this.samReaderIDs, this.threadAllocation, argCollection.numberOfBAMFileHandles, genomeLocParser, argCollection.useOriginalBaseQualities, argCollection.strictnessLevel, argCollection.readBufferSize, downsamplingMethod, new ValidationExclusion(Arrays.asList(argCollection.unsafe)), this.filters, this.readTransformers, this.includeReadsWithDeletionAtLoci(), argCollection.defaultBaseQualities, removeProgramRecords, keepReadsInLIBS);
    }

    public void setReferenceDataSource(File refFile) {
        this.referenceDataSource = new ReferenceDataSource(refFile);
        this.genomeLocParser = new GenomeLocParser(this.referenceDataSource.getReference());
    }

    private List<ReferenceOrderedDataSource> getReferenceOrderedDataSources(Collection<RMDTriplet> referenceMetaDataFiles, SAMSequenceDictionary sequenceDictionary, GenomeLocParser genomeLocParser, ValidationExclusion.TYPE validationExclusionType) {
        RMDTrackBuilder builder = new RMDTrackBuilder(sequenceDictionary, genomeLocParser, validationExclusionType);
        ArrayList<ReferenceOrderedDataSource> dataSources = new ArrayList<ReferenceOrderedDataSource>();
        for (RMDTriplet fileDescriptor : referenceMetaDataFiles) {
            dataSources.add(new ReferenceOrderedDataSource(fileDescriptor, builder, sequenceDictionary, genomeLocParser, this.flashbackData()));
        }
        return dataSources;
    }

    public SAMFileHeader getSAMFileHeader() {
        return this.readsDataSource.getHeader();
    }

    public boolean lenientVCFProcessing() {
        return GenomeAnalysisEngine.lenientVCFProcessing(this.argCollection.unsafe);
    }

    public static boolean lenientVCFProcessing(ValidationExclusion.TYPE val) {
        return val == ValidationExclusion.TYPE.ALL || val == ValidationExclusion.TYPE.LENIENT_VCF_PROCESSING;
    }

    public SAMFileHeader getSAMFileHeader(SAMReaderID reader) {
        return this.readsDataSource == null ? null : this.readsDataSource.getHeader(reader);
    }

    public List<SAMFileHeader> getSAMFileHeaders() {
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>();
        for (SAMReaderID id : this.getReadsDataSource().getReaderIDs()) {
            headers.add(this.getReadsDataSource().getHeader(id));
        }
        return headers;
    }

    public SAMSequenceDictionary getMasterSequenceDictionary() {
        return this.getReferenceDataSource().getReference().getSequenceDictionary();
    }

    public SAMDataSource getReadsDataSource() {
        return this.readsDataSource;
    }

    public void setArguments(GATKArgumentCollection argCollection) {
        this.argCollection = argCollection;
    }

    public GATKArgumentCollection getArguments() {
        return this.argCollection;
    }

    public GenomeLocSortedSet getIntervals() {
        return this.intervals;
    }

    @Ensures(value={"result != null"})
    public GenomeLocSortedSet getRegionsOfGenomeBeingProcessed() {
        if (this.getIntervals() == null) {
            return GenomeLocSortedSet.createSetFromSequenceDictionary(this.getReferenceDataSource().getReference().getSequenceDictionary());
        }
        return this.getIntervals();
    }

    public Collection<ReadFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<ReadFilter> filters) {
        this.filters = filters;
    }

    protected FilterManager getFilterManager() {
        return this.filterManager;
    }

    protected Map<ArgumentSource, Object> getInputs() {
        return this.inputs;
    }

    protected Collection<Stub<?>> getOutputs() {
        return this.outputs;
    }

    public List<ReferenceOrderedDataSource> getRodDataSources() {
        return this.rodDataSources;
    }

    public ReadMetrics getCumulativeMetrics() {
        if (this.cumulativeMetrics == null) {
            this.cumulativeMetrics = this.readsDataSource == null ? new ReadMetrics() : this.readsDataSource.getCumulativeReadMetrics();
        }
        return this.cumulativeMetrics;
    }

    public ThreadEfficiencyMonitor getThreadEfficiencyMonitor() {
        return this.threadEfficiencyMonitor;
    }

    public SampleDB getSampleDB() {
        return this.sampleDB;
    }

    public Map<String, String> getApproximateCommandLineArguments(Object ... argumentProviders) {
        return CommandLineUtils.getApproximateCommandLineArguments(this.parsingEngine, argumentProviders);
    }

    public String createApproximateCommandLineArgumentString(Object ... argumentProviders) {
        return CommandLineUtils.createApproximateCommandLineArgumentString(this.parsingEngine, argumentProviders);
    }

    public boolean exceedsRuntimeLimit(long runtime, TimeUnit unit) {
        long maxRuntimeNano;
        if (runtime < 0L) {
            throw new IllegalArgumentException("runtime must be >= 0 but got " + runtime);
        }
        if (this.getArguments().maxRuntime == -1L) {
            return false;
        }
        long actualRuntimeNano = TimeUnit.NANOSECONDS.convert(runtime, unit);
        return actualRuntimeNano > (maxRuntimeNano = this.getRuntimeLimitInNanoseconds());
    }

    public long getRuntimeLimitInNanoseconds() {
        if (this.getArguments().maxRuntime == -1L) {
            return -1L;
        }
        return TimeUnit.NANOSECONDS.convert(this.getArguments().maxRuntime, this.getArguments().maxRuntimeUnits);
    }

    static {
        deprecatedGATKWalkers.put("CountCovariates", "2.0");
        deprecatedGATKWalkers.put("TableRecalibration", "2.0");
        deprecatedGATKWalkers.put("AlignmentWalker", "2.2");
        deprecatedGATKWalkers.put("CountBestAlignments", "2.2");
    }
}

