/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.arguments;

import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcFactory;
import org.broadinstitute.sting.utils.collections.DefaultHashMap;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class StandardCallerArgumentCollection {
    @Argument(fullName="heterozygosity", shortName="hets", doc="Heterozygosity value used to compute prior likelihoods for any locus", required=false)
    public Double heterozygosity = 0.001;
    @Argument(fullName="genotyping_mode", shortName="gt_mode", doc="Specifies how to determine the alternate alleles to use for genotyping", required=false)
    public GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE GenotypingMode = GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.DISCOVERY;
    @Argument(fullName="output_mode", shortName="out_mode", doc="Specifies which type of calls we should output", required=false)
    public UnifiedGenotyperEngine.OUTPUT_MODE OutputMode = UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_VARIANTS_ONLY;
    @Argument(fullName="standard_min_confidence_threshold_for_calling", shortName="stand_call_conf", doc="The minimum phred-scaled confidence threshold at which variants should be called", required=false)
    public double STANDARD_CONFIDENCE_FOR_CALLING = 30.0;
    @Argument(fullName="standard_min_confidence_threshold_for_emitting", shortName="stand_emit_conf", doc="The minimum phred-scaled confidence threshold at which variants should be emitted (and filtered with LowQual if less than the calling threshold)", required=false)
    public double STANDARD_CONFIDENCE_FOR_EMITTING = 30.0;
    @Input(fullName="alleles", shortName="alleles", doc="The set of alleles at which to genotype when --genotyping_mode is GENOTYPE_GIVEN_ALLELES", required=false)
    public RodBinding<VariantContext> alleles;
    @Advanced
    @Argument(fullName="max_alternate_alleles", shortName="maxAltAlleles", doc="Maximum number of alternate alleles to genotype", required=false)
    public int MAX_ALTERNATE_ALLELES = 6;
    @Argument(fullName="contamination_fraction_to_filter", shortName="contamination", doc="Fraction of contamination in sequencing data (for all samples) to aggressively remove", required=false)
    public double CONTAMINATION_FRACTION = 0.05;
    public static final double DEFAULT_CONTAMINATION_FRACTION = 0.05;
    @Advanced
    @Argument(fullName="contamination_fraction_per_sample_file", shortName="contaminationFile", doc="Tab-separated File containing fraction of contamination in sequencing data (per sample) to aggressively remove. Format should be \"<SampleID><TAB><Contamination>\" (Contamination is double) per line; No header.", required=false)
    public File CONTAMINATION_FRACTION_FILE = null;
    private DefaultHashMap<String, Double> sampleContamination = new DefaultHashMap(this.CONTAMINATION_FRACTION);
    @Hidden
    @Argument(fullName="p_nonref_model", shortName="pnrm", doc="Non-reference probability calculation model to employ", required=false)
    public AFCalcFactory.Calculation AFmodel = AFCalcFactory.Calculation.getDefaultModel();
    @Hidden
    @Argument(fullName="logRemovedReadsFromContaminationFiltering", shortName="contaminationLog", required=false)
    public PrintStream contaminationLog = null;
    @Hidden
    @Argument(shortName="logExactCalls", doc="x", required=false)
    public File exactCallsLog = null;

    public Map<String, Double> getSampleContamination() {
        this.sampleContamination.setDefaultValue(this.CONTAMINATION_FRACTION);
        return Collections.unmodifiableMap(this.sampleContamination);
    }

    public void setSampleContamination(DefaultHashMap<String, Double> sampleContamination) {
        this.sampleContamination.clear();
        this.sampleContamination.putAll(sampleContamination);
        this.sampleContamination.setDefaultValue(this.CONTAMINATION_FRACTION);
    }

    public StandardCallerArgumentCollection() {
    }

    public StandardCallerArgumentCollection(StandardCallerArgumentCollection SCAC) {
        this.alleles = SCAC.alleles;
        this.GenotypingMode = SCAC.GenotypingMode;
        this.heterozygosity = SCAC.heterozygosity;
        this.MAX_ALTERNATE_ALLELES = SCAC.MAX_ALTERNATE_ALLELES;
        this.OutputMode = SCAC.OutputMode;
        this.STANDARD_CONFIDENCE_FOR_CALLING = SCAC.STANDARD_CONFIDENCE_FOR_CALLING;
        this.STANDARD_CONFIDENCE_FOR_EMITTING = SCAC.STANDARD_CONFIDENCE_FOR_EMITTING;
        this.CONTAMINATION_FRACTION = SCAC.CONTAMINATION_FRACTION;
        this.CONTAMINATION_FRACTION_FILE = SCAC.CONTAMINATION_FRACTION_FILE;
        this.contaminationLog = SCAC.contaminationLog;
        this.exactCallsLog = SCAC.exactCallsLog;
        this.sampleContamination = SCAC.sampleContamination;
        this.AFmodel = SCAC.AFmodel;
    }
}

