/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.datasources.providers.IntervalOverlappingRODsFromStream;
import org.broadinstitute.sting.gatk.datasources.providers.ManagingReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.View;
import org.broadinstitute.sting.gatk.datasources.reads.ReadShard;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.refdata.utils.LocationAwareSeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;

public class ReadBasedReferenceOrderedView
implements View {
    private final List<RMDDataState> states = new ArrayList<RMDDataState>(1);
    private static final RefMetaDataTracker EMPTY_TRACKER = new RefMetaDataTracker();
    private final GenomeLocParser genomeLocParser;
    private final GenomeLoc shardSpan;

    public ReadBasedReferenceOrderedView(ShardDataProvider provider) {
        this.genomeLocParser = provider.getGenomeLocParser();
        this.shardSpan = provider.getReferenceOrderedData() != null ? ((ReadShard)provider.getShard()).getReadsSpan() : null;
        provider.register(this);
        if (provider.getReferenceOrderedData() != null && !this.shardSpan.isUnmapped()) {
            for (ReferenceOrderedDataSource dataSource : provider.getReferenceOrderedData()) {
                this.states.add(new RMDDataState(dataSource, dataSource.seek(this.shardSpan)));
            }
        }
    }

    protected ReadBasedReferenceOrderedView(GenomeLocParser genomeLocParser, GenomeLoc shardSpan, List<String> names, List<PeekableIterator<RODRecordList>> featureSources) {
        this.genomeLocParser = genomeLocParser;
        this.shardSpan = shardSpan;
        for (int i = 0; i < names.size(); ++i) {
            this.states.add(new RMDDataState(names.get(i), featureSources.get(i)));
        }
    }

    @Override
    public Collection<Class<? extends View>> getConflictingViews() {
        ArrayList<Class<? extends View>> classes = new ArrayList<Class<? extends View>>();
        classes.add(ManagingReferenceOrderedView.class);
        return classes;
    }

    @Requires(value={"rec != null"})
    @Ensures(value={"result != null"})
    public RefMetaDataTracker getReferenceOrderedDataForRead(SAMRecord rec) {
        if (rec.getReadUnmappedFlag()) {
            return new RefMetaDataTracker();
        }
        return this.getReferenceOrderedDataForInterval(this.genomeLocParser.createGenomeLoc(rec));
    }

    @Requires(value={"interval != null", "shardSpan == null || shardSpan.isUnmapped() || shardSpan.containsP(interval)"})
    @Ensures(value={"result != null"})
    public RefMetaDataTracker getReferenceOrderedDataForInterval(GenomeLoc interval) {
        if (this.states.isEmpty() || this.shardSpan.isUnmapped()) {
            return EMPTY_TRACKER;
        }
        ArrayList<RODRecordList> bindings = new ArrayList<RODRecordList>(this.states.size());
        for (RMDDataState state : this.states) {
            bindings.add(state.stream.getOverlapping(interval));
        }
        return new RefMetaDataTracker(bindings);
    }

    @Override
    public void close() {
        for (RMDDataState state : this.states) {
            state.close();
        }
        this.states.clear();
    }

    private static class RMDDataState {
        public final ReferenceOrderedDataSource dataSource;
        public final IntervalOverlappingRODsFromStream stream;
        private final LocationAwareSeekableRODIterator iterator;

        public RMDDataState(ReferenceOrderedDataSource dataSource, LocationAwareSeekableRODIterator iterator) {
            this.dataSource = dataSource;
            this.iterator = iterator;
            this.stream = new IntervalOverlappingRODsFromStream(dataSource.getName(), new PeekableIterator<RODRecordList>(iterator));
        }

        public RMDDataState(String name, PeekableIterator<RODRecordList> iterator) {
            this.dataSource = null;
            this.iterator = null;
            this.stream = new IntervalOverlappingRODsFromStream(name, new PeekableIterator<RODRecordList>(iterator));
        }

        public void close() {
            if (this.dataSource != null) {
                this.dataSource.close(this.iterator);
            }
        }
    }
}

