/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.rmd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.gatk.datasources.rmd.DataStreamSegment;
import org.broadinstitute.sting.gatk.datasources.rmd.MappedStreamSegment;
import org.broadinstitute.sting.gatk.datasources.rmd.ResourcePool;
import org.broadinstitute.sting.gatk.refdata.SeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrack;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrackBuilder;
import org.broadinstitute.sting.gatk.refdata.utils.LocationAwareSeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.utils.RMDTriplet;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

class ReferenceOrderedQueryDataPool
extends ResourcePool<RMDTrack, LocationAwareSeekableRODIterator> {
    private final RMDTriplet fileDescriptor;
    private final RMDTrackBuilder builder;
    private final Object header;
    private final SAMSequenceDictionary sequenceDictionary;

    public ReferenceOrderedQueryDataPool(RMDTriplet fileDescriptor, RMDTrackBuilder builder, SAMSequenceDictionary referenceSequenceDictionary, GenomeLocParser genomeLocParser) {
        super(referenceSequenceDictionary, genomeLocParser);
        this.fileDescriptor = fileDescriptor;
        this.builder = builder;
        RMDTrack track = builder.createInstanceOfTrack(fileDescriptor);
        this.addNewResource(track);
        this.header = track.getHeader();
        this.sequenceDictionary = track.getSequenceDictionary();
    }

    public Object getHeader() {
        return this.header;
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    @Override
    protected RMDTrack createNewResource() {
        return this.builder.createInstanceOfTrack(this.fileDescriptor);
    }

    @Override
    protected RMDTrack selectBestExistingResource(DataStreamSegment segment, List<RMDTrack> availableResources) {
        for (RMDTrack reader : availableResources) {
            if (reader == null) continue;
            return reader;
        }
        return null;
    }

    @Override
    protected LocationAwareSeekableRODIterator createIteratorFromResource(DataStreamSegment position, RMDTrack track) {
        try {
            if (position instanceof MappedStreamSegment) {
                GenomeLoc pos = ((MappedStreamSegment)position).locus;
                return new SeekableRODIterator(this.header, this.sequenceDictionary, this.referenceSequenceDictionary, this.genomeLocParser, track.query(pos));
            }
            return new SeekableRODIterator(this.header, this.sequenceDictionary, this.referenceSequenceDictionary, this.genomeLocParser, track.getIterator());
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(this.fileDescriptor.getName(), "it could not be found");
        }
        catch (IOException e) {
            throw new ReviewedStingException("Unable to create iterator for rod named " + this.fileDescriptor.getName(), e);
        }
    }

    @Override
    protected void closeResource(RMDTrack track) {
        track.close();
    }
}

