/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.downsampling;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.sting.gatk.downsampling.Downsampler;
import org.broadinstitute.sting.utils.MathUtils;

public class LevelingDownsampler<T extends List<E>, E>
implements Downsampler<T> {
    private int targetSize;
    private List<T> groups;
    private boolean groupsAreFinalized;
    private int numDiscardedItems;

    public LevelingDownsampler(int targetSize) {
        this.targetSize = targetSize;
        this.clear();
        this.reset();
    }

    @Override
    public void submit(T item) {
        this.groups.add(item);
    }

    @Override
    public void submit(Collection<T> items) {
        this.groups.addAll(items);
    }

    @Override
    public boolean hasFinalizedItems() {
        return this.groupsAreFinalized && this.groups.size() > 0;
    }

    @Override
    public List<T> consumeFinalizedItems() {
        if (!this.hasFinalizedItems()) {
            return new ArrayList();
        }
        List<T> toReturn = this.groups;
        this.clear();
        return toReturn;
    }

    @Override
    public boolean hasPendingItems() {
        return !this.groupsAreFinalized && this.groups.size() > 0;
    }

    @Override
    public T peekFinalized() {
        return (T)(this.hasFinalizedItems() ? (List)this.groups.get(0) : null);
    }

    @Override
    public T peekPending() {
        return (T)(this.hasPendingItems() ? (List)this.groups.get(0) : null);
    }

    @Override
    public int getNumberOfDiscardedItems() {
        return this.numDiscardedItems;
    }

    @Override
    public void signalEndOfInput() {
        this.levelGroups();
        this.groupsAreFinalized = true;
    }

    @Override
    public void clear() {
        this.groups = new ArrayList<T>();
        this.groupsAreFinalized = false;
    }

    @Override
    public void reset() {
        this.numDiscardedItems = 0;
    }

    private void levelGroups() {
        int totalSize = 0;
        int[] groupSizes = new int[this.groups.size()];
        int currentGroupIndex = 0;
        for (List group : this.groups) {
            groupSizes[currentGroupIndex] = group.size();
            totalSize += groupSizes[currentGroupIndex];
            ++currentGroupIndex;
        }
        if (totalSize <= this.targetSize) {
            return;
        }
        int numItemsToRemove = totalSize - this.targetSize;
        currentGroupIndex = 0;
        int numConsecutiveUmodifiableGroups = 0;
        while (numItemsToRemove > 0 && numConsecutiveUmodifiableGroups < groupSizes.length) {
            if (groupSizes[currentGroupIndex] > 1) {
                int n = currentGroupIndex;
                groupSizes[n] = groupSizes[n] - 1;
                --numItemsToRemove;
                numConsecutiveUmodifiableGroups = 0;
            } else {
                ++numConsecutiveUmodifiableGroups;
            }
            currentGroupIndex = (currentGroupIndex + 1) % groupSizes.length;
        }
        currentGroupIndex = 0;
        for (List group : this.groups) {
            this.downsampleOneGroup(group, groupSizes[currentGroupIndex]);
            ++currentGroupIndex;
        }
    }

    private void downsampleOneGroup(T group, int numItemsToKeep) {
        if (numItemsToKeep >= group.size()) {
            return;
        }
        this.numDiscardedItems += group.size() - numItemsToKeep;
        BitSet itemsToKeep = new BitSet(group.size());
        for (Integer selectedIndex : MathUtils.sampleIndicesWithoutReplacement(group.size(), numItemsToKeep)) {
            itemsToKeep.set(selectedIndex);
        }
        int currentIndex = 0;
        if (group instanceof LinkedList) {
            Iterator iter = group.iterator();
            while (iter.hasNext()) {
                iter.next();
                if (!itemsToKeep.get(currentIndex)) {
                    iter.remove();
                }
                ++currentIndex;
            }
        } else {
            ArrayList keptItems = new ArrayList(numItemsToKeep);
            for (Object item : group) {
                if (itemsToKeep.get(currentIndex)) {
                    keptItems.add(item);
                }
                ++currentIndex;
            }
            group.clear();
            group.addAll(keptItems);
        }
    }
}

