/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

public class FastqFileWriter {
    private PrintStream output;

    public FastqFileWriter(String filename) {
        try {
            this.output = new PrintStream(filename);
        }
        catch (FileNotFoundException e) {
            throw new ReviewedStingException("Can't open file " + filename);
        }
    }

    public void addAlignment(GATKSAMRecord read) {
        this.output.println("@" + read.getReadName());
        if (read.getReadNegativeStrandFlag()) {
            this.output.println(ReadUtils.getBasesReverseComplement(read));
            this.output.println("+");
            this.output.println(ReadUtils.convertReadQualToString(this.invertQuals(read.getBaseQualities())));
        } else {
            this.output.println(ReadUtils.convertReadBasesToString(read));
            this.output.println("+");
            this.output.println(ReadUtils.convertReadQualToString(read));
        }
    }

    public void close() {
        this.output.close();
    }

    private byte[] invertQuals(byte[] quals) {
        int l = quals.length;
        byte[] invertedQuals = new byte[l];
        for (int i = 0; i < l; ++i) {
            invertedQuals[l - 1 - i] = quals[i];
        }
        return invertedQuals;
    }
}

