/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.gatk.executive.OutputMergeTask;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.io.storage.Storage;
import org.broadinstitute.sting.gatk.io.storage.StorageFactory;
import org.broadinstitute.sting.gatk.io.stubs.Stub;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class ThreadGroupOutputTracker
extends OutputTracker {
    private Map<ThreadGroup, Map<Stub, Storage>> threadsToStorage = new HashMap<ThreadGroup, Map<Stub, Storage>>();
    private boolean bypass = false;

    public void bypassThreadLocalStorage(boolean bypass) {
        this.bypass = bypass;
    }

    public synchronized void initializeStorage() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Map<Stub, Storage> threadLocalOutputStreams = this.threadsToStorage.get(group);
        if (threadLocalOutputStreams == null) {
            threadLocalOutputStreams = new HashMap<Stub, Storage>();
            this.threadsToStorage.put(group, threadLocalOutputStreams);
        }
        for (Stub stub : this.outputs.keySet()) {
            Storage target = StorageFactory.createStorage(stub, this.createTempFile(stub));
            threadLocalOutputStreams.put(stub, target);
        }
    }

    @Override
    public <T> T getStorage(Stub<T> stub) {
        Storage target;
        if (this.bypass) {
            target = (Storage)this.outputs.get(stub);
            if (target == null) {
                target = StorageFactory.createStorage(stub);
                this.outputs.put(stub, target);
            }
        } else {
            Map<Stub, Storage> threadLocalOutputStreams = this.findStorage(Thread.currentThread());
            target = threadLocalOutputStreams.get(stub);
            if (target == null) {
                throw new ReviewedStingException("target isn't supposed to be null for " + Thread.currentThread() + " id " + Thread.currentThread().getId() + " map is " + threadLocalOutputStreams);
            }
        }
        return (T)target;
    }

    private synchronized Map<Stub, Storage> findStorage(Thread thread) {
        Map<Stub, Storage> map = this.threadsToStorage.get(thread.getThreadGroup());
        if (map != null) {
            return map;
        }
        throw new ReviewedStingException("Couldn't find storage map associated with thread " + thread + " in group " + thread.getThreadGroup());
    }

    public synchronized OutputMergeTask closeStorage() {
        Map<Stub, Storage> threadLocalOutputStreams = this.findStorage(Thread.currentThread());
        if (threadLocalOutputStreams == null || threadLocalOutputStreams.isEmpty()) {
            return null;
        }
        OutputMergeTask outputMergeTask = new OutputMergeTask();
        for (Map.Entry<Stub, Storage> entry : threadLocalOutputStreams.entrySet()) {
            Stub stub = entry.getKey();
            Storage storageEntry = entry.getValue();
            storageEntry.close();
            outputMergeTask.addMergeOperation(this.getTargetStream(stub), storageEntry);
        }
        threadLocalOutputStreams.clear();
        return outputMergeTask;
    }

    private <T> File createTempFile(Stub<T> stub) {
        try {
            return File.createTempFile(stub.getClass().getName(), null);
        }
        catch (IOException ex) {
            throw new UserException.BadTmpDir("Unable to create temporary file for stub: " + stub.getClass().getName());
        }
    }
}

