/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.storage;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.util.RuntimeIOException;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.io.storage.Storage;
import org.broadinstitute.sting.gatk.io.stubs.SAMFileWriterStub;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.SimplifyingSAMFileWriter;

public class SAMFileWriterStorage
implements SAMFileWriter,
Storage<SAMFileWriter> {
    private final File file;
    private SAMFileWriter writer;
    private static Logger logger = Logger.getLogger(SAMFileWriterStorage.class);

    public SAMFileWriterStorage(SAMFileWriterStub stub) {
        this(stub, stub.getOutputFile());
    }

    public SAMFileWriterStorage(SAMFileWriterStub stub, File file) {
        this.file = file;
        SAMFileWriterFactory factory = new SAMFileWriterFactory();
        if (stub.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate) && stub.getIndexOnTheFly().booleanValue()) {
            factory.setCreateIndex(true);
        }
        if (stub.getGenerateMD5().booleanValue()) {
            factory.setCreateMd5File(true);
        }
        if (stub.getMaxRecordsInRam() != null) {
            factory.setMaxRecordsInRam(stub.getMaxRecordsInRam());
        }
        if (stub.getOutputFile() != null) {
            try {
                this.writer = this.createBAMWriter(factory, stub.getFileHeader(), stub.isPresorted(), file, stub.getCompressionLevel());
            }
            catch (RuntimeIOException ex) {
                throw new UserException.CouldNotCreateOutputFile(file, "file could not be created", (Exception)ex);
            }
        } else if (stub.getOutputStream() != null) {
            this.writer = factory.makeSAMWriter(stub.getFileHeader(), stub.isPresorted(), stub.getOutputStream());
        } else {
            throw new UserException("Unable to write to SAM file; neither a target file nor a stream has been specified");
        }
        if (stub.simplifyBAM()) {
            this.writer = new SimplifyingSAMFileWriter(this.writer);
        }
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.writer.getFileHeader();
    }

    @Override
    public void addAlignment(SAMRecord read) {
        this.writer.addAlignment(read);
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (RuntimeIOException e) {
            throw new UserException.ErrorWritingBamFile(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeInto(SAMFileWriter targetStream) {
        SAMFileReader reader = new SAMFileReader(this.file);
        try {
            SAMRecordIterator iterator = reader.iterator();
            while (iterator.hasNext()) {
                targetStream.addAlignment((SAMRecord)iterator.next());
            }
            iterator.close();
        }
        finally {
            reader.close();
            this.file.delete();
        }
    }

    private SAMFileWriter createBAMWriter(SAMFileWriterFactory factory, SAMFileHeader header, boolean presorted, File outputFile, Integer compressionLevel) {
        SAMFileWriter writer = compressionLevel != null ? factory.makeBAMWriter(header, presorted, outputFile, compressionLevel) : factory.makeBAMWriter(header, presorted, outputFile);
        try {
            Method prepareToWriteAlignmentsMethod = writer.getClass().getDeclaredMethod("prepareToWriteAlignments", new Class[0]);
            if (prepareToWriteAlignmentsMethod != null) {
                prepareToWriteAlignmentsMethod.setAccessible(true);
                prepareToWriteAlignmentsMethod.invoke((Object)writer, new Object[0]);
            }
        }
        catch (NoSuchMethodException ex) {
            logger.info("Unable to call prepareToWriteAlignments method; this should be reviewed when Picard is updated.");
        }
        catch (IllegalAccessException ex) {
            logger.info("Unable to access prepareToWriteAlignments method; this should be reviewed when Picard is updated.");
        }
        catch (InvocationTargetException ex) {
            logger.info("Unable to invoke prepareToWriteAlignments method; this should be reviewed when Picard is updated.");
        }
        return writer;
    }
}

