/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.storage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.sf.samtools.util.BlockCompressedOutputStream;
import org.apache.log4j.Logger;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.FeatureCodec;
import org.broadinstitute.sting.gatk.io.storage.Storage;
import org.broadinstitute.sting.gatk.io.stubs.VariantContextWriterStub;
import org.broadinstitute.sting.gatk.refdata.tracks.FeatureManager;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.variant.bcf2.BCF2Utils;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFHeader;

public class VariantContextWriterStorage
implements Storage<VariantContextWriterStorage>,
VariantContextWriter {
    private static Logger logger = Logger.getLogger(VariantContextWriterStorage.class);
    private static final int BUFFER_SIZE = 0x100000;
    protected final File file;
    protected OutputStream stream;
    protected final VariantContextWriter writer;
    boolean closed = false;

    public VariantContextWriterStorage(VariantContextWriterStub stub) {
        if (stub.getOutputFile() != null) {
            this.file = stub.getOutputFile();
            this.writer = this.vcfWriterToFile(stub, stub.getOutputFile(), true);
        } else if (stub.getOutputStream() != null) {
            this.file = null;
            this.stream = stub.getOutputStream();
            this.writer = VariantContextWriterFactory.create(this.stream, stub.getMasterSequenceDictionary(), stub.getWriterOptions(false));
        } else {
            throw new ReviewedStingException("Unable to create target to which to write; storage was provided with neither a file nor a stream.");
        }
    }

    public VariantContextWriterStorage(VariantContextWriterStub stub, File tempFile) {
        this.file = tempFile;
        this.writer = this.vcfWriterToFile(stub, this.file, false);
        this.writer.writeHeader(stub.getVCFHeader());
    }

    private VariantContextWriter vcfWriterToFile(VariantContextWriterStub stub, File file, boolean indexOnTheFly) {
        File bcfFile;
        try {
            this.stream = stub.isCompressed() ? new BlockCompressedOutputStream(file) : new PrintStream(new BufferedOutputStream(new FileOutputStream(file), 0x100000));
        }
        catch (IOException ex) {
            throw new UserException.CouldNotCreateOutputFile(file, "Unable to open target output stream", (Exception)ex);
        }
        EnumSet<Options> options = stub.getWriterOptions(indexOnTheFly);
        VariantContextWriter writer = VariantContextWriterFactory.create(file, this.stream, stub.getMasterSequenceDictionary(), options);
        if (stub.alsoWriteBCFForTest() && !VariantContextWriterFactory.isBCFOutput(file, options) && (bcfFile = BCF2Utils.shadowBCF(file)) != null) {
            VariantContextWriter bcfWriter = VariantContextWriterFactory.create(bcfFile, stub.getMasterSequenceDictionary(), options);
            writer = new TestWriter(new VariantContextWriter[]{writer, bcfWriter});
        }
        return writer;
    }

    @Override
    public void add(VariantContext vc) {
        if (this.closed) {
            throw new ReviewedStingException("Attempting to write to a closed VariantContextWriterStorage " + vc.getStart() + " storage=" + this);
        }
        this.writer.add(vc);
    }

    @Override
    public void writeHeader(VCFHeader header) {
        this.writer.writeHeader(header);
    }

    @Override
    public void close() {
        this.writer.close();
        this.closed = true;
    }

    @Override
    public void mergeInto(VariantContextWriterStorage target) {
        try {
            if (!this.closed) {
                throw new ReviewedStingException("Writer not closed, but we are merging into the file!");
            }
            String targetFilePath = target.file != null ? target.file.getAbsolutePath() : "/dev/stdin";
            logger.debug(String.format("Merging VariantContextWriterStorage from %s into %s", this.file.getAbsolutePath(), targetFilePath));
            FeatureManager.FeatureDescriptor fd = new FeatureManager().getByFiletype(this.file);
            if (fd == null) {
                throw new UserException.LocalParallelizationProblem(this.file);
            }
            FeatureCodec codec = fd.getCodec();
            AbstractFeatureReader source = AbstractFeatureReader.getFeatureReader(this.file.getAbsolutePath(), codec, false);
            for (VariantContext vc : source.iterator()) {
                target.writer.add(vc);
            }
            source.close();
            this.file.delete();
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(this.file, "Error reading file in VCFWriterStorage: ", e);
        }
    }

    private static final class TestWriter
    implements VariantContextWriter {
        final List<VariantContextWriter> writers;

        private TestWriter(VariantContextWriter ... writers) {
            this.writers = Arrays.asList(writers);
        }

        @Override
        public void writeHeader(VCFHeader header) {
            for (VariantContextWriter writer : this.writers) {
                writer.writeHeader(header);
            }
        }

        @Override
        public void close() {
            for (VariantContextWriter writer : this.writers) {
                writer.close();
            }
        }

        @Override
        public void add(VariantContext vc) {
            for (VariantContextWriter writer : this.writers) {
                writer.add(vc);
            }
        }
    }
}

