/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.stubs;

import java.lang.reflect.Type;
import net.sf.samtools.SAMFileReader;
import org.broadinstitute.sting.commandline.ArgumentMatchValue;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.SAMFileReaderBuilder;

public class SAMFileReaderArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    private GenomeAnalysisEngine engine;

    public SAMFileReaderArgumentTypeDescriptor(GenomeAnalysisEngine engine) {
        this.engine = engine;
    }

    @Override
    public boolean supports(Class type) {
        return SAMFileReader.class.isAssignableFrom(type);
    }

    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches) {
        SAMFileReaderBuilder builder = new SAMFileReaderBuilder();
        ArgumentMatchValue readerFileName = this.getArgumentValue(this.createDefaultArgumentDefinition(source), matches);
        if (readerFileName == null) {
            throw new UserException.CommandLineException("SAM file compression was supplied, but no associated writer was supplied with it.");
        }
        builder.setSAMFile(readerFileName.asFile());
        this.engine.addInput(source, builder);
        return null;
    }
}

