/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.stubs;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentIOType;
import org.broadinstitute.sting.commandline.ArgumentMatchValue;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.MissingArgumentValueException;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.io.stubs.VariantContextWriterStub;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;

public class VCFWriterArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    public static final String NO_HEADER_ARG_NAME = "no_cmdline_in_header";
    public static final String SITES_ONLY_ARG_NAME = "sites_only";
    public static final String FORCE_BCF = "bcf";
    public static final HashSet<String> SUPPORTED_ZIPPED_SUFFIXES = new HashSet();
    private final GenomeAnalysisEngine engine;
    private final OutputStream defaultOutputStream;
    private final Collection<Object> argumentSources;

    public VCFWriterArgumentTypeDescriptor(GenomeAnalysisEngine engine, OutputStream defaultOutputStream, Collection<Object> argumentSources) {
        this.engine = engine;
        this.defaultOutputStream = defaultOutputStream;
        this.argumentSources = argumentSources;
    }

    @Override
    public boolean supports(Class type) {
        return VariantContextWriter.class.equals((Object)type);
    }

    @Override
    public List<ArgumentDefinition> createArgumentDefinitions(ArgumentSource source) {
        return Arrays.asList(this.createDefaultArgumentDefinition(source), this.createNoCommandLineHeaderArgumentDefinition(), this.createSitesOnlyArgumentDefinition(), this.createBCFArgumentDefinition());
    }

    @Override
    public boolean createsTypeDefault(ArgumentSource source) {
        return source.isRequired();
    }

    @Override
    public String typeDefaultDocString(ArgumentSource source) {
        return "stdout";
    }

    @Override
    public Object createTypeDefault(ParsingEngine parsingEngine, ArgumentSource source, Type type) {
        if (!source.isRequired()) {
            throw new ReviewedStingException("BUG: tried to create type default for argument type descriptor that can't support a type default.");
        }
        VariantContextWriterStub stub = new VariantContextWriterStub(this.engine, this.defaultOutputStream, this.argumentSources);
        this.engine.addOutput(stub);
        return stub;
    }

    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches) {
        File writerFile;
        ArgumentDefinition defaultArgumentDefinition = this.createDefaultArgumentDefinition(source);
        ArgumentMatchValue writerFileName = this.getArgumentValue(defaultArgumentDefinition, matches);
        File file = writerFile = writerFileName != null ? writerFileName.asFile() : null;
        if (writerFile == null && !source.isRequired()) {
            throw new MissingArgumentValueException(defaultArgumentDefinition);
        }
        VariantContextWriterStub stub = writerFile != null ? new VariantContextWriterStub(this.engine, writerFile, this.argumentSources) : new VariantContextWriterStub(this.engine, this.defaultOutputStream, this.argumentSources);
        stub.setCompressed(VCFWriterArgumentTypeDescriptor.isCompressed(writerFileName == null ? null : writerFileName.asString()));
        stub.setDoNotWriteGenotypes(this.argumentIsPresent(this.createSitesOnlyArgumentDefinition(), matches));
        stub.setSkipWritingCommandLineHeader(this.argumentIsPresent(this.createNoCommandLineHeaderArgumentDefinition(), matches));
        stub.setForceBCF(this.argumentIsPresent(this.createBCFArgumentDefinition(), matches));
        parsingEngine.addTags(stub, this.getArgumentTags(matches));
        this.engine.addOutput(stub);
        return stub;
    }

    private ArgumentDefinition createNoCommandLineHeaderArgumentDefinition() {
        return new ArgumentDefinition(ArgumentIOType.ARGUMENT, Boolean.TYPE, NO_HEADER_ARG_NAME, NO_HEADER_ARG_NAME, "Don't output the usual VCF header tag with the command line. FOR DEBUGGING PURPOSES ONLY. This option is required in order to pass integration tests.", false, true, false, true, null, null, null, null);
    }

    private ArgumentDefinition createSitesOnlyArgumentDefinition() {
        return new ArgumentDefinition(ArgumentIOType.ARGUMENT, Boolean.TYPE, SITES_ONLY_ARG_NAME, SITES_ONLY_ARG_NAME, "Just output sites without genotypes (i.e. only the first 8 columns of the VCF)", false, true, false, true, null, null, null, null);
    }

    private ArgumentDefinition createBCFArgumentDefinition() {
        return new ArgumentDefinition(ArgumentIOType.ARGUMENT, Boolean.TYPE, FORCE_BCF, FORCE_BCF, "force BCF output, regardless of the file's extension", false, true, false, true, null, null, null, null);
    }

    public static boolean isCompressed(String writerFileName) {
        return writerFileName != null && SUPPORTED_ZIPPED_SUFFIXES.contains(VCFWriterArgumentTypeDescriptor.getFileSuffix(writerFileName));
    }

    private static String getFileSuffix(String fileName) {
        int indexOfLastDot = fileName.lastIndexOf(".");
        if (indexOfLastDot == -1) {
            return "";
        }
        return fileName.substring(indexOfLastDot).toLowerCase();
    }

    static {
        SUPPORTED_ZIPPED_SUFFIXES.add(".gz");
        SUPPORTED_ZIPPED_SUFFIXES.add(".gzip");
    }
}

