/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import java.util.Iterator;
import java.util.LinkedList;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.ReadBasedReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ReadReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.ReadShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ReadView;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.utils.nanoScheduler.NSMapFunction;
import org.broadinstitute.sting.utils.nanoScheduler.NSProgressFunction;
import org.broadinstitute.sting.utils.nanoScheduler.NSReduceFunction;
import org.broadinstitute.sting.utils.nanoScheduler.NanoScheduler;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class TraverseReadsNano<M, T>
extends TraversalEngine<M, T, ReadWalker<M, T>, ReadShardDataProvider> {
    private static final boolean PRE_READ_ALL_MAP_DATA = true;
    protected static final Logger logger = Logger.getLogger(TraverseReadsNano.class);
    private static final boolean DEBUG = false;
    final NanoScheduler<MapData, MapResult, T> nanoScheduler;
    private final MapResult SKIP_REDUCE = new MapResult();

    public TraverseReadsNano(int nThreads) {
        this.nanoScheduler = new NanoScheduler(nThreads);
        this.nanoScheduler.setProgressFunction(new NSProgressFunction<MapData>(){

            @Override
            public void progress(MapData lastProcessedMap) {
                if (lastProcessedMap.refContext != null) {
                    TraverseReadsNano.this.printProgress(lastProcessedMap.refContext.getLocus().getStopLocation());
                }
            }
        });
    }

    @Override
    public String getTraversalUnits() {
        return "reads";
    }

    @Override
    public T traverse(ReadWalker<M, T> walker, ReadShardDataProvider dataProvider, T sum) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("TraverseReadsNano.traverse Covered dataset is %s", dataProvider));
        }
        if (!dataProvider.hasReads()) {
            throw new IllegalArgumentException("Unable to traverse reads; no read data is available.");
        }
        this.nanoScheduler.setDebug(false);
        TraverseReadsMap myMap = new TraverseReadsMap(walker);
        TraverseReadsReduce myReduce = new TraverseReadsReduce(walker);
        Iterator<MapData> aggregatedInputs = this.aggregateMapData(dataProvider);
        T result = this.nanoScheduler.execute(aggregatedInputs, myMap, sum, myReduce);
        this.updateCumulativeMetrics(dataProvider.getShard());
        return result;
    }

    private Iterator<MapData> aggregateMapData(ReadShardDataProvider dataProvider) {
        Iterator<MapData> it = this.makeDataIterator(dataProvider);
        LinkedList<MapData> l = new LinkedList<MapData>();
        while (it.hasNext()) {
            l.add(it.next());
        }
        return l.iterator();
    }

    private Iterator<MapData> makeDataIterator(final ReadShardDataProvider dataProvider) {
        return new Iterator<MapData>(){
            final ReadView reads;
            final ReadReferenceView reference;
            final ReadBasedReferenceOrderedView rodView;
            final Iterator<SAMRecord> readIterator;
            {
                this.reads = new ReadView(dataProvider);
                this.reference = new ReadReferenceView(dataProvider);
                this.rodView = new ReadBasedReferenceOrderedView(dataProvider);
                this.readIterator = this.reads.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.readIterator.hasNext();
            }

            @Override
            public MapData next() {
                SAMRecord read = this.readIterator.next();
                ReferenceContext refContext = !read.getReadUnmappedFlag() ? this.reference.getReferenceContext(read) : null;
                RefMetaDataTracker tracker = read.getReferenceIndex() >= 0 ? this.rodView.getReferenceOrderedDataForRead(read) : null;
                dataProvider.getShard().getReadMetrics().incrementNumIterations();
                return new MapData((GATKSAMRecord)read, refContext, tracker);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }
        };
    }

    @Override
    public void shutdown() {
        this.nanoScheduler.shutdown();
    }

    private class TraverseReadsReduce
    implements NSReduceFunction<MapResult, T> {
        final ReadWalker<M, T> walker;

        private TraverseReadsReduce(ReadWalker<M, T> walker) {
            this.walker = walker;
        }

        @Override
        public T apply(MapResult one, T sum) {
            if (one.reduceMe) {
                return this.walker.reduce(one.value, sum);
            }
            return sum;
        }
    }

    private class TraverseReadsMap
    implements NSMapFunction<MapData, MapResult> {
        final ReadWalker<M, T> walker;

        private TraverseReadsMap(ReadWalker<M, T> walker) {
            this.walker = walker;
        }

        @Override
        public MapResult apply(MapData data) {
            boolean keepMeP;
            if (!this.walker.isDone() && (keepMeP = this.walker.filter(data.refContext, data.read))) {
                return new MapResult(this.walker.map(data.refContext, data.read, data.tracker));
            }
            return TraverseReadsNano.this.SKIP_REDUCE;
        }
    }

    private class MapResult {
        final M value;
        final boolean reduceMe;

        private MapResult(M value) {
            this.value = value;
            this.reduceMe = true;
        }

        private MapResult() {
            this.value = null;
            this.reduceMe = false;
        }
    }

    private class MapData {
        final GATKSAMRecord read;
        final ReferenceContext refContext;
        final RefMetaDataTracker tracker;

        private MapData(GATKSAMRecord read, ReferenceContext refContext, RefMetaDataTracker tracker) {
            this.read = read;
            this.refContext = refContext;
            this.tracker = tracker;
        }
    }
}

