/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers;

import com.google.java.contract.Ensures;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.filters.DuplicateReadFilter;
import org.broadinstitute.sting.gatk.filters.FailsVendorQualityCheckFilter;
import org.broadinstitute.sting.gatk.filters.MappingQualityUnavailableFilter;
import org.broadinstitute.sting.gatk.filters.NotPrimaryAlignmentFilter;
import org.broadinstitute.sting.gatk.filters.UnmappedReadFilter;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionTraversalParameters;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.RemoveProgramRecords;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.activeregion.ActiveRegionReadState;
import org.broadinstitute.sting.utils.activeregion.ActivityProfileState;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.interval.IntervalSetRule;
import org.broadinstitute.sting.utils.interval.IntervalUtils;

@By(value=DataSource.READS)
@Requires(value={DataSource.READS, DataSource.REFERENCE})
@PartitionBy(value=PartitionType.READ)
@ActiveRegionTraversalParameters(extension=50, maxRegion=1500)
@ReadFilters(value={UnmappedReadFilter.class, NotPrimaryAlignmentFilter.class, DuplicateReadFilter.class, FailsVendorQualityCheckFilter.class, MappingQualityUnavailableFilter.class})
@RemoveProgramRecords
public abstract class ActiveRegionWalker<MapType, ReduceType>
extends Walker<MapType, ReduceType> {
    @Output(fullName="activityProfileOut", shortName="APO", doc="Output the raw activity profile results in IGV format", required=false)
    public PrintStream activityProfileOutStream = null;
    @Output(fullName="activeRegionOut", shortName="ARO", doc="Output the active region to this IGV formatted file", required=false)
    public PrintStream activeRegionOutStream = null;
    @Input(fullName="activeRegionIn", shortName="AR", doc="Use this interval list file as the active regions to process", required=false)
    protected List<IntervalBinding<Feature>> activeRegionBindings = null;
    @Advanced
    @Argument(fullName="activeRegionExtension", shortName="activeRegionExtension", doc="The active region extension; if not provided defaults to Walker annotated default", required=false)
    public Integer activeRegionExtension = null;
    @Advanced
    @Argument(fullName="activeRegionMaxSize", shortName="activeRegionMaxSize", doc="The active region maximum size; if not provided defaults to Walker annotated default", required=false)
    public Integer activeRegionMaxSize = null;
    @Advanced
    @Argument(fullName="bandPassSigma", shortName="bandPassSigma", doc="The sigma of the band pass filter Gaussian kernel; if not provided defaults to Walker annotated default", required=false)
    public Double bandPassSigma = null;
    private GenomeLocSortedSet presetActiveRegions = null;

    @Override
    public void initialize() {
        if (this.activeRegionBindings == null) {
            return;
        }
        List<GenomeLoc> allIntervals = new ArrayList<GenomeLoc>(0);
        for (IntervalBinding<Feature> intervalBinding : this.activeRegionBindings) {
            List<GenomeLoc> intervals = intervalBinding.getIntervals(this.getToolkit());
            if (intervals.isEmpty()) {
                logger.warn("The interval file " + intervalBinding.getSource() + " contains no intervals that could be parsed.");
            }
            allIntervals = IntervalUtils.mergeListsBySetOperator(intervals, allIntervals, IntervalSetRule.UNION);
        }
        this.presetActiveRegions = IntervalUtils.sortAndMergeIntervals(this.getToolkit().getGenomeLocParser(), allIntervals, IntervalMergingRule.ALL);
    }

    public boolean hasPresetActiveRegions() {
        return this.presetActiveRegions != null;
    }

    public GenomeLocSortedSet getPresetActiveRegions() {
        return this.presetActiveRegions;
    }

    public boolean filter(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        return true;
    }

    public EnumSet<ActiveRegionReadState> desiredReadStates() {
        return EnumSet.of(ActiveRegionReadState.PRIMARY);
    }

    public final boolean wantsNonPrimaryReads() {
        return this.desiredReadStates().contains((Object)ActiveRegionReadState.NONPRIMARY);
    }

    public boolean wantsExtendedReads() {
        return this.desiredReadStates().contains((Object)ActiveRegionReadState.EXTENDED);
    }

    public boolean wantsUnmappedReads() {
        return this.desiredReadStates().contains((Object)ActiveRegionReadState.UNMAPPED);
    }

    @Ensures(value={"result.isActiveProb >= 0.0", "result.isActiveProb <= 1.0"})
    public abstract ActivityProfileState isActive(RefMetaDataTracker var1, ReferenceContext var2, AlignmentContext var3);

    public abstract MapType map(ActiveRegion var1, RefMetaDataTracker var2);

    public final GenomeLocSortedSet extendIntervals(GenomeLocSortedSet intervals, GenomeLocParser genomeLocParser, IndexedFastaSequenceFile reference) {
        int activeRegionExtension = this.getClass().getAnnotation(ActiveRegionTraversalParameters.class).extension();
        ArrayList<GenomeLoc> allIntervals = new ArrayList<GenomeLoc>();
        for (GenomeLoc interval : intervals.toList()) {
            int start = Math.max(1, interval.getStart() - activeRegionExtension);
            int stop = Math.min(reference.getSequenceDictionary().getSequence(interval.getContig()).getSequenceLength(), interval.getStop() + activeRegionExtension);
            allIntervals.add(genomeLocParser.createGenomeLoc(interval.getContig(), start, stop));
        }
        return IntervalUtils.sortAndMergeIntervals(genomeLocParser, allIntervals, IntervalMergingRule.ALL);
    }
}

