/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class AverageAltAlleleLength
extends InfoFieldAnnotation
implements ActiveRegionBasedAnnotation,
ExperimentalAnnotation {
    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(this.getKeyNames().get(0), 1, VCFHeaderLineType.Float, "Average Allele Length"));
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("AAL");
    }

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, Map<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap) {
        if (!vc.hasLog10PError()) {
            return null;
        }
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.size() == 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        double length = AverageAltAlleleLength.getMeanAltAlleleLength(vc);
        map.put(this.getKeyNames().get(0), String.format("%.2f", length));
        return map;
    }

    public static double getMeanAltAlleleLength(VariantContext vc) {
        double averageLength = 1.0;
        if (!vc.isSNP() && !vc.isSymbolic()) {
            int averageLengthNum = 0;
            int averageLengthDenom = 0;
            int refLength = vc.getReference().length();
            for (Allele a : vc.getAlternateAlleles()) {
                int alleleSize;
                int numAllele = vc.getCalledChrCount(a);
                if (a.length() == refLength) {
                    byte[] a_bases = a.getBases();
                    byte[] ref_bases = vc.getReference().getBases();
                    int n_mismatch = 0;
                    for (int idx = 0; idx < a_bases.length; ++idx) {
                        if (a_bases[idx] == ref_bases[idx]) continue;
                        ++n_mismatch;
                    }
                    alleleSize = n_mismatch;
                } else {
                    alleleSize = a.isSymbolic() ? 1 : Math.abs(refLength - a.length());
                }
                averageLengthNum += alleleSize * numAllele;
                averageLengthDenom += numAllele;
            }
            averageLength = (double)averageLengthNum / (double)averageLengthDenom;
        }
        return averageLength;
    }
}

