/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.annotator.RankSumTest;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class ClippingRankSumTest
extends RankSumTest {
    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("ClippingRankSum");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("ClippingRankSum", 1, VCFHeaderLineType.Float, "Z-score From Wilcoxon rank sum test of Alt vs. Ref number of hard clipped bases"));
    }

    @Override
    protected void fillQualsFromPileup(List<Allele> allAlleles, int refLoc, ReadBackedPileup pileup, PerReadAlleleLikelihoodMap likelihoodMap, List<Double> refQuals, List<Double> altQuals) {
        if (pileup != null || likelihoodMap == null) {
            return;
        }
        for (Map.Entry<GATKSAMRecord, Map<Allele, Double>> el : likelihoodMap.getLikelihoodReadMap().entrySet()) {
            Allele a = PerReadAlleleLikelihoodMap.getMostLikelyAllele(el.getValue());
            if (a.isNoCall()) continue;
            if (a.isReference()) {
                refQuals.add(Double.valueOf(AlignmentUtils.getNumHardClippedBases(el.getKey())));
                continue;
            }
            if (!allAlleles.contains(a)) continue;
            altQuals.add(Double.valueOf(AlignmentUtils.getNumHardClippedBases(el.getKey())));
        }
    }
}

