/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFFormatHeaderLine;
import org.broadinstitute.variant.vcf.VCFStandardHeaderLines;

public class DepthPerAlleleBySample
extends GenotypeAnnotation
implements StandardAnnotation {
    @Override
    public void annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, AlignmentContext stratifiedContext, VariantContext vc, Genotype g, GenotypeBuilder gb, PerReadAlleleLikelihoodMap alleleLikelihoodMap) {
        if (g == null || !g.isCalled() || stratifiedContext == null && alleleLikelihoodMap == null) {
            return;
        }
        if (alleleLikelihoodMap != null && !alleleLikelihoodMap.isEmpty()) {
            this.annotateWithLikelihoods(alleleLikelihoodMap, vc, gb);
        } else if (stratifiedContext != null && vc.isSNP()) {
            this.annotateWithPileup(stratifiedContext, vc, gb);
        }
    }

    private void annotateWithPileup(AlignmentContext stratifiedContext, VariantContext vc, GenotypeBuilder gb) {
        HashMap<Byte, Integer> alleleCounts = new HashMap<Byte, Integer>();
        for (Allele allele : vc.getAlleles()) {
            alleleCounts.put(allele.getBases()[0], 0);
        }
        ReadBackedPileup pileup = stratifiedContext.getBasePileup();
        for (PileupElement p : pileup) {
            if (!alleleCounts.containsKey(p.getBase())) continue;
            alleleCounts.put(p.getBase(), (Integer)alleleCounts.get(p.getBase()) + p.getRepresentativeCount());
        }
        int[] counts = new int[alleleCounts.size()];
        counts[0] = (Integer)alleleCounts.get(vc.getReference().getBases()[0]);
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            counts[i + 1] = (Integer)alleleCounts.get(vc.getAlternateAllele(i).getBases()[0]);
        }
        gb.AD(counts);
    }

    /*
     * WARNING - void declaration
     */
    private void annotateWithLikelihoods(PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap, VariantContext vc, GenotypeBuilder gb) {
        void var6_10;
        HashMap<Allele, Integer> alleleCounts = new HashMap<Allele, Integer>();
        for (Allele allele : vc.getAlleles()) {
            alleleCounts.put(allele, 0);
        }
        for (Map.Entry entry : perReadAlleleLikelihoodMap.getLikelihoodReadMap().entrySet()) {
            GATKSAMRecord read = (GATKSAMRecord)entry.getKey();
            Allele a = PerReadAlleleLikelihoodMap.getMostLikelyAllele((Map)entry.getValue());
            if (a.isNoCall() || !vc.getAlleles().contains(a)) continue;
            alleleCounts.put(a, (Integer)alleleCounts.get(a) + (read.isReducedRead() ? (int)read.getReducedCount(ReadUtils.getReadCoordinateForReferenceCoordinateUpToEndOfRead(read, vc.getStart(), ReadUtils.ClippingTail.RIGHT_TAIL)) : 1));
        }
        int[] counts = new int[alleleCounts.size()];
        counts[0] = (Integer)alleleCounts.get(vc.getReference());
        boolean bl = false;
        while (var6_10 < vc.getAlternateAlleles().size()) {
            counts[var6_10 + true] = (Integer)alleleCounts.get(vc.getAlternateAllele((int)var6_10));
            ++var6_10;
        }
        gb.AD(counts);
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("AD");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Arrays.asList(VCFStandardHeaderLines.getFormatLine(this.getKeyNames().get(0)));
    }
}

