/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class InbreedingCoeff
extends InfoFieldAnnotation
implements StandardAnnotation,
ActiveRegionBasedAnnotation {
    private static final int MIN_SAMPLES = 10;
    private Set<String> founderIds;

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, Map<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap) {
        if (this.founderIds == null && walker != null) {
            this.founderIds = ((Walker)((Object)walker)).getSampleDB().getFounderIds();
        }
        return this.calculateIC(vc);
    }

    private Map<String, Object> calculateIC(VariantContext vc) {
        GenotypesContext genotypes;
        GenotypesContext genotypesContext = genotypes = this.founderIds == null || this.founderIds.isEmpty() ? vc.getGenotypes() : vc.getGenotypes(this.founderIds);
        if (genotypes == null || genotypes.size() < 10 || !vc.isVariant()) {
            return null;
        }
        int idxAA = 0;
        int idxAB = 1;
        int idxBB = 2;
        if (!vc.isBiallelic()) {
            int[] idxVector = vc.getGLIndecesOfAlternateAllele(vc.getAltAlleleWithHighestAlleleCount());
            idxAA = idxVector[0];
            idxAB = idxVector[1];
            idxBB = idxVector[2];
        }
        double refCount = 0.0;
        double hetCount = 0.0;
        double homCount = 0.0;
        int N = 0;
        for (Genotype g : genotypes) {
            if (g.isNoCall() || !g.hasLikelihoods() || g.getPloidy() != 2) continue;
            ++N;
            double[] normalizedLikelihoods = MathUtils.normalizeFromLog10(g.getLikelihoods().getAsVector());
            refCount += normalizedLikelihoods[idxAA];
            hetCount += normalizedLikelihoods[idxAB];
            homCount += normalizedLikelihoods[idxBB];
        }
        if (N < 10) {
            return null;
        }
        double p = (2.0 * refCount + hetCount) / (2.0 * (refCount + hetCount + homCount));
        double q = 1.0 - p;
        double F = 1.0 - hetCount / (2.0 * p * q * (double)N);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.4f", F));
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("InbreedingCoeff");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("InbreedingCoeff", 1, VCFHeaderLineType.Float, "Inbreeding coefficient as estimated from the genotype likelihoods per-sample when compared against the Hardy-Weinberg expectation"));
    }
}

