/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;
import org.broadinstitute.variant.vcf.VCFStandardHeaderLines;

public class RMSMappingQuality
extends InfoFieldAnnotation
implements StandardAnnotation,
ActiveRegionBasedAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, Map<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap) {
        int[] qualities;
        int totalSize = 0;
        int index = 0;
        if (stratifiedContexts != null) {
            if (stratifiedContexts.size() == 0) {
                return null;
            }
            for (AlignmentContext alignmentContext : stratifiedContexts.values()) {
                totalSize += alignmentContext.size();
            }
            qualities = new int[totalSize];
            for (Map.Entry entry : stratifiedContexts.entrySet()) {
                AlignmentContext context = (AlignmentContext)entry.getValue();
                for (PileupElement p : context.getBasePileup()) {
                    index = RMSMappingQuality.fillMappingQualitiesFromPileupAndUpdateIndex(p.getRead(), index, qualities);
                }
            }
        } else if (perReadAlleleLikelihoodMap != null) {
            if (perReadAlleleLikelihoodMap.size() == 0) {
                return null;
            }
            for (PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap2 : perReadAlleleLikelihoodMap.values()) {
                totalSize += perReadAlleleLikelihoodMap2.size();
            }
            qualities = new int[totalSize];
            for (PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap3 : perReadAlleleLikelihoodMap.values()) {
                for (GATKSAMRecord read : perReadAlleleLikelihoodMap3.getStoredElements()) {
                    index = RMSMappingQuality.fillMappingQualitiesFromPileupAndUpdateIndex(read, index, qualities);
                }
            }
        } else {
            return null;
        }
        double rms = MathUtils.rms(qualities);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.2f", rms));
        return map;
    }

    private static int fillMappingQualitiesFromPileupAndUpdateIndex(GATKSAMRecord read, int inputIdx, int[] qualities) {
        int outputIdx = inputIdx;
        if (read.getMappingQuality() != 255) {
            qualities[outputIdx++] = read.getMappingQuality();
        }
        return outputIdx;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("MQ");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(VCFStandardHeaderLines.getInfoLine(this.getKeyNames().get(0)));
    }
}

