/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.walkers.annotator.RankSumTest;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class ReadPosRankSumTest
extends RankSumTest
implements StandardAnnotation {
    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("ReadPosRankSum");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("ReadPosRankSum", 1, VCFHeaderLineType.Float, "Z-score from Wilcoxon rank sum test of Alt vs. Ref read position bias"));
    }

    @Override
    protected void fillQualsFromPileup(List<Allele> allAlleles, int refLoc, ReadBackedPileup pileup, PerReadAlleleLikelihoodMap alleleLikelihoodMap, List<Double> refQuals, List<Double> altQuals) {
        if (alleleLikelihoodMap == null) {
            for (PileupElement p : pileup) {
                if (!ReadPosRankSumTest.isUsableBase(p) || p.getRead().getCigar() == null) continue;
                int readPos = AlignmentUtils.calcAlignmentByteArrayOffset(p.getRead().getCigar(), p, 0, 0);
                readPos = this.getFinalReadPosition(p.getRead(), readPos);
                if (allAlleles.get(0).equals(Allele.create(p.getBase(), true))) {
                    refQuals.add(Double.valueOf(readPos));
                    continue;
                }
                if (!allAlleles.contains(Allele.create(p.getBase()))) continue;
                altQuals.add(Double.valueOf(readPos));
            }
            return;
        }
        for (Map.Entry<GATKSAMRecord, Map<Allele, Double>> el : alleleLikelihoodMap.getLikelihoodReadMap().entrySet()) {
            int numAlignedBases;
            int offset;
            GATKSAMRecord read;
            Allele a = PerReadAlleleLikelihoodMap.getMostLikelyAllele(el.getValue());
            if (a.isNoCall() || (read = el.getKey()).getSoftStart() + read.getCigar().getReadLength() <= refLoc || (offset = ReadUtils.getReadCoordinateForReferenceCoordinate(read.getSoftStart(), read.getCigar(), refLoc, ReadUtils.ClippingTail.RIGHT_TAIL, true)) == -1 || read.getCigar() == null) continue;
            int readPos = AlignmentUtils.calcAlignmentByteArrayOffset(read.getCigar(), offset, false, 0, 0);
            if (readPos > (numAlignedBases = AlignmentUtils.getNumAlignedBasesCountingSoftClips(read)) / 2) {
                readPos = numAlignedBases - (readPos + 1);
            }
            if (a.isReference()) {
                refQuals.add(Double.valueOf(readPos));
                continue;
            }
            if (!allAlleles.contains(a)) continue;
            altQuals.add(Double.valueOf(readPos));
        }
    }

    int getFinalReadPosition(GATKSAMRecord read, int initialReadPosition) {
        int numAlignedBases = this.getNumAlignedBases(read);
        int readPos = initialReadPosition;
        if (initialReadPosition > numAlignedBases / 2) {
            readPos = numAlignedBases - (initialReadPosition + 1);
        }
        return readPos;
    }

    int getNumClippedBasesAtStart(SAMRecord read) {
        Cigar c = read.getCigar();
        CigarElement first = c.getCigarElement(0);
        int numStartClippedBases = 0;
        if (first.getOperator() == CigarOperator.H) {
            numStartClippedBases = first.getLength();
        }
        byte[] unclippedReadBases = read.getReadBases();
        byte[] unclippedReadQuals = read.getBaseQualities();
        for (int i = numStartClippedBases; i < unclippedReadBases.length && unclippedReadQuals[i] < 20; ++i) {
            ++numStartClippedBases;
        }
        return numStartClippedBases;
    }

    int getNumAlignedBases(SAMRecord read) {
        return read.getReadLength() - this.getNumClippedBasesAtStart(read) - this.getNumClippedBasesAtEnd(read);
    }

    int getNumClippedBasesAtEnd(SAMRecord read) {
        Cigar c = read.getCigar();
        CigarElement last = c.getCigarElement(c.numCigarElements() - 1);
        int numEndClippedBases = 0;
        if (last.getOperator() == CigarOperator.H) {
            numEndClippedBases = last.getLength();
        }
        byte[] unclippedReadBases = read.getReadBases();
        byte[] unclippedReadQuals = read.getBaseQualities();
        for (int i = unclippedReadBases.length - numEndClippedBases - 1; i >= 0 && unclippedReadQuals[i] < 20; --i) {
            ++numEndClippedBases;
        }
        return numEndClippedBases;
    }

    int getOffsetFromClippedReadStart(SAMRecord read, int offset) {
        return offset - this.getNumClippedBasesAtStart(read);
    }
}

