/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.List;
import org.broadinstitute.sting.commandline.Gatherer;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.recalibration.RecalUtils;
import org.broadinstitute.sting.utils.recalibration.RecalibrationReport;

public class BQSRGatherer
extends Gatherer {
    private static final String EMPTY_INPUT_LIST = "list of inputs files is empty";
    private static final String MISSING_OUTPUT_FILE = "missing output file name";

    @Override
    public void gather(List<File> inputs, File output) {
        PrintStream outputFile;
        try {
            outputFile = new PrintStream(output);
        }
        catch (FileNotFoundException e) {
            throw new UserException.MissingArgument("output", MISSING_OUTPUT_FILE);
        }
        RecalibrationReport generalReport = null;
        for (File input : inputs) {
            RecalibrationReport inputReport = new RecalibrationReport(input);
            if (generalReport == null) {
                generalReport = inputReport;
                continue;
            }
            generalReport.combine(inputReport);
        }
        if (generalReport == null) {
            throw new ReviewedStingException(EMPTY_INPUT_LIST);
        }
        generalReport.calculateQuantizedQualities();
        RecalibrationArgumentCollection RAC = generalReport.getRAC();
        if (RAC.RECAL_PDF_FILE != null) {
            RAC.RECAL_TABLE_FILE = output;
            if (RAC.existingRecalibrationReport != null) {
                RecalibrationReport originalReport = new RecalibrationReport(RAC.existingRecalibrationReport);
                RecalUtils.generateRecalibrationPlot(RAC, originalReport.getRecalibrationTables(), generalReport.getRecalibrationTables(), generalReport.getCovariates());
            } else {
                RecalUtils.generateRecalibrationPlot(RAC, generalReport.getRecalibrationTables(), generalReport.getCovariates());
            }
        }
        generalReport.output(outputFile);
    }
}

