/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.samtools.CigarElement;
import net.sf.samtools.SAMFileHeader;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.filters.DuplicateReadFilter;
import org.broadinstitute.sting.gatk.filters.FailsVendorQualityCheckFilter;
import org.broadinstitute.sting.gatk.filters.MappingQualityUnavailableFilter;
import org.broadinstitute.sting.gatk.filters.MappingQualityZeroFilter;
import org.broadinstitute.sting.gatk.filters.NotPrimaryAlignmentFilter;
import org.broadinstitute.sting.gatk.filters.UnmappedReadFilter;
import org.broadinstitute.sting.gatk.iterators.ReadTransformer;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.NanoSchedulable;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.bqsr.ReadRecalibrationInfo;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationEngine;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.clipping.ReadClipper;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.recalibration.QuantizationInfo;
import org.broadinstitute.sting.utils.recalibration.ReadCovariates;
import org.broadinstitute.sting.utils.recalibration.RecalUtils;
import org.broadinstitute.sting.utils.recalibration.RecalibrationReport;
import org.broadinstitute.sting.utils.recalibration.RecalibrationTables;
import org.broadinstitute.sting.utils.recalibration.covariates.Covariate;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

@DocumentedGATKFeature(groupName="Sequence Data Processing Tools", extraDocs={CommandLineGATK.class})
@BAQMode(ApplicationTime=ReadTransformer.ApplicationTime.FORBIDDEN)
@ReadFilters(value={MappingQualityZeroFilter.class, MappingQualityUnavailableFilter.class, UnmappedReadFilter.class, NotPrimaryAlignmentFilter.class, DuplicateReadFilter.class, FailsVendorQualityCheckFilter.class})
@PartitionBy(value=PartitionType.READ)
public class BaseRecalibrator
extends ReadWalker<Long, Long>
implements NanoSchedulable {
    @ArgumentCollection
    private final RecalibrationArgumentCollection RAC = new RecalibrationArgumentCollection();
    @Argument(fullName="lowMemoryMode", shortName="lowMemoryMode", doc="Reduce memory usage in multi-threaded code at the expense of threading efficiency", required=false)
    public boolean lowMemoryMode = false;
    @Advanced
    @Argument(fullName="bqsrBAQGapOpenPenalty", shortName="bqsrBAQGOP", doc="BQSR BAQ gap open penalty (Phred Scaled).  Default value is 40.  30 is perhaps better for whole genome call sets", required=false)
    public double BAQGOP = 40.0;
    private QuantizationInfo quantizationInfo;
    private Covariate[] requestedCovariates;
    private RecalibrationEngine recalibrationEngine;
    private int minimumQToUse;
    private static final String NO_DBSNP_EXCEPTION = "This calculation is critically dependent on being able to skip over known variant sites. Please provide a VCF file containing known sites of genetic variation.";
    private BAQ baq;
    private IndexedFastaSequenceFile referenceReader;
    private static final byte NO_BAQ_UNCERTAINTY = 64;

    @Override
    public void initialize() {
        this.baq = new BAQ(this.BAQGOP);
        if (this.RAC.FORCE_PLATFORM != null) {
            this.RAC.DEFAULT_PLATFORM = this.RAC.FORCE_PLATFORM;
        }
        if (this.RAC.knownSites.isEmpty() && !this.RAC.RUN_WITHOUT_DBSNP) {
            throw new UserException.CommandLineException(NO_DBSNP_EXCEPTION);
        }
        if (this.RAC.LIST_ONLY) {
            RecalUtils.listAvailableCovariates(logger);
            System.exit(0);
        }
        this.RAC.existingRecalibrationReport = this.getToolkit().getArguments().BQSR_RECAL_FILE;
        Pair<ArrayList<Covariate>, ArrayList<Covariate>> covariates = RecalUtils.initializeCovariates(this.RAC);
        ArrayList<Covariate> requiredCovariates = covariates.getFirst();
        ArrayList<Covariate> optionalCovariates = covariates.getSecond();
        this.requestedCovariates = new Covariate[requiredCovariates.size() + optionalCovariates.size()];
        int covariateIndex = 0;
        for (Covariate covariate : requiredCovariates) {
            this.requestedCovariates[covariateIndex++] = covariate;
        }
        for (Covariate covariate : optionalCovariates) {
            this.requestedCovariates[covariateIndex++] = covariate;
        }
        logger.info("The covariates being used here: ");
        for (Covariate cov : this.requestedCovariates) {
            logger.info("\t" + cov.getClass().getSimpleName());
            cov.initialize(this.RAC);
        }
        try {
            this.RAC.RECAL_TABLE = new PrintStream(this.RAC.RECAL_TABLE_FILE);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(this.RAC.RECAL_TABLE_FILE, (Exception)e);
        }
        this.initializeRecalibrationEngine();
        RecalUtils.checkForInvalidRecalBams(this.getToolkit().getSAMFileHeaders(), this.getToolkit().getArguments().ALLOW_BQSR_ON_REDUCED_BAMS);
        this.minimumQToUse = this.getToolkit().getArguments().PRESERVE_QSCORES_LESS_THAN;
        this.referenceReader = this.getToolkit().getReferenceDataSource().getReference();
    }

    private void initializeRecalibrationEngine() {
        int numReadGroups = 0;
        for (SAMFileHeader header : this.getToolkit().getSAMFileHeaders()) {
            numReadGroups += header.getReadGroups().size();
        }
        this.recalibrationEngine = new RecalibrationEngine(this.requestedCovariates, numReadGroups, this.RAC.RECAL_TABLE_UPDATE_LOG, this.lowMemoryMode);
    }

    private boolean isLowQualityBase(GATKSAMRecord read, int offset) {
        return read.getBaseQualities()[offset] < this.minimumQToUse;
    }

    @Override
    public Long map(ReferenceContext ref, GATKSAMRecord originalRead, RefMetaDataTracker metaDataTracker) {
        byte[] baqArray;
        GATKSAMRecord read = ReadClipper.hardClipSoftClippedBases(ReadClipper.hardClipAdaptorSequence(originalRead));
        if (read.isEmpty()) {
            return 0L;
        }
        RecalUtils.parsePlatformForRead(read, this.RAC);
        if (!RecalUtils.isColorSpaceConsistent(this.RAC.SOLID_NOCALL_STRATEGY, read)) {
            return 0L;
        }
        int[] isSNP = BaseRecalibrator.calculateIsSNP(read, ref, originalRead);
        int[] isInsertion = BaseRecalibrator.calculateIsIndel(read, EventType.BASE_INSERTION);
        int[] isDeletion = BaseRecalibrator.calculateIsIndel(read, EventType.BASE_DELETION);
        int nErrors = BaseRecalibrator.nEvents(isSNP, isInsertion, isDeletion);
        byte[] byArray = baqArray = nErrors == 0 ? BaseRecalibrator.flatBAQArray(read) : this.calculateBAQArray(read);
        if (baqArray != null) {
            ReadCovariates covariates = RecalUtils.computeCovariates(read, this.requestedCovariates);
            boolean[] skip = this.calculateSkipArray(read, metaDataTracker);
            double[] snpErrors = BaseRecalibrator.calculateFractionalErrorArray(isSNP, baqArray);
            double[] insertionErrors = BaseRecalibrator.calculateFractionalErrorArray(isInsertion, baqArray);
            double[] deletionErrors = BaseRecalibrator.calculateFractionalErrorArray(isDeletion, baqArray);
            ReadRecalibrationInfo info = new ReadRecalibrationInfo(read, covariates, skip, snpErrors, insertionErrors, deletionErrors);
            this.recalibrationEngine.updateDataForRead(info);
            return 1L;
        }
        return 0L;
    }

    protected static int nEvents(int[] ... hasEvents) {
        int n = 0;
        for (int[] hasEvent : hasEvents) {
            n = (int)((long)n + MathUtils.sum(hasEvent));
        }
        return n;
    }

    protected boolean[] calculateSkipArray(GATKSAMRecord read, RefMetaDataTracker metaDataTracker) {
        byte[] bases = read.getReadBases();
        boolean[] skip = new boolean[bases.length];
        boolean[] knownSites = BaseRecalibrator.calculateKnownSites(read, metaDataTracker.getValues(this.RAC.knownSites));
        for (int iii = 0; iii < bases.length; ++iii) {
            skip[iii] = !BaseUtils.isRegularBase(bases[iii]) || this.isLowQualityBase(read, iii) || knownSites[iii] || this.badSolidOffset(read, iii);
        }
        return skip;
    }

    protected boolean badSolidOffset(GATKSAMRecord read, int offset) {
        return ReadUtils.isSOLiDRead(read) && this.RAC.SOLID_RECAL_MODE != RecalUtils.SOLID_RECAL_MODE.DO_NOTHING && !RecalUtils.isColorSpaceConsistent(read, offset);
    }

    protected static boolean[] calculateKnownSites(GATKSAMRecord read, List<Feature> features) {
        int readLength = read.getReadBases().length;
        boolean[] knownSites = new boolean[readLength];
        Arrays.fill(knownSites, false);
        for (Feature f : features) {
            int featureEndOnRead;
            int featureStartOnRead = ReadUtils.getReadCoordinateForReferenceCoordinate(read.getSoftStart(), read.getCigar(), f.getStart(), ReadUtils.ClippingTail.LEFT_TAIL, true);
            if (featureStartOnRead == -1) {
                featureStartOnRead = 0;
            }
            if ((featureEndOnRead = ReadUtils.getReadCoordinateForReferenceCoordinate(read.getSoftStart(), read.getCigar(), f.getEnd(), ReadUtils.ClippingTail.LEFT_TAIL, true)) == -1) {
                featureEndOnRead = readLength;
            }
            if (featureStartOnRead > readLength) {
                featureStartOnRead = featureEndOnRead = readLength;
            }
            Arrays.fill(knownSites, Math.max(0, featureStartOnRead), Math.min(readLength, featureEndOnRead + 1), true);
        }
        return knownSites;
    }

    protected static int[] calculateIsSNP(GATKSAMRecord read, ReferenceContext ref, GATKSAMRecord originalRead) {
        byte[] readBases = read.getReadBases();
        byte[] refBases = Arrays.copyOfRange(ref.getBases(), read.getAlignmentStart() - originalRead.getAlignmentStart(), ref.getBases().length + read.getAlignmentEnd() - originalRead.getAlignmentEnd());
        int[] snp = new int[readBases.length];
        int readPos = 0;
        int refPos = 0;
        block6: for (CigarElement ce : read.getCigar().getCigarElements()) {
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case M: 
                case EQ: 
                case X: {
                    for (int iii = 0; iii < elementLength; ++iii) {
                        snp[readPos] = BaseUtils.basesAreEqual(readBases[readPos], refBases[refPos]) ? 0 : 1;
                        ++readPos;
                        ++refPos;
                    }
                    continue block6;
                }
                case D: 
                case N: {
                    refPos += elementLength;
                    break;
                }
                case I: 
                case S: {
                    readPos += elementLength;
                    break;
                }
                case H: 
                case P: {
                    break;
                }
                default: {
                    throw new ReviewedStingException("Unsupported cigar operator: " + (Object)((Object)ce.getOperator()));
                }
            }
        }
        return snp;
    }

    protected static int[] calculateIsIndel(GATKSAMRecord read, EventType mode) {
        byte[] readBases = read.getReadBases();
        int[] indel = new int[readBases.length];
        Arrays.fill(indel, 0);
        int readPos = 0;
        block6: for (CigarElement ce : read.getCigar().getCigarElements()) {
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case M: 
                case EQ: 
                case X: 
                case S: {
                    readPos += elementLength;
                    continue block6;
                }
                case D: {
                    int index = read.getReadNegativeStrandFlag() ? readPos : (readPos > 0 ? readPos - 1 : readPos);
                    indel[index] = mode.equals((Object)EventType.BASE_DELETION) ? 1 : 0;
                    continue block6;
                }
                case I: {
                    boolean forwardStrandRead;
                    boolean bl = forwardStrandRead = !read.getReadNegativeStrandFlag();
                    if (forwardStrandRead) {
                        indel[readPos > 0 ? readPos - 1 : readPos] = mode.equals((Object)EventType.BASE_INSERTION) ? 1 : 0;
                    }
                    for (int iii = 0; iii < elementLength; ++iii) {
                        ++readPos;
                    }
                    if (forwardStrandRead) continue block6;
                    indel[readPos < indel.length ? readPos : readPos - 1] = mode.equals((Object)EventType.BASE_INSERTION) ? 1 : 0;
                    continue block6;
                }
                case N: 
                case H: 
                case P: {
                    continue block6;
                }
            }
            throw new ReviewedStingException("Unsupported cigar operator: " + (Object)((Object)ce.getOperator()));
        }
        return indel;
    }

    protected static double[] calculateFractionalErrorArray(int[] errorArray, byte[] baqArray) {
        int iii;
        if (errorArray.length != baqArray.length) {
            throw new ReviewedStingException("Array length mismatch detected. Malformed read?");
        }
        int BLOCK_START_UNSET = -1;
        double[] fractionalErrors = new double[baqArray.length];
        Arrays.fill(fractionalErrors, 0.0);
        boolean inBlock = false;
        int blockStartIndex = -1;
        for (iii = 0; iii < fractionalErrors.length; ++iii) {
            if (baqArray[iii] == 64) {
                if (!inBlock) {
                    fractionalErrors[iii] = errorArray[iii];
                    continue;
                }
                BaseRecalibrator.calculateAndStoreErrorsInBlock(iii, blockStartIndex, errorArray, fractionalErrors);
                inBlock = false;
                blockStartIndex = -1;
                continue;
            }
            inBlock = true;
            if (blockStartIndex != -1) continue;
            blockStartIndex = iii;
        }
        if (inBlock) {
            BaseRecalibrator.calculateAndStoreErrorsInBlock(iii - 1, blockStartIndex, errorArray, fractionalErrors);
        }
        if (fractionalErrors.length != errorArray.length) {
            throw new ReviewedStingException("Output array length mismatch detected. Malformed read?");
        }
        return fractionalErrors;
    }

    private static void calculateAndStoreErrorsInBlock(int iii, int blockStartIndex, int[] errorArray, double[] fractionalErrors) {
        int jjj;
        int totalErrors = 0;
        for (jjj = Math.max(0, blockStartIndex - 1); jjj <= iii; ++jjj) {
            totalErrors += errorArray[jjj];
        }
        for (jjj = Math.max(0, blockStartIndex - 1); jjj <= iii; ++jjj) {
            fractionalErrors[jjj] = (double)totalErrors / (double)(iii - Math.max(0, blockStartIndex - 1) + 1);
        }
    }

    protected static byte[] flatBAQArray(GATKSAMRecord read) {
        byte[] baq = new byte[read.getReadLength()];
        Arrays.fill(baq, (byte)64);
        return baq;
    }

    private byte[] calculateBAQArray(GATKSAMRecord read) {
        this.baq.baqRead(read, this.referenceReader, BAQ.CalculationMode.RECALCULATE, BAQ.QualityMode.ADD_TAG);
        return BAQ.getBAQTag(read);
    }

    @Override
    public Long reduceInit() {
        return 0L;
    }

    @Override
    public Long reduce(Long mapped, Long sum) {
        sum = sum + mapped;
        return sum;
    }

    @Override
    public void onTraversalDone(Long result) {
        this.recalibrationEngine.finalizeData();
        logger.info("Calculating quantized quality scores...");
        this.quantizeQualityScores();
        logger.info("Writing recalibration report...");
        this.generateReport();
        logger.info("...done!");
        if (this.RAC.RECAL_PDF_FILE != null) {
            logger.info("Generating recalibration plots...");
            this.generatePlots();
        }
        logger.info("Processed: " + result + " reads");
    }

    private RecalibrationTables getRecalibrationTable() {
        return this.recalibrationEngine.getFinalRecalibrationTables();
    }

    private void generatePlots() {
        File recalFile = this.getToolkit().getArguments().BQSR_RECAL_FILE;
        if (recalFile != null) {
            RecalibrationReport report = new RecalibrationReport(recalFile);
            RecalUtils.generateRecalibrationPlot(this.RAC, report.getRecalibrationTables(), this.getRecalibrationTable(), this.requestedCovariates);
        } else {
            RecalUtils.generateRecalibrationPlot(this.RAC, this.getRecalibrationTable(), this.requestedCovariates);
        }
    }

    private void quantizeQualityScores() {
        this.quantizationInfo = new QuantizationInfo(this.getRecalibrationTable(), this.RAC.QUANTIZING_LEVELS);
    }

    private void generateReport() {
        RecalUtils.outputRecalibrationReport(this.RAC, this.quantizationInfo, this.getRecalibrationTable(), this.requestedCovariates, this.RAC.SORT_BY_ALL_COLUMNS);
    }
}

