/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.io.File;
import java.io.PrintStream;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.filters.DuplicateReadFilter;
import org.broadinstitute.sting.gatk.filters.FailsVendorQualityCheckFilter;
import org.broadinstitute.sting.gatk.filters.MappingQualityUnavailableFilter;
import org.broadinstitute.sting.gatk.filters.MappingQualityZeroFilter;
import org.broadinstitute.sting.gatk.filters.NotPrimaryAlignmentFilter;
import org.broadinstitute.sting.gatk.filters.UnmappedReadFilter;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.NanoSchedulable;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.recalibration.RecalDatum;

@ReadFilters(value={MappingQualityZeroFilter.class, MappingQualityUnavailableFilter.class, UnmappedReadFilter.class, NotPrimaryAlignmentFilter.class, DuplicateReadFilter.class, FailsVendorQualityCheckFilter.class})
@PartitionBy(value=PartitionType.READ)
public class RecalibrationPerformance
extends RodWalker<Integer, Integer>
implements NanoSchedulable {
    @Output(doc="Write output to this file", required=true)
    public PrintStream out;
    @Input(fullName="recal", shortName="recal", required=false, doc="The input covariates table file")
    public File RECAL_FILE = null;

    @Override
    public void initialize() {
        this.out.println("Cycle\tQrep\tQemp\tIsJoint\tObservations\tErrors");
        GATKReport report = new GATKReport(this.RECAL_FILE);
        GATKReportTable table = report.getTable("RecalTable2");
        for (int row = 0; row < table.getNumRows(); ++row) {
            int nObservations = (int)this.asDouble(table.get(row, "Observations"));
            int nErrors = (int)Math.round(this.asDouble(table.get(row, "Errors")));
            double empiricalQuality = this.asDouble(table.get(row, "EmpiricalQuality"));
            byte QReported = Byte.parseByte((String)table.get(row, "QualityScore"));
            double jointEstimateQemp = RecalDatum.bayesianEstimateOfEmpiricalQuality(nObservations, nErrors, QReported);
            if (!table.get(row, "CovariateName").equals("Cycle") || !table.get(row, "EventType").equals("M") || !table.get(row, "ReadGroup").equals("20FUKAAXX100202.6") || QReported != 6 && QReported != 10 && QReported != 20 && QReported != 30 && QReported != 45) continue;
            this.out.println(String.format("%s\t%d\t%d\t%s\t%d\t%d", table.get(row, "CovariateValue"), QReported, Math.round(empiricalQuality), "False", nObservations, nErrors));
            this.out.println(String.format("%s\t%d\t%d\t%s\t%d\t%d", table.get(row, "CovariateValue"), QReported, (int)jointEstimateQemp, "True", nObservations, nErrors));
        }
    }

    @Override
    public boolean isDone() {
        return true;
    }

    private double asDouble(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        throw new ReviewedStingException("Object " + o + " is expected to be either a double, long or integer but its not either: " + o.getClass());
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        return 0;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer counter, Integer sum) {
        return 0;
    }

    @Override
    public void onTraversalDone(Integer sum) {
    }
}

