/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.compression.reducereads;

import org.broadinstitute.sting.gatk.walkers.compression.reducereads.BaseCounts;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.BaseIndex;

public class BaseAndQualsCounts
extends BaseCounts {
    private final long[] sumInsertionQuals = new long[BaseIndex.values().length];
    private final long[] sumDeletionQuals = new long[BaseIndex.values().length];

    public void incr(byte base, byte baseQual, byte insQual, byte delQual) {
        BaseIndex i = BaseIndex.byteToBase(base);
        super.incr(i, baseQual);
        int n = i.index;
        this.sumInsertionQuals[n] = this.sumInsertionQuals[n] + (long)insQual;
        int n2 = i.index;
        this.sumDeletionQuals[n2] = this.sumDeletionQuals[n2] + (long)delQual;
    }

    public void decr(byte base, byte baseQual, byte insQual, byte delQual) {
        BaseIndex i = BaseIndex.byteToBase(base);
        super.decr(i, baseQual);
        int n = i.index;
        this.sumInsertionQuals[n] = this.sumInsertionQuals[n] - (long)insQual;
        int n2 = i.index;
        this.sumDeletionQuals[n2] = this.sumDeletionQuals[n2] - (long)delQual;
    }

    public byte averageInsertionQualsOfBase(BaseIndex base) {
        return this.getGenericAverageQualOfBase(base, this.sumInsertionQuals);
    }

    public byte averageDeletionQualsOfBase(BaseIndex base) {
        return this.getGenericAverageQualOfBase(base, this.sumDeletionQuals);
    }

    private byte getGenericAverageQualOfBase(BaseIndex base, long[] sumQuals) {
        return (byte)(sumQuals[base.index] / (long)this.countOfBase(base));
    }
}

