/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.compression.reducereads;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.BaseIndex;

public class BaseCounts {
    public static final BaseIndex MAX_BASE_INDEX_WITH_NO_COUNTS = BaseIndex.N;
    public static final byte MAX_BASE_WITH_NO_COUNTS = MAX_BASE_INDEX_WITH_NO_COUNTS.getByte();
    private final int[] counts = new int[BaseIndex.values().length];
    private final long[] sumQuals = new long[BaseIndex.values().length];
    private int totalCount = 0;

    public static BaseCounts createWithCounts(int[] countsACGT) {
        BaseCounts baseCounts = new BaseCounts();
        baseCounts.counts[BaseIndex.A.index] = countsACGT[0];
        baseCounts.counts[BaseIndex.C.index] = countsACGT[1];
        baseCounts.counts[BaseIndex.G.index] = countsACGT[2];
        baseCounts.counts[BaseIndex.T.index] = countsACGT[3];
        baseCounts.totalCount = countsACGT[0] + countsACGT[1] + countsACGT[2] + countsACGT[3];
        return baseCounts;
    }

    @Requires(value={"other != null"})
    public void add(BaseCounts other) {
        for (BaseIndex i : BaseIndex.values()) {
            int otherCount = other.counts[i.index];
            int n = i.index;
            this.counts[n] = this.counts[n] + otherCount;
            this.totalCount += otherCount;
        }
    }

    @Requires(value={"other != null"})
    public void sub(BaseCounts other) {
        for (BaseIndex i : BaseIndex.values()) {
            int otherCount = other.counts[i.index];
            int n = i.index;
            this.counts[n] = this.counts[n] - otherCount;
            this.totalCount -= otherCount;
        }
    }

    @Ensures(value={"totalCount() == old(totalCount()) || totalCount() == old(totalCount()) + 1"})
    public void incr(byte base) {
        BaseIndex i = BaseIndex.byteToBase(base);
        int n = i.index;
        this.counts[n] = this.counts[n] + 1;
        ++this.totalCount;
    }

    @Ensures(value={"totalCount() == old(totalCount()) || totalCount() == old(totalCount()) + 1"})
    public void incr(BaseIndex base, byte qual) {
        int n = base.index;
        this.counts[n] = this.counts[n] + 1;
        ++this.totalCount;
        int n2 = base.index;
        this.sumQuals[n2] = this.sumQuals[n2] + (long)qual;
    }

    @Ensures(value={"totalCount() == old(totalCount()) || totalCount() == old(totalCount()) - 1"})
    public void decr(byte base) {
        BaseIndex i = BaseIndex.byteToBase(base);
        int n = i.index;
        this.counts[n] = this.counts[n] - 1;
        --this.totalCount;
    }

    @Ensures(value={"totalCount() == old(totalCount()) || totalCount() == old(totalCount()) - 1"})
    public void decr(BaseIndex base, byte qual) {
        int n = base.index;
        this.counts[n] = this.counts[n] - 1;
        --this.totalCount;
        int n2 = base.index;
        this.sumQuals[n2] = this.sumQuals[n2] - (long)qual;
    }

    @Ensures(value={"result >= 0"})
    public long getSumQuals(byte base) {
        return this.getSumQuals(BaseIndex.byteToBase(base));
    }

    @Ensures(value={"result >= 0"})
    public long getSumQuals(BaseIndex base) {
        return this.sumQuals[base.index];
    }

    @Ensures(value={"result >= 0"})
    public byte averageQuals(byte base) {
        return this.averageQuals(BaseIndex.byteToBase(base));
    }

    @Ensures(value={"result >= 0"})
    public byte averageQuals(BaseIndex base) {
        return (byte)(this.getSumQuals(base) / (long)this.countOfBase(base));
    }

    @Ensures(value={"result >= 0"})
    public int countOfBase(byte base) {
        return this.countOfBase(BaseIndex.byteToBase(base));
    }

    @Ensures(value={"result >= 0"})
    public int countOfBase(BaseIndex base) {
        return this.counts[base.index];
    }

    @Ensures(value={"result >= 0"})
    public long sumQualsOfBase(BaseIndex base) {
        return this.sumQuals[base.index];
    }

    @Ensures(value={"result >= 0"})
    public byte averageQualsOfBase(BaseIndex base) {
        return (byte)(this.sumQualsOfBase(base) / (long)this.countOfBase(base));
    }

    @Ensures(value={"result >= 0"})
    public int totalCount() {
        return this.totalCount;
    }

    @Ensures(value={"result >=0.0", "result<= 1.0"})
    public double baseCountProportion(byte base) {
        return this.baseCountProportion(BaseIndex.byteToBase(base));
    }

    @Ensures(value={"result >=0.0", "result<= 1.0"})
    public double baseCountProportion(BaseIndex baseIndex) {
        return this.totalCount == 0 ? 0.0 : (double)this.counts[baseIndex.index] / (double)this.totalCount;
    }

    @Ensures(value={"result != null"})
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (BaseIndex i : BaseIndex.values()) {
            b.append(i.toString()).append("=").append(this.counts[i.index]).append(",");
        }
        return b.toString();
    }

    public byte baseWithMostCounts() {
        return this.baseIndexWithMostCounts().getByte();
    }

    @Ensures(value={"result != null"})
    public BaseIndex baseIndexWithMostCounts() {
        BaseIndex maxI = MAX_BASE_INDEX_WITH_NO_COUNTS;
        for (BaseIndex i : BaseIndex.values()) {
            if (this.counts[i.index] <= this.counts[maxI.index]) continue;
            maxI = i;
        }
        return maxI;
    }

    @Ensures(value={"result != null"})
    public BaseIndex baseIndexWithMostCountsWithoutIndels() {
        BaseIndex maxI = MAX_BASE_INDEX_WITH_NO_COUNTS;
        for (BaseIndex i : BaseIndex.values()) {
            if (!i.isNucleotide() || this.counts[i.index] <= this.counts[maxI.index]) continue;
            maxI = i;
        }
        return maxI;
    }

    public byte baseWithMostProbability() {
        return this.baseIndexWithMostProbability().getByte();
    }

    @Ensures(value={"result != null"})
    public BaseIndex baseIndexWithMostProbability() {
        BaseIndex maxI = MAX_BASE_INDEX_WITH_NO_COUNTS;
        for (BaseIndex i : BaseIndex.values()) {
            if (this.sumQuals[i.index] <= this.sumQuals[maxI.index]) continue;
            maxI = i;
        }
        return this.sumQuals[maxI.index] > 0L ? maxI : this.baseIndexWithMostCounts();
    }

    @Ensures(value={"result != null"})
    public BaseIndex baseIndexWithMostProbabilityWithoutIndels() {
        BaseIndex maxI = MAX_BASE_INDEX_WITH_NO_COUNTS;
        for (BaseIndex i : BaseIndex.values()) {
            if (!i.isNucleotide() || this.sumQuals[i.index] <= this.sumQuals[maxI.index]) continue;
            maxI = i;
        }
        return this.sumQuals[maxI.index] > 0L ? maxI : this.baseIndexWithMostCountsWithoutIndels();
    }

    @Ensures(value={"result >=0"})
    public int totalCountWithoutIndels() {
        return this.totalCount - this.counts[BaseIndex.D.index] - this.counts[BaseIndex.I.index];
    }

    @Requires(value={"base.isNucleotide()"})
    @Ensures(value={"result >=0.0", "result<= 1.0"})
    public double baseCountProportionWithoutIndels(BaseIndex base) {
        int total = this.totalCountWithoutIndels();
        return total == 0 ? 0.0 : (double)this.counts[base.index] / (double)total;
    }

    public int[] countsArray() {
        return (int[])this.counts.clone();
    }
}

