/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.compression.reducereads;

import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.filters.DuplicateReadFilter;
import org.broadinstitute.sting.gatk.filters.FailsVendorQualityCheckFilter;
import org.broadinstitute.sting.gatk.filters.NotPrimaryAlignmentFilter;
import org.broadinstitute.sting.gatk.filters.UnmappedReadFilter;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.BaseCounts;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;

@DocumentedGATKFeature(groupName="Diagnostics and Quality Control Tools", extraDocs={CommandLineGATK.class})
@ReadFilters(value={UnmappedReadFilter.class, NotPrimaryAlignmentFilter.class, DuplicateReadFilter.class, FailsVendorQualityCheckFilter.class})
public class CompareBAM
extends LocusWalker<Map<TestName, Boolean>, TestResults> {
    @Argument(required=true, shortName="rr", fullName="reduced_readgroup", doc="The read group ID corresponding to the compressed BAM being tested")
    public String reducedReadGroupID;
    @Argument(required=false, shortName="teq", fullName="test_equal_bases", doc="Test if the bases marked as '=' are indeed ref bases.")
    public boolean TEST_EQUAL_BASES = false;
    @Argument(required=false, shortName="tbc", fullName="test_base_counts", doc="Test if the base counts tag in consensus reads are accurate.")
    public boolean TEST_BASE_COUNTS = false;
    @Argument(required=false, shortName="mbq", fullName="min_base_qual", doc="Minimum base quality to be considered.")
    public int MIN_BASE_QUAL = 20;
    @Argument(required=false, shortName="mmq", fullName="min_mapping_qual", doc="Minimum mapping quality to be considered.")
    public int MIN_MAPPING_QUAL = 20;

    @Override
    public Map<TestName, Boolean> map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        HashMap<TestName, Boolean> result = new HashMap<TestName, Boolean>();
        if (this.TEST_EQUAL_BASES) {
            result.put(TestName.EQUAL_BASES, this.testEqualBases(ref, context));
        }
        if (this.TEST_BASE_COUNTS) {
            result.put(TestName.BASE_COUNTS, this.testBaseCounts(ref, context));
        }
        return result;
    }

    @Override
    public TestResults reduceInit() {
        TestResults sum = new TestResults();
        if (this.TEST_EQUAL_BASES) {
            sum.createTest(TestName.EQUAL_BASES);
        }
        if (this.TEST_BASE_COUNTS) {
            sum.createTest(TestName.BASE_COUNTS);
        }
        return sum;
    }

    @Override
    public TestResults reduce(Map<TestName, Boolean> mapResult, TestResults sum) {
        for (TestName test : mapResult.keySet()) {
            if (mapResult.get((Object)test).booleanValue()) {
                sum.reportSuccess(test);
                continue;
            }
            sum.reportFailed(test);
        }
        return sum;
    }

    @Override
    public void onTraversalDone(TestResults finalResults) {
        finalResults.report();
    }

    private boolean testEqualBases(ReferenceContext ref, AlignmentContext context) {
        return true;
    }

    private boolean testBaseCounts(ReferenceContext ref, AlignmentContext context) {
        return true;
    }

    private BaseCounts getFilteredBaseCounts(AlignmentContext context) {
        return this.getBaseCounts(context, this.MIN_BASE_QUAL, this.MIN_MAPPING_QUAL);
    }

    private BaseCounts getFullBaseCounts(AlignmentContext context) {
        return this.getBaseCounts(context, 3, 0);
    }

    private BaseCounts getBaseCounts(AlignmentContext context, int mbq, int mmq) {
        BaseCounts fullBaseCounts = new BaseCounts();
        for (String rg : context.getBasePileup().getReadGroups()) {
            if (rg.equals(this.reducedReadGroupID)) continue;
            BaseCounts b = BaseCounts.createWithCounts(context.getBasePileup().getPileupForReadGroup(rg).getBaseAndMappingFilteredPileup(mbq, mmq).getBaseCounts());
            fullBaseCounts.add(b);
        }
        return fullBaseCounts;
    }

    private class TestOutcome {
        private long passed;
        private long failed;

        private TestOutcome() {
        }

        public long getPassed() {
            return this.passed;
        }

        public void incPassed() {
            ++this.passed;
        }

        public long getFailed() {
            return this.failed;
        }

        public void incFailed() {
            ++this.failed;
        }
    }

    public class TestResults {
        private Map<TestName, TestOutcome> testStats = new HashMap<TestName, TestOutcome>();

        public void createTest(TestName test) {
            this.testStats.put(test, new TestOutcome());
        }

        public void reportSuccess(TestName test) {
            if (!this.testStats.containsKey((Object)test)) {
                throw new ReviewedStingException("No such test: " + (Object)((Object)test));
            }
            this.testStats.get((Object)test).incPassed();
        }

        public void reportFailed(TestName test) {
            if (!this.testStats.containsKey((Object)test)) {
                throw new ReviewedStingException("No such test: " + (Object)((Object)test));
            }
            this.testStats.get((Object)test).incFailed();
        }

        public void report() {
            System.out.println();
            System.out.println(String.format("%20s\tPASS\tFAIL", ""));
            for (TestName test : this.testStats.keySet()) {
                System.out.println(String.format("%20s\t%d\t%d", test.getTestName(), this.testStats.get((Object)test).getPassed(), this.testStats.get((Object)test).getFailed()));
            }
            System.out.println();
        }
    }

    public static enum TestName {
        EQUAL_BASES("testEqualBases"),
        BASE_COUNTS("testBaseCounts");

        private String testName;

        private TestName(String testName) {
            this.testName = testName;
        }

        public String getTestName() {
            return this.testName;
        }
    }
}

