/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.compression.reducereads;

import java.util.LinkedList;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.BaseAndQualsCounts;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.BaseIndex;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class HeaderElement {
    private BaseAndQualsCounts consensusBaseCounts;
    private BaseAndQualsCounts filteredBaseCounts;
    private int insertionsToTheRight;
    private int nSoftClippedBases;
    private int location;
    private LinkedList<Integer> mappingQuality;

    public int getLocation() {
        return this.location;
    }

    public BaseAndQualsCounts getFilteredBaseCounts() {
        return this.filteredBaseCounts;
    }

    public BaseAndQualsCounts getConsensusBaseCounts() {
        return this.consensusBaseCounts;
    }

    public HeaderElement(int location) {
        this(new BaseAndQualsCounts(), new BaseAndQualsCounts(), 0, 0, location, new LinkedList<Integer>());
    }

    public HeaderElement(int location, int insertionsToTheRight) {
        this(new BaseAndQualsCounts(), new BaseAndQualsCounts(), insertionsToTheRight, 0, location, new LinkedList<Integer>());
    }

    public HeaderElement(BaseAndQualsCounts consensusBaseCounts, BaseAndQualsCounts filteredBaseCounts, int insertionsToTheRight, int nSoftClippedBases, int location, LinkedList<Integer> mappingQuality) {
        this.consensusBaseCounts = consensusBaseCounts;
        this.filteredBaseCounts = filteredBaseCounts;
        this.insertionsToTheRight = insertionsToTheRight;
        this.nSoftClippedBases = nSoftClippedBases;
        this.location = location;
        this.mappingQuality = mappingQuality;
    }

    public boolean isVariant(double minVariantProportion, double minIndelProportion) {
        return this.hasConsensusData() && (this.isVariantFromInsertions(minIndelProportion) || this.isVariantFromMismatches(minVariantProportion) || this.isVariantFromDeletions(minIndelProportion) || this.isVariantFromSoftClips());
    }

    public void addBase(byte base, byte baseQual, byte insQual, byte delQual, int baseMappingQuality, int minBaseQual, int minMappingQual, boolean isSoftClipped) {
        if (this.basePassesFilters(baseQual, minBaseQual, baseMappingQuality, minMappingQual)) {
            this.consensusBaseCounts.incr(base, baseQual, insQual, delQual);
        } else {
            this.filteredBaseCounts.incr(base, baseQual, insQual, delQual);
        }
        this.mappingQuality.add(baseMappingQuality);
        this.nSoftClippedBases += isSoftClipped ? 1 : 0;
    }

    public void removeBase(byte base, byte baseQual, byte insQual, byte delQual, int baseMappingQuality, int minBaseQual, int minMappingQual, boolean isSoftClipped) {
        if (this.basePassesFilters(baseQual, minBaseQual, baseMappingQuality, minMappingQual)) {
            this.consensusBaseCounts.decr(base, baseQual, insQual, delQual);
        } else {
            this.filteredBaseCounts.decr(base, baseQual, insQual, delQual);
        }
        this.mappingQuality.remove((Object)baseMappingQuality);
        this.nSoftClippedBases -= isSoftClipped ? 1 : 0;
    }

    public void addInsertionToTheRight() {
        ++this.insertionsToTheRight;
    }

    public boolean hasConsensusData() {
        return this.consensusBaseCounts.totalCount() > 0;
    }

    public boolean hasFilteredData() {
        return this.filteredBaseCounts.totalCount() > 0;
    }

    public boolean isEmpty() {
        return !this.hasFilteredData() && !this.hasConsensusData();
    }

    public double getRMS() {
        return MathUtils.rms(this.mappingQuality);
    }

    public void removeInsertionToTheRight() {
        --this.insertionsToTheRight;
        if (this.insertionsToTheRight < 0) {
            throw new ReviewedStingException("Removed too many insertions, header is now negative!");
        }
    }

    public boolean hasInsertionToTheRight() {
        return this.insertionsToTheRight > 0;
    }

    public int numInsertionsToTheRight() {
        return this.insertionsToTheRight;
    }

    private boolean isVariantFromInsertions(double minIndelProportion) {
        int numberOfBases = this.consensusBaseCounts.totalCount();
        if (numberOfBases == 0) {
            return this.insertionsToTheRight > 0;
        }
        return (double)this.insertionsToTheRight / (double)numberOfBases > minIndelProportion;
    }

    private boolean isVariantFromDeletions(double minIndelProportion) {
        return this.consensusBaseCounts.baseIndexWithMostCounts() == BaseIndex.D || this.consensusBaseCounts.baseCountProportion(BaseIndex.D) > minIndelProportion;
    }

    protected boolean isVariantFromMismatches(double minVariantProportion) {
        BaseIndex mostCommon = this.consensusBaseCounts.baseIndexWithMostProbabilityWithoutIndels();
        double mostCommonProportion = this.consensusBaseCounts.baseCountProportionWithoutIndels(mostCommon);
        return mostCommonProportion != 0.0 && mostCommonProportion < 1.0 - minVariantProportion;
    }

    protected boolean isVariantFromSoftClips() {
        return this.nSoftClippedBases > 0 && this.nSoftClippedBases >= this.consensusBaseCounts.totalCount() - this.nSoftClippedBases;
    }

    protected boolean basePassesFilters(byte baseQual, int minBaseQual, int baseMappingQuality, int minMappingQual) {
        return baseQual >= minBaseQual && baseMappingQuality >= minMappingQual;
    }

    public int getNumberOfAlleles(double minVariantProportion) {
        int totalBaseCount = this.consensusBaseCounts.totalCount();
        if (totalBaseCount == 0) {
            return 0;
        }
        int minBaseCountForRelevantAlleles = (int)(minVariantProportion * (double)totalBaseCount);
        int nAlleles = 0;
        for (BaseIndex base : BaseIndex.values()) {
            int baseCount = this.consensusBaseCounts.countOfBase(base);
            if (baseCount == 0 || baseCount < minBaseCountForRelevantAlleles) continue;
            ++nAlleles;
        }
        return nAlleles;
    }
}

