/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.compression.reducereads;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.CompressionStash;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.ReduceReads;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.SingleSampleCompressor;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.AlignmentStartWithNoTiesComparator;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class MultiSampleCompressor {
    protected static final Logger logger = Logger.getLogger(MultiSampleCompressor.class);
    protected Map<String, SingleSampleCompressor> compressorsPerSample = new HashMap<String, SingleSampleCompressor>();

    public MultiSampleCompressor(SAMFileHeader header, int contextSize, int downsampleCoverage, int minMappingQuality, double minAltProportionToTriggerVariant, double minIndelProportionToTriggerVariant, int minBaseQual, ReduceReads.DownsampleStrategy downsampleStrategy, boolean allowPolyploidReduction) {
        for (String name : SampleUtils.getSAMFileSamples(header)) {
            this.compressorsPerSample.put(name, new SingleSampleCompressor(contextSize, downsampleCoverage, minMappingQuality, minAltProportionToTriggerVariant, minIndelProportionToTriggerVariant, minBaseQual, downsampleStrategy, allowPolyploidReduction));
        }
    }

    public Set<GATKSAMRecord> addAlignment(GATKSAMRecord read) {
        String sampleName = read.getReadGroup().getSample();
        SingleSampleCompressor compressor = this.compressorsPerSample.get(sampleName);
        if (compressor == null) {
            throw new ReviewedStingException("No compressor for sample " + sampleName);
        }
        Pair<Set<GATKSAMRecord>, CompressionStash> readsAndStash = compressor.addAlignment(read);
        Set<GATKSAMRecord> reads = readsAndStash.getFirst();
        CompressionStash regions = readsAndStash.getSecond();
        reads.addAll(this.closeVariantRegionsInAllSamples(regions));
        return reads;
    }

    public Set<GATKSAMRecord> close() {
        Set<SAMRecord> reads = new TreeSet<SAMRecord>(new AlignmentStartWithNoTiesComparator());
        for (SingleSampleCompressor sample : this.compressorsPerSample.values()) {
            Pair<Set<GATKSAMRecord>, CompressionStash> readsAndStash = sample.close();
            reads = readsAndStash.getFirst();
        }
        return reads;
    }

    private Set<GATKSAMRecord> closeVariantRegionsInAllSamples(CompressionStash regions) {
        TreeSet<SAMRecord> reads = new TreeSet<SAMRecord>(new AlignmentStartWithNoTiesComparator());
        if (!regions.isEmpty()) {
            for (SingleSampleCompressor sample : this.compressorsPerSample.values()) {
                reads.addAll(sample.closeVariantRegions(regions));
            }
        }
        return reads;
    }
}

