/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.compression.reducereads;

import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.MultiSampleCompressor;
import org.broadinstitute.sting.utils.sam.AlignmentStartWithNoTiesComparator;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

public class ReduceReadsStash {
    protected MultiSampleCompressor compressor;
    SortedSet<GATKSAMRecord> outOfOrderReads;

    public ReduceReadsStash(MultiSampleCompressor compressor) {
        this.compressor = compressor;
        this.outOfOrderReads = new TreeSet<SAMRecord>(new AlignmentStartWithNoTiesComparator());
    }

    public List<GATKSAMRecord> getAllReadsBefore(GATKSAMRecord read) {
        LinkedList<GATKSAMRecord> result = new LinkedList<GATKSAMRecord>();
        GATKSAMRecord newHead = null;
        for (GATKSAMRecord stashedRead : this.outOfOrderReads) {
            if (ReadUtils.compareSAMRecords(stashedRead, read) <= 0) {
                result.add(stashedRead);
                continue;
            }
            newHead = stashedRead;
            break;
        }
        if (result.size() > 0) {
            if (result.size() == this.outOfOrderReads.size()) {
                this.outOfOrderReads.clear();
            } else {
                this.outOfOrderReads = new TreeSet<GATKSAMRecord>(this.outOfOrderReads.tailSet(newHead));
            }
        }
        return result;
    }

    public Iterable<GATKSAMRecord> compress(GATKSAMRecord read) {
        return this.compressor.addAlignment(read);
    }

    public void add(GATKSAMRecord read) {
        this.outOfOrderReads.add(read);
    }

    public Iterable<GATKSAMRecord> close() {
        LinkedList<GATKSAMRecord> result = new LinkedList<GATKSAMRecord>();
        for (GATKSAMRecord read : this.outOfOrderReads) {
            for (GATKSAMRecord compressedRead : this.compressor.addAlignment(read)) {
                result.add(compressedRead);
            }
        }
        for (GATKSAMRecord read : this.compressor.close()) {
            result.add(read);
        }
        return result;
    }

    public void print() {
        int i = 1;
        System.out.println("Stash Contents:");
        for (GATKSAMRecord read : this.outOfOrderReads) {
            System.out.println(String.format("%3d: %s %d %d", i++, read.getCigarString(), read.getAlignmentStart(), read.getAlignmentEnd()));
        }
        System.out.println();
    }
}

