/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.compression.reducereads;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.CompressionStash;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.ReduceReads;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.SlidingWindow;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.sam.AlignmentStartWithNoTiesComparator;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class SingleSampleCompressor {
    private final int contextSize;
    private final int downsampleCoverage;
    private final int minMappingQuality;
    private final double minAltProportionToTriggerVariant;
    private final double minIndelProportionToTriggerVariant;
    private final int minBaseQual;
    private final ReduceReads.DownsampleStrategy downsampleStrategy;
    private final boolean allowPolyploidReduction;
    private SlidingWindow slidingWindow;
    private int slidingWindowCounter;
    public static Pair<Set<GATKSAMRecord>, CompressionStash> emptyPair = new Pair(new TreeSet(), new CompressionStash());

    public SingleSampleCompressor(int contextSize, int downsampleCoverage, int minMappingQuality, double minAltProportionToTriggerVariant, double minIndelProportionToTriggerVariant, int minBaseQual, ReduceReads.DownsampleStrategy downsampleStrategy, boolean allowPolyploidReduction) {
        this.contextSize = contextSize;
        this.downsampleCoverage = downsampleCoverage;
        this.minMappingQuality = minMappingQuality;
        this.slidingWindowCounter = 0;
        this.minAltProportionToTriggerVariant = minAltProportionToTriggerVariant;
        this.minIndelProportionToTriggerVariant = minIndelProportionToTriggerVariant;
        this.minBaseQual = minBaseQual;
        this.downsampleStrategy = downsampleStrategy;
        this.allowPolyploidReduction = allowPolyploidReduction;
    }

    public Pair<Set<GATKSAMRecord>, CompressionStash> addAlignment(GATKSAMRecord read) {
        Set<SAMRecord> reads = new TreeSet<SAMRecord>(new AlignmentStartWithNoTiesComparator());
        CompressionStash stash = new CompressionStash();
        int readOriginalStart = read.getUnclippedStart();
        if (this.slidingWindow != null && (read.getReferenceIndex().intValue() != this.slidingWindow.getContigIndex() || readOriginalStart - this.contextSize > this.slidingWindow.getStopLocation())) {
            Pair<Set<GATKSAMRecord>, CompressionStash> readsAndStash = this.slidingWindow.close();
            reads = readsAndStash.getFirst();
            stash = readsAndStash.getSecond();
            this.slidingWindow = null;
        }
        if (this.slidingWindow == null) {
            this.slidingWindow = new SlidingWindow(read.getReferenceName(), read.getReferenceIndex(), this.contextSize, read.getHeader(), read.getReadGroup(), this.slidingWindowCounter, this.minAltProportionToTriggerVariant, this.minIndelProportionToTriggerVariant, this.minBaseQual, this.minMappingQuality, this.downsampleCoverage, this.downsampleStrategy, read.hasBaseIndelQualities(), this.allowPolyploidReduction);
            ++this.slidingWindowCounter;
        }
        stash.addAll(this.slidingWindow.addRead(read));
        return new Pair<Set<GATKSAMRecord>, CompressionStash>(reads, stash);
    }

    public Pair<Set<GATKSAMRecord>, CompressionStash> close() {
        return this.slidingWindow != null ? this.slidingWindow.close() : emptyPair;
    }

    public Set<GATKSAMRecord> closeVariantRegions(CompressionStash regions) {
        return this.slidingWindow == null ? Collections.emptySet() : this.slidingWindow.closeVariantRegions(regions);
    }
}

