/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.compression.reducereads;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.downsampling.ReservoirDownsampler;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.BaseAndQualsCounts;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.BaseIndex;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.CompressionStash;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.FinishedGenomeLoc;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.HeaderElement;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.ReduceReads;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.SyntheticRead;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.sam.AlignmentStartWithNoTiesComparator;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

public class SlidingWindow {
    private final TreeSet<GATKSAMRecord> readsInWindow;
    private final LinkedList<HeaderElement> windowHeader;
    protected int contextSize;
    protected String contig;
    protected int contigIndex;
    protected SAMFileHeader samHeader;
    protected GATKSAMReadGroupRecord readGroupAttribute;
    protected int downsampleCoverage;
    protected SyntheticRead runningConsensus;
    protected int consensusCounter;
    protected String consensusReadName;
    protected SyntheticRead filteredDataConsensus;
    protected int filteredDataConsensusCounter;
    protected String filteredDataReadName;
    protected double MIN_ALT_BASE_PROPORTION_TO_TRIGGER_VARIANT;
    protected double MIN_INDEL_BASE_PROPORTION_TO_TRIGGER_VARIANT;
    protected int MIN_BASE_QUAL_TO_COUNT;
    protected int MIN_MAPPING_QUALITY;
    protected ReduceReads.DownsampleStrategy downsampleStrategy;
    private boolean hasIndelQualities;
    private boolean allowPolyploidReductionInGeneral;
    private static CompressionStash emptyRegions = new CompressionStash();
    private final MarkedSites markedSites = new MarkedSites();

    public int getStopLocation() {
        return this.getStopLocation(this.windowHeader);
    }

    private int getStopLocation(LinkedList<HeaderElement> header) {
        return this.getStartLocation(header) + header.size() - 1;
    }

    public String getContig() {
        return this.contig;
    }

    public int getContigIndex() {
        return this.contigIndex;
    }

    public int getStartLocation(LinkedList<HeaderElement> header) {
        return header.isEmpty() ? -1 : header.peek().getLocation();
    }

    protected SlidingWindow(String contig, int contigIndex, int startLocation) {
        this.contig = contig;
        this.contigIndex = contigIndex;
        this.contextSize = 10;
        this.windowHeader = new LinkedList();
        this.windowHeader.addFirst(new HeaderElement(startLocation));
        this.readsInWindow = new TreeSet();
    }

    public SlidingWindow(String contig, int contigIndex, int contextSize, SAMFileHeader samHeader, GATKSAMReadGroupRecord readGroupAttribute, int windowNumber, double minAltProportionToTriggerVariant, double minIndelProportionToTriggerVariant, int minBaseQual, int minMappingQuality, int downsampleCoverage, ReduceReads.DownsampleStrategy downsampleStrategy, boolean hasIndelQualities, boolean allowPolyploidReduction) {
        this.contextSize = contextSize;
        this.downsampleCoverage = downsampleCoverage;
        this.MIN_ALT_BASE_PROPORTION_TO_TRIGGER_VARIANT = minAltProportionToTriggerVariant;
        this.MIN_INDEL_BASE_PROPORTION_TO_TRIGGER_VARIANT = minIndelProportionToTriggerVariant;
        this.MIN_BASE_QUAL_TO_COUNT = minBaseQual;
        this.MIN_MAPPING_QUALITY = minMappingQuality;
        this.windowHeader = new LinkedList();
        this.readsInWindow = new TreeSet<GATKSAMRecord>(new Comparator<GATKSAMRecord>(){

            @Override
            public int compare(GATKSAMRecord read1, GATKSAMRecord read2) {
                int difference = read1.getSoftEnd() - read2.getSoftEnd();
                return difference != 0 ? difference : read1.getReadName().compareTo(read2.getReadName());
            }
        });
        this.contig = contig;
        this.contigIndex = contigIndex;
        this.samHeader = samHeader;
        this.readGroupAttribute = readGroupAttribute;
        this.consensusCounter = 0;
        this.consensusReadName = "Consensus-" + windowNumber + "-";
        this.filteredDataConsensusCounter = 0;
        this.filteredDataReadName = "Filtered-" + windowNumber + "-";
        this.runningConsensus = null;
        this.filteredDataConsensus = null;
        this.downsampleStrategy = downsampleStrategy;
        this.hasIndelQualities = hasIndelQualities;
        this.allowPolyploidReductionInGeneral = allowPolyploidReduction;
    }

    @Requires(value={"read != null"})
    @Ensures(value={"result != null"})
    public CompressionStash addRead(GATKSAMRecord read) {
        this.addToHeader(this.windowHeader, read);
        this.readsInWindow.add(read);
        return this.slideWindow(read.getUnclippedStart());
    }

    @Requires(value={"from >= 0", "from <= to", "to <= variantSite.length"})
    private FinishedGenomeLoc findNextVariantRegion(int from, int to, boolean[] variantSite, boolean closeLastRegion) {
        boolean foundStart = false;
        int windowHeaderStart = this.getStartLocation(this.windowHeader);
        int variantRegionStartIndex = 0;
        for (int i = from; i < to; ++i) {
            if (variantSite[i] && !foundStart) {
                variantRegionStartIndex = i;
                foundStart = true;
                continue;
            }
            if (variantSite[i] || !foundStart) continue;
            return new FinishedGenomeLoc(this.contig, this.contigIndex, windowHeaderStart + variantRegionStartIndex, windowHeaderStart + i - 1, true);
        }
        int refStart = windowHeaderStart + variantRegionStartIndex;
        int refStop = windowHeaderStart + to - 1;
        return foundStart && closeLastRegion ? new FinishedGenomeLoc(this.contig, this.contigIndex, refStart, refStop, true) : null;
    }

    @Requires(value={"from >= 0", "from <= to", "to <= variantSite.length"})
    @Ensures(value={"result != null"})
    protected CompressionStash findVariantRegions(int from, int to, boolean[] variantSite, boolean closeLastRegion) {
        FinishedGenomeLoc result;
        int windowHeaderStart = this.getStartLocation(this.windowHeader);
        CompressionStash regions = new CompressionStash();
        int index = from;
        while (index < to && (result = this.findNextVariantRegion(index, to, variantSite, closeLastRegion)) != null) {
            regions.add(result);
            if (!result.isFinished()) break;
            index = result.getStop() - windowHeaderStart + 1;
        }
        return regions;
    }

    protected CompressionStash slideWindow(int incomingReadUnclippedStart) {
        int windowHeaderStartLocation = this.getStartLocation(this.windowHeader);
        CompressionStash regions = emptyRegions;
        boolean forceClose = true;
        if (incomingReadUnclippedStart - this.contextSize > windowHeaderStartLocation) {
            this.markSites(incomingReadUnclippedStart);
            int readStartHeaderIndex = incomingReadUnclippedStart - windowHeaderStartLocation;
            int breakpoint = Math.max(readStartHeaderIndex - this.contextSize - 1, 0);
            regions = this.findVariantRegions(0, breakpoint, this.markedSites.getVariantSiteBitSet(), !forceClose);
        }
        while (!this.readsInWindow.isEmpty() && this.readsInWindow.first().getSoftEnd() < windowHeaderStartLocation) {
            this.readsInWindow.pollFirst();
        }
        return regions;
    }

    protected void markSites(int stop) {
        int i;
        int windowHeaderStartLocation = this.getStartLocation(this.windowHeader);
        int sizeOfMarkedRegion = stop - windowHeaderStartLocation + this.contextSize + 1;
        int lastPositionMarked = this.markedSites.updateRegion(windowHeaderStartLocation, sizeOfMarkedRegion) - this.contextSize - 1;
        int locationToProcess = Math.min(lastPositionMarked, stop - this.contextSize);
        Iterator headerElementIterator = this.windowHeader.iterator();
        for (i = windowHeaderStartLocation; i < locationToProcess; ++i) {
            if (!headerElementIterator.hasNext()) continue;
            headerElementIterator.next();
        }
        for (i = locationToProcess; i < stop && headerElementIterator.hasNext(); ++i) {
            HeaderElement headerElement = (HeaderElement)headerElementIterator.next();
            if (!headerElement.isVariant(this.MIN_ALT_BASE_PROPORTION_TO_TRIGGER_VARIANT, this.MIN_INDEL_BASE_PROPORTION_TO_TRIGGER_VARIANT)) continue;
            this.markVariantRegion(this.markedSites, i - windowHeaderStartLocation);
        }
    }

    protected void markVariantRegion(MarkedSites markedSites, int variantSiteLocation) {
        int from = variantSiteLocation < this.contextSize ? 0 : variantSiteLocation - this.contextSize;
        int to = variantSiteLocation + this.contextSize + 1 > markedSites.getVariantSiteBitSet().length ? markedSites.getVariantSiteBitSet().length : variantSiteLocation + this.contextSize + 1;
        for (int i = from; i < to; ++i) {
            markedSites.getVariantSiteBitSet()[i] = true;
        }
    }

    @Requires(value={"start >= 0 && (end >= start || end == 0)"})
    @Ensures(value={"result != null"})
    protected List<GATKSAMRecord> addToSyntheticReads(LinkedList<HeaderElement> header, int start, int end, boolean isNegativeStrand) {
        LinkedList<GATKSAMRecord> reads = new LinkedList<GATKSAMRecord>();
        if (start < end) {
            ListIterator<HeaderElement> headerElementIterator = header.listIterator(start);
            if (!headerElementIterator.hasNext()) {
                throw new ReviewedStingException(String.format("Requested to add to synthetic reads a region that contains no header element at index: %d  - %d / %d", start, header.size(), end));
            }
            HeaderElement headerElement = headerElementIterator.next();
            if (headerElement.hasConsensusData()) {
                reads.addAll(this.finalizeAndAdd(ConsensusType.FILTERED));
                int endOfConsensus = this.findNextNonConsensusElement(header, start, end);
                this.addToRunningConsensus(header, start, endOfConsensus, isNegativeStrand);
                if (endOfConsensus <= start) {
                    throw new ReviewedStingException(String.format("next start is <= current start: (%d <= %d)", endOfConsensus, start));
                }
                reads.addAll(this.addToSyntheticReads(header, endOfConsensus, end, isNegativeStrand));
            } else if (headerElement.hasFilteredData()) {
                reads.addAll(this.finalizeAndAdd(ConsensusType.CONSENSUS));
                int endOfFilteredData = this.findNextNonFilteredDataElement(header, start, end);
                reads.addAll(this.addToFilteredData(header, start, endOfFilteredData, isNegativeStrand));
                if (endOfFilteredData <= start) {
                    throw new ReviewedStingException(String.format("next start is <= current start: (%d <= %d)", endOfFilteredData, start));
                }
                reads.addAll(this.addToSyntheticReads(header, endOfFilteredData, end, isNegativeStrand));
            } else if (headerElement.isEmpty()) {
                reads.addAll(this.finalizeAndAdd(ConsensusType.BOTH));
                int endOfEmptyData = this.findNextNonEmptyElement(header, start, end);
                if (endOfEmptyData <= start) {
                    throw new ReviewedStingException(String.format("next start is <= current start: (%d <= %d)", endOfEmptyData, start));
                }
                reads.addAll(this.addToSyntheticReads(header, endOfEmptyData, end, isNegativeStrand));
            } else {
                throw new ReviewedStingException(String.format("Header Element %d is neither Consensus, Data or Empty. Something is wrong.", start));
            }
        }
        return reads;
    }

    private List<GATKSAMRecord> finalizeAndAdd(ConsensusType type) {
        GATKSAMRecord read = null;
        LinkedList<GATKSAMRecord> list = new LinkedList<GATKSAMRecord>();
        switch (type) {
            case CONSENSUS: {
                read = this.finalizeRunningConsensus();
                break;
            }
            case FILTERED: {
                read = this.finalizeFilteredDataConsensus();
                break;
            }
            case BOTH: {
                read = this.finalizeRunningConsensus();
                if (read != null) {
                    list.add(read);
                }
                read = this.finalizeFilteredDataConsensus();
            }
        }
        if (read != null) {
            list.add(read);
        }
        return list;
    }

    private int findNextNonConsensusElement(LinkedList<HeaderElement> header, int start, int upTo) {
        int index;
        ListIterator<HeaderElement> headerElementIterator = header.listIterator(start);
        for (index = start; index < upTo; ++index) {
            if (!headerElementIterator.hasNext()) {
                throw new ReviewedStingException("There are no more header elements in this window");
            }
            HeaderElement headerElement = (HeaderElement)headerElementIterator.next();
            if (!headerElement.hasConsensusData()) break;
        }
        return index;
    }

    private int findNextNonFilteredDataElement(LinkedList<HeaderElement> header, int start, int upTo) {
        int index;
        ListIterator<HeaderElement> headerElementIterator = header.listIterator(start);
        for (index = start; index < upTo; ++index) {
            if (!headerElementIterator.hasNext()) {
                throw new ReviewedStingException("There are no more header elements in this window");
            }
            HeaderElement headerElement = (HeaderElement)headerElementIterator.next();
            if (!headerElement.hasFilteredData() || headerElement.hasConsensusData()) break;
        }
        return index;
    }

    private int findNextNonEmptyElement(LinkedList<HeaderElement> header, int start, int upTo) {
        int index;
        ListIterator<HeaderElement> headerElementIterator = header.listIterator(start);
        for (index = start; index < upTo; ++index) {
            if (!headerElementIterator.hasNext()) {
                throw new ReviewedStingException("There are no more header elements in this window");
            }
            HeaderElement headerElement = headerElementIterator.next();
            if (!headerElement.isEmpty()) break;
        }
        return index;
    }

    @Requires(value={"start >= 0 && (end >= start || end == 0)"})
    @Ensures(value={"result != null"})
    private List<GATKSAMRecord> addToFilteredData(LinkedList<HeaderElement> header, int start, int end, boolean isNegativeStrand) {
        ArrayList<GATKSAMRecord> result = new ArrayList<GATKSAMRecord>(0);
        if (this.filteredDataConsensus == null) {
            this.filteredDataConsensus = new SyntheticRead(this.samHeader, this.readGroupAttribute, this.contig, this.contigIndex, this.filteredDataReadName + this.filteredDataConsensusCounter++, header.get(start).getLocation(), "RR", this.hasIndelQualities, isNegativeStrand);
        }
        ListIterator<HeaderElement> headerElementIterator = header.listIterator(start);
        for (int index = start; index < end; ++index) {
            if (!headerElementIterator.hasNext()) {
                throw new ReviewedStingException("Requested to create a filtered data synthetic read from " + start + " to " + end + " but " + index + " does not exist");
            }
            HeaderElement headerElement = headerElementIterator.next();
            if (headerElement.hasConsensusData()) {
                throw new ReviewedStingException("Found consensus data inside region to add to filtered data.");
            }
            if (!headerElement.hasFilteredData()) {
                throw new ReviewedStingException("No filtered data in " + index);
            }
            if (this.filteredDataConsensus.getRefStart() + this.filteredDataConsensus.size() != headerElement.getLocation()) {
                result.add(this.finalizeFilteredDataConsensus());
                this.filteredDataConsensus = new SyntheticRead(this.samHeader, this.readGroupAttribute, this.contig, this.contigIndex, this.filteredDataReadName + this.filteredDataConsensusCounter++, headerElement.getLocation(), "RR", this.hasIndelQualities, isNegativeStrand);
            }
            this.genericAddBaseToConsensus(this.filteredDataConsensus, headerElement.getFilteredBaseCounts(), headerElement.getRMS());
        }
        return result;
    }

    @Requires(value={"start >= 0 && (end >= start || end == 0)"})
    private void addToRunningConsensus(LinkedList<HeaderElement> header, int start, int end, boolean isNegativeStrand) {
        if (this.runningConsensus == null) {
            this.runningConsensus = new SyntheticRead(this.samHeader, this.readGroupAttribute, this.contig, this.contigIndex, this.consensusReadName + this.consensusCounter++, header.get(start).getLocation(), "RR", this.hasIndelQualities, isNegativeStrand);
        }
        ListIterator<HeaderElement> headerElementIterator = header.listIterator(start);
        for (int index = start; index < end; ++index) {
            if (!headerElementIterator.hasNext()) {
                throw new ReviewedStingException("Requested to create a running consensus synthetic read from " + start + " to " + end + " but " + index + " does not exist");
            }
            HeaderElement headerElement = (HeaderElement)headerElementIterator.next();
            if (!headerElement.hasConsensusData()) {
                throw new ReviewedStingException("No CONSENSUS data in " + index);
            }
            this.genericAddBaseToConsensus(this.runningConsensus, headerElement.getConsensusBaseCounts(), headerElement.getRMS());
        }
    }

    private void genericAddBaseToConsensus(SyntheticRead syntheticRead, BaseAndQualsCounts baseCounts, double rms) {
        BaseIndex base = baseCounts.baseIndexWithMostProbability();
        byte count = (byte)Math.min(baseCounts.countOfBase(base), 127);
        byte qual = baseCounts.averageQualsOfBase(base);
        byte insQual = baseCounts.averageInsertionQualsOfBase(base);
        byte delQual = baseCounts.averageDeletionQualsOfBase(base);
        syntheticRead.add(base, count, qual, insQual, delQual, rms);
    }

    @Requires(value={"start >= 0 && (stop >= start || stop == 0)"})
    @Ensures(value={"result != null"})
    protected List<GATKSAMRecord> compressVariantRegion(int start, int stop, boolean disallowPolyploidReductionAtThisPosition) {
        LinkedList<GATKSAMRecord> allReads = new LinkedList();
        int nVariantPositions = 0;
        int hetRefPosition = -1;
        boolean canCompress = true;
        Object[] header = this.windowHeader.toArray();
        if (this.allowPolyploidReductionInGeneral && !disallowPolyploidReductionAtThisPosition) {
            for (int i = start; i <= stop; ++i) {
                int nAlleles = ((HeaderElement)header[i]).getNumberOfAlleles(this.MIN_ALT_BASE_PROPORTION_TO_TRIGGER_VARIANT);
                if (nAlleles > 2) {
                    canCompress = false;
                    break;
                }
                if (nAlleles != 2) continue;
                if (++nVariantPositions == 1) {
                    hetRefPosition = i;
                    continue;
                }
                if (nVariantPositions <= 1) continue;
                canCompress = false;
                break;
            }
        }
        if (canCompress && hetRefPosition != -1) {
            allReads = this.createPolyploidConsensus(start, stop, ((HeaderElement)header[hetRefPosition]).getLocation());
        } else {
            int refStart = this.windowHeader.get(start).getLocation();
            int refStop = this.windowHeader.get(stop).getLocation();
            LinkedList<GATKSAMRecord> toRemove = new LinkedList<GATKSAMRecord>();
            for (GATKSAMRecord read : this.readsInWindow) {
                if (read.getSoftStart() > refStop) continue;
                if (read.getAlignmentEnd() >= refStart) {
                    allReads.add(read);
                    this.removeFromHeader(this.windowHeader, read);
                }
                toRemove.add(read);
            }
            this.removeReadsFromWindow(toRemove);
        }
        return allReads;
    }

    @Requires(value={"start >= 0 && (stop >= start || stop == 0)"})
    @Ensures(value={"result != null"})
    protected List<GATKSAMRecord> closeVariantRegion(int start, int stop, boolean disallowPolyploidReductionAtThisPosition) {
        List<GATKSAMRecord> allReads = this.compressVariantRegion(start, stop, disallowPolyploidReductionAtThisPosition);
        List<GATKSAMRecord> result = this.downsampleCoverage > 0 ? this.downsampleVariantRegion(allReads) : allReads;
        result.addAll(this.addToSyntheticReads(this.windowHeader, 0, stop, false));
        result.addAll(this.finalizeAndAdd(ConsensusType.BOTH));
        return result;
    }

    public Set<GATKSAMRecord> closeVariantRegions(CompressionStash regions) {
        TreeSet<SAMRecord> allReads = new TreeSet<SAMRecord>(new AlignmentStartWithNoTiesComparator());
        if (!regions.isEmpty()) {
            int lastStop = -1;
            int windowHeaderStart = this.getStartLocation(this.windowHeader);
            for (FinishedGenomeLoc region : regions) {
                if (!region.isFinished() || region.getContig() != this.contig || region.getStart() < windowHeaderStart || region.getStop() >= windowHeaderStart + this.windowHeader.size()) continue;
                int start = region.getStart() - windowHeaderStart;
                int stop = region.getStop() - windowHeaderStart;
                allReads.addAll(this.closeVariantRegion(start, stop, regions.size() > 1));
                lastStop = stop;
            }
            if (lastStop >= 0) {
                for (int i = 0; i < lastStop; ++i) {
                    this.windowHeader.remove();
                }
                HeaderElement lastOfRegion = this.windowHeader.remove();
                if (lastOfRegion.hasInsertionToTheRight()) {
                    this.windowHeader.addFirst(new HeaderElement(lastOfRegion.getLocation(), lastOfRegion.numInsertionsToTheRight()));
                }
            }
        }
        return allReads;
    }

    @Requires(value={"allReads != null"})
    @Ensures(value={"result != null"})
    protected List<GATKSAMRecord> downsampleVariantRegion(List<GATKSAMRecord> allReads) {
        int nReads = allReads.size();
        if (nReads == 0) {
            return allReads;
        }
        if (this.downsampleCoverage >= nReads) {
            return allReads;
        }
        ReservoirDownsampler<GATKSAMRecord> downsampler = new ReservoirDownsampler<GATKSAMRecord>(this.downsampleCoverage);
        downsampler.submit(allReads);
        return downsampler.consumeFinalizedItems();
    }

    @Ensures(value={"result != null"})
    public Pair<Set<GATKSAMRecord>, CompressionStash> close() {
        Set<SAMRecord> finalizedReads = new TreeSet<SAMRecord>(new AlignmentStartWithNoTiesComparator());
        CompressionStash regions = new CompressionStash();
        boolean forceCloseUnfinishedRegions = true;
        if (!this.windowHeader.isEmpty()) {
            this.markSites(this.getStopLocation(this.windowHeader) + 1);
            regions = this.findVariantRegions(0, this.windowHeader.size(), this.markedSites.getVariantSiteBitSet(), forceCloseUnfinishedRegions);
            finalizedReads = this.closeVariantRegions(regions);
            if (!this.windowHeader.isEmpty()) {
                finalizedReads.addAll(this.addToSyntheticReads(this.windowHeader, 0, this.windowHeader.size(), false));
                finalizedReads.addAll(this.finalizeAndAdd(ConsensusType.BOTH));
            }
        }
        return new Pair<Set<GATKSAMRecord>, CompressionStash>(finalizedReads, regions);
    }

    protected GATKSAMRecord finalizeRunningConsensus() {
        GATKSAMRecord finalizedRead = null;
        if (this.runningConsensus != null) {
            if (this.runningConsensus.size() > 0) {
                finalizedRead = this.runningConsensus.close();
            } else {
                --this.consensusCounter;
            }
            this.runningConsensus = null;
        }
        return finalizedRead;
    }

    protected GATKSAMRecord finalizeFilteredDataConsensus() {
        GATKSAMRecord finalizedRead = null;
        if (this.filteredDataConsensus != null) {
            if (this.filteredDataConsensus.size() > 0) {
                finalizedRead = this.filteredDataConsensus.close();
            } else {
                --this.filteredDataConsensusCounter;
            }
            this.filteredDataConsensus = null;
        }
        return finalizedRead;
    }

    @Requires(value={"start >= 0 && (stop >= start || stop == 0)"})
    @Ensures(value={"result != null"})
    private List<GATKSAMRecord> createPolyploidConsensus(int start, int stop, int hetRefPosition) {
        ArrayList headersPosStrand = new ArrayList();
        ArrayList headersNegStrand = new ArrayList();
        LinkedList<GATKSAMRecord> hetReads = new LinkedList<GATKSAMRecord>();
        HashMap<Byte, Integer> haplotypeHeaderMap = new HashMap<Byte, Integer>(2);
        int currentHaplotype = 0;
        int refStart = this.windowHeader.get(start).getLocation();
        int refStop = this.windowHeader.get(stop).getLocation();
        LinkedList<GATKSAMRecord> toRemove = new LinkedList<GATKSAMRecord>();
        for (GATKSAMRecord gATKSAMRecord : this.readsInWindow) {
            if (gATKSAMRecord.getSoftStart() > refStop) continue;
            if (gATKSAMRecord.getMappingQuality() >= this.MIN_MAPPING_QUALITY && gATKSAMRecord.getSoftEnd() >= refStart && gATKSAMRecord.getSoftStart() <= hetRefPosition && gATKSAMRecord.getSoftEnd() >= hetRefPosition) {
                int readPos = ReadUtils.getReadCoordinateForReferenceCoordinate(gATKSAMRecord, hetRefPosition, ReadUtils.ClippingTail.LEFT_TAIL);
                byte base = gATKSAMRecord.getReadBases()[readPos];
                byte qual = gATKSAMRecord.getBaseQualities(EventType.BASE_SUBSTITUTION)[readPos];
                if (qual >= this.MIN_BASE_QUAL_TO_COUNT) {
                    int haplotype;
                    if (haplotypeHeaderMap.containsKey(base)) {
                        haplotype = (Integer)haplotypeHeaderMap.get(base);
                    } else {
                        haplotype = currentHaplotype;
                        haplotypeHeaderMap.put(base, currentHaplotype);
                        headersPosStrand.add(new LinkedList());
                        headersNegStrand.add(new LinkedList());
                        ++currentHaplotype;
                    }
                    LinkedList header = gATKSAMRecord.getReadNegativeStrandFlag() ? (LinkedList)headersNegStrand.get(haplotype) : (LinkedList)headersPosStrand.get(haplotype);
                    this.addToHeader(header, gATKSAMRecord);
                    this.removeFromHeader(this.windowHeader, gATKSAMRecord);
                }
            }
            toRemove.add(gATKSAMRecord);
        }
        for (LinkedList linkedList : headersPosStrand) {
            if (linkedList.size() > 0) {
                hetReads.addAll(this.addToSyntheticReads(linkedList, 0, linkedList.size(), false));
            }
            if (this.runningConsensus == null) continue;
            hetReads.add(this.finalizeRunningConsensus());
        }
        for (LinkedList linkedList : headersNegStrand) {
            if (linkedList.size() > 0) {
                hetReads.addAll(this.addToSyntheticReads(linkedList, 0, linkedList.size(), true));
            }
            if (this.runningConsensus == null) continue;
            hetReads.add(this.finalizeRunningConsensus());
        }
        this.removeReadsFromWindow(toRemove);
        return hetReads;
    }

    private void addToHeader(LinkedList<HeaderElement> header, GATKSAMRecord read) {
        this.updateHeaderCounts(header, read, false);
    }

    private void removeFromHeader(LinkedList<HeaderElement> header, GATKSAMRecord read) {
        this.updateHeaderCounts(header, read, true);
    }

    private void updateHeaderCounts(LinkedList<HeaderElement> header, GATKSAMRecord read, boolean removeRead) {
        byte[] bases = read.getReadBases();
        byte[] quals = read.getBaseQualities();
        byte[] insQuals = read.getExistingBaseInsertionQualities();
        byte[] delQuals = read.getExistingBaseDeletionQualities();
        int readStart = read.getSoftStart();
        int readEnd = read.getSoftEnd();
        Cigar cigar = read.getCigar();
        int readBaseIndex = 0;
        int startLocation = this.getStartLocation(header);
        int locationIndex = startLocation < 0 ? 0 : readStart - startLocation;
        int stopLocation = this.getStopLocation(header);
        if (removeRead && locationIndex < 0) {
            throw new ReviewedStingException("read is behind the Sliding Window. read: " + read + " start " + read.getUnclippedStart() + "," + read.getUnclippedEnd() + " cigar: " + read.getCigarString() + " window: " + startLocation + "," + stopLocation);
        }
        if (!removeRead) {
            if (locationIndex < 0) {
                for (int i = 1; i <= -locationIndex; ++i) {
                    header.addFirst(new HeaderElement(startLocation - i));
                }
                startLocation = readStart;
                locationIndex = 0;
            }
            if (stopLocation < readEnd) {
                int elementsToAdd;
                int n = elementsToAdd = stopLocation < 0 ? readEnd - readStart + 1 : readEnd - stopLocation;
                while (elementsToAdd-- > 0) {
                    header.addLast(new HeaderElement(readEnd - elementsToAdd));
                }
            }
            if (ReadUtils.readStartsWithInsertion(read).getFirst().booleanValue() && (readStart == startLocation || startLocation < 0)) {
                header.addFirst(new HeaderElement(readStart - 1));
                locationIndex = 1;
            }
        }
        ListIterator<HeaderElement> headerElementIterator = header.listIterator(locationIndex);
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            switch (cigarElement.getOperator()) {
                case H: {
                    break;
                }
                case I: {
                    if (removeRead && locationIndex == 0) break;
                    HeaderElement headerElement = header.get(locationIndex - 1);
                    if (removeRead) {
                        headerElement.removeInsertionToTheRight();
                    } else {
                        headerElement.addInsertionToTheRight();
                    }
                    readBaseIndex += cigarElement.getLength();
                    break;
                }
                case D: {
                    HeaderElement headerElement;
                    int nDeletions = cigarElement.getLength();
                    while (nDeletions-- > 0) {
                        headerElement = (HeaderElement)headerElementIterator.next();
                        byte mq = (byte)read.getMappingQuality();
                        if (removeRead) {
                            headerElement.removeBase((byte)68, mq, mq, mq, mq, this.MIN_BASE_QUAL_TO_COUNT, this.MIN_MAPPING_QUALITY, false);
                        } else {
                            headerElement.addBase((byte)68, mq, mq, mq, mq, this.MIN_BASE_QUAL_TO_COUNT, this.MIN_MAPPING_QUALITY, false);
                        }
                        ++locationIndex;
                    }
                    break;
                }
                case S: 
                case M: 
                case P: 
                case EQ: 
                case X: {
                    HeaderElement headerElement;
                    int nBasesToAdd = cigarElement.getLength();
                    while (nBasesToAdd-- > 0) {
                        byte deletionQuality;
                        headerElement = (HeaderElement)headerElementIterator.next();
                        byte insertionQuality = insQuals == null ? (byte)-1 : insQuals[readBaseIndex];
                        byte by = deletionQuality = delQuals == null ? (byte)-1 : delQuals[readBaseIndex];
                        if (removeRead) {
                            headerElement.removeBase(bases[readBaseIndex], quals[readBaseIndex], insertionQuality, deletionQuality, read.getMappingQuality(), this.MIN_BASE_QUAL_TO_COUNT, this.MIN_MAPPING_QUALITY, cigarElement.getOperator() == CigarOperator.S);
                        } else {
                            headerElement.addBase(bases[readBaseIndex], quals[readBaseIndex], insertionQuality, deletionQuality, read.getMappingQuality(), this.MIN_BASE_QUAL_TO_COUNT, this.MIN_MAPPING_QUALITY, cigarElement.getOperator() == CigarOperator.S);
                        }
                        ++readBaseIndex;
                        ++locationIndex;
                    }
                    break;
                }
            }
        }
    }

    private void removeReadsFromWindow(List<GATKSAMRecord> readsToRemove) {
        for (GATKSAMRecord read : readsToRemove) {
            this.readsInWindow.remove(read);
        }
    }

    protected final class MarkedSites {
        private boolean[] siteIsVariant = new boolean[0];
        private int startLocation = 0;

        public boolean[] getVariantSiteBitSet() {
            return this.siteIsVariant;
        }

        protected int getStartLocation() {
            return this.startLocation;
        }

        public int updateRegion(int newStartLocation, int sizeOfRegion) {
            int lastPositionMarked = sizeOfRegion;
            if (newStartLocation >= this.startLocation + this.siteIsVariant.length || newStartLocation < this.startLocation) {
                this.siteIsVariant = new boolean[sizeOfRegion];
                lastPositionMarked = 0;
            } else if (newStartLocation != this.startLocation || sizeOfRegion != this.siteIsVariant.length) {
                boolean[] tempArray = new boolean[sizeOfRegion];
                int differenceInStartPositions = newStartLocation - this.startLocation;
                lastPositionMarked = Math.min(this.siteIsVariant.length - differenceInStartPositions, sizeOfRegion);
                System.arraycopy(this.siteIsVariant, differenceInStartPositions, tempArray, 0, lastPositionMarked);
                this.siteIsVariant = null;
                this.siteIsVariant = tempArray;
            }
            this.startLocation = newStartLocation;
            return lastPositionMarked + newStartLocation;
        }
    }

    private static enum ConsensusType {
        CONSENSUS,
        FILTERED,
        BOTH;

    }
}

