/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.compression.reducereads;

import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import org.broadinstitute.sting.gatk.walkers.compression.reducereads.BaseIndex;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class SyntheticRead {
    private static final BaseIndex[] BaseIndexByOrdinal = new BaseIndex[BaseIndex.values().length];
    private final List<SingleBaseInfo> basesCountsQuals;
    private double mappingQuality;
    private String readTag;
    private SAMFileHeader header;
    private GATKSAMReadGroupRecord readGroupRecord;
    private String contig;
    private int contigIndex;
    private String readName;
    private int refStart;
    private boolean hasIndelQualities = false;
    private boolean isNegativeStrand = false;

    public SyntheticRead(SAMFileHeader header, GATKSAMReadGroupRecord readGroupRecord, String contig, int contigIndex, String readName, int refStart, String readTag, boolean hasIndelQualities, boolean isNegativeRead) {
        int initialCapacity = 10000;
        this.basesCountsQuals = new ArrayList<SingleBaseInfo>(10000);
        this.mappingQuality = 0.0;
        this.readTag = readTag;
        this.header = header;
        this.readGroupRecord = readGroupRecord;
        this.contig = contig;
        this.contigIndex = contigIndex;
        this.readName = readName;
        this.refStart = refStart;
        this.hasIndelQualities = hasIndelQualities;
        this.isNegativeStrand = isNegativeRead;
    }

    public SyntheticRead(List<BaseIndex> bases, List<Byte> counts, List<Byte> quals, List<Byte> insertionQuals, List<Byte> deletionQuals, double mappingQuality, String readTag, SAMFileHeader header, GATKSAMReadGroupRecord readGroupRecord, String contig, int contigIndex, String readName, int refStart, boolean hasIndelQualities, boolean isNegativeRead) {
        this.basesCountsQuals = new ArrayList<SingleBaseInfo>(bases.size());
        for (int i = 0; i < bases.size(); ++i) {
            this.basesCountsQuals.add(new SingleBaseInfo(bases.get(i).getOrdinalByte(), counts.get(i), quals.get(i), insertionQuals.get(i), deletionQuals.get(i)));
        }
        this.mappingQuality = mappingQuality;
        this.readTag = readTag;
        this.header = header;
        this.readGroupRecord = readGroupRecord;
        this.contig = contig;
        this.contigIndex = contigIndex;
        this.readName = readName;
        this.refStart = refStart;
        this.hasIndelQualities = hasIndelQualities;
        this.isNegativeStrand = isNegativeRead;
    }

    @Requires(value={"count <= Byte.MAX_VALUE"})
    public void add(BaseIndex base, byte count, byte qual, byte insQual, byte delQual, double mappingQuality) {
        this.basesCountsQuals.add(new SingleBaseInfo(base.getOrdinalByte(), count, qual, insQual, delQual));
        this.mappingQuality += mappingQuality;
    }

    public BaseIndex getBase(int readCoordinate) {
        return BaseIndexByOrdinal[this.basesCountsQuals.get((int)readCoordinate).baseIndexOrdinal];
    }

    public int getRefStart() {
        return this.refStart;
    }

    public GATKSAMRecord close() {
        if (this.isAllDeletions()) {
            return null;
        }
        GATKSAMRecord read = new GATKSAMRecord(this.header);
        read.setReferenceName(this.contig);
        read.setReferenceIndex(this.contigIndex);
        read.setReadPairedFlag(false);
        read.setReadUnmappedFlag(false);
        read.setReadNegativeStrandFlag(this.isNegativeStrand);
        read.setCigar(this.buildCigar());
        read.setAlignmentStart(this.refStart);
        read.setReadName(this.readName);
        read.setBaseQualities(this.convertBaseQualities(), EventType.BASE_SUBSTITUTION);
        read.setReadBases(this.convertReadBases());
        read.setMappingQuality((int)Math.ceil(this.mappingQuality / (double)this.basesCountsQuals.size()));
        read.setReadGroup(this.readGroupRecord);
        read.setAttribute(this.readTag, (Object)this.convertBaseCounts());
        if (this.hasIndelQualities) {
            read.setBaseQualities(this.convertInsertionQualities(), EventType.BASE_INSERTION);
            read.setBaseQualities(this.convertDeletionQualities(), EventType.BASE_DELETION);
        }
        return read;
    }

    private boolean isAllDeletions() {
        for (SingleBaseInfo b : this.basesCountsQuals) {
            if (b.baseIndexOrdinal == BaseIndex.D.getOrdinalByte()) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.basesCountsQuals.size();
    }

    private byte[] convertBaseQualities() {
        return this.convertVariableGivenBases(new SingleBaseInfoIterator(){

            @Override
            public Byte next() {
                return ((SingleBaseInfo)this.it.next()).qual;
            }
        });
    }

    private byte[] convertInsertionQualities() {
        return this.convertVariableGivenBases(new SingleBaseInfoIterator(){

            @Override
            public Byte next() {
                return ((SingleBaseInfo)this.it.next()).insertionQual;
            }
        });
    }

    private byte[] convertDeletionQualities() {
        return this.convertVariableGivenBases(new SingleBaseInfoIterator(){

            @Override
            public Byte next() {
                return ((SingleBaseInfo)this.it.next()).deletionQual;
            }
        });
    }

    protected byte[] convertBaseCounts() {
        byte[] countsArray = this.convertVariableGivenBases(new SingleBaseInfoIterator(){

            @Override
            public Byte next() {
                return ((SingleBaseInfo)this.it.next()).count;
            }
        });
        if (countsArray.length == 0) {
            throw new ReviewedStingException("Reduced read has counts array of length 0");
        }
        byte[] compressedCountsArray = new byte[countsArray.length];
        compressedCountsArray[0] = countsArray[0];
        for (int i = 1; i < countsArray.length; ++i) {
            compressedCountsArray[i] = (byte)MathUtils.bound(countsArray[i] - compressedCountsArray[0], -128.0, 127.0);
        }
        return compressedCountsArray;
    }

    private byte[] convertReadBases() {
        byte[] readArray = new byte[this.getReadLengthWithNoDeletions()];
        int i = 0;
        for (SingleBaseInfo singleBaseInfo : this.basesCountsQuals) {
            BaseIndex baseIndex = BaseIndexByOrdinal[singleBaseInfo.baseIndexOrdinal];
            if (baseIndex == BaseIndex.D) continue;
            readArray[i++] = baseIndex.getByte();
        }
        return readArray;
    }

    private Cigar buildCigar() {
        LinkedList<CigarElement> cigarElements = new LinkedList<CigarElement>();
        CigarOperator cigarOperator = null;
        int length = 0;
        for (SingleBaseInfo singleBaseInfo : this.basesCountsQuals) {
            CigarOperator op;
            BaseIndex b = BaseIndexByOrdinal[singleBaseInfo.baseIndexOrdinal];
            switch (b) {
                case D: {
                    op = CigarOperator.DELETION;
                    break;
                }
                case I: {
                    throw new ReviewedStingException("Trying to create an insertion in a synthetic read. This operation is currently unsupported.");
                }
                default: {
                    op = CigarOperator.MATCH_OR_MISMATCH;
                }
            }
            if (cigarOperator == null) {
                if (op == CigarOperator.D) {
                    ++this.refStart;
                } else {
                    cigarOperator = op;
                }
            } else if (cigarOperator != op) {
                cigarElements.add(new CigarElement(length, cigarOperator));
                cigarOperator = op;
                length = 0;
            }
            if (cigarOperator == null) continue;
            ++length;
        }
        if (length > 0 && cigarOperator != CigarOperator.D) {
            cigarElements.add(new CigarElement(length, cigarOperator));
        }
        return new Cigar(cigarElements);
    }

    private byte[] convertVariableGivenBases(Iterator<Byte> variableIterator) {
        byte[] variableArray = new byte[this.getReadLengthWithNoDeletions()];
        int i = 0;
        for (SingleBaseInfo singleBaseInfo : this.basesCountsQuals) {
            byte count = variableIterator.next();
            if (singleBaseInfo.baseIndexOrdinal == BaseIndex.D.getOrdinalByte()) continue;
            variableArray[i++] = count;
        }
        return variableArray;
    }

    private int getReadLengthWithNoDeletions() {
        int readLength = this.basesCountsQuals.size();
        for (SingleBaseInfo singleBaseInfo : this.basesCountsQuals) {
            if (singleBaseInfo.baseIndexOrdinal != BaseIndex.D.getOrdinalByte()) continue;
            --readLength;
        }
        return readLength;
    }

    static {
        BaseIndex[] arr$ = BaseIndex.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            BaseIndex baseIndex;
            SyntheticRead.BaseIndexByOrdinal[baseIndex.ordinal()] = baseIndex = arr$[i$];
        }
    }

    private abstract class SingleBaseInfoIterator
    implements Iterator<Byte> {
        final Iterator<SingleBaseInfo> it;

        SingleBaseInfoIterator() {
            this.it = SyntheticRead.this.basesCountsQuals.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SingleBaseInfo {
        byte baseIndexOrdinal;
        byte count;
        byte qual;
        byte insertionQual;
        byte deletionQual;

        SingleBaseInfo(byte baseIndexOrdinal, byte count, byte qual, byte insertionQual, byte deletionQual) {
            this.baseIndexOrdinal = baseIndexOrdinal;
            this.count = count;
            this.qual = qual;
            this.insertionQual = insertionQual;
            this.deletionQual = deletionQual;
        }
    }
}

